/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.CsHandleDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.collaboration.data.api.AddressType;
import com.avaya.collaboration.data.api.model.UserHandleSubType;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ZephyrCsHandleDAO
extends CsHandleDAO {
    private final Logger log = AsmLogger.getLogger(ZephyrCsHandleDAO.class);
    private Map<String, Long> handleTypeMap = new ConcurrentHashMap<String, Long>();
    private Map<String, UserHandleSubType> handleSubTypeMap = new ConcurrentHashMap<String, UserHandleSubType>();
    private final String getAllHandleTypes = "SELECT id, name FROM cshandletypeenum";
    private final String getAllHandleSubTypes = "SELECT id, name, cshandletypeid FROM cshandlesubtypeenum";
    private String getHandleByTypeAndSubType = "SELECT id, handle, csdomainid, credential, cscommprofilesetid, cshandletypeid, cshandlesubtypeid FROM cshandle WHERE csdomainid = ? AND handle = ? AND cshandletypeid = ? AND cshandlesubtypeid = ?";
    protected static final ResultSetMapper handleTypeMapper = new ResultSetMapper(){

        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, Long> map = new HashMap<String, Long>();
            while (rs.next()) {
                map.put(rs.getString("name"), rs.getLong("id"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper handleSubTypeMapper = new ResultSetMapper(){

        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, UserHandleSubType> map = new HashMap<String, UserHandleSubType>();
            while (rs.next()) {
                UserHandleSubType obj = new UserHandleSubType();
                obj.setId(rs.getLong("id"));
                obj.setName(rs.getString("name"));
                obj.setTypeId(rs.getLong("cshandletypeid"));
                map.put(obj.getName(), obj);
            }
            return map;
        }
    };
    protected static final ResultSetMapper csHandleMapper = new ResultSetMapper(){

        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, CsHandle> map = new HashMap<Long, CsHandle>();
            while (rs.next()) {
                map.put(rs.getLong("id"), new CsHandle(rs.getLong("id"), rs.getString("handle"), rs.getLong("csdomainid"), rs.getString("credential"), rs.getLong("cscommprofilesetid"), rs.getLong("cshandletypeid"), (Long)rs.getObject("cshandlesubtypeid")));
            }
            return map;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map handleSubTypeMapTMP;
        Map handleTypeMapTMP;
        DataMgr.Status csHandleDaoStatus;
        if (ZephyrDM.isMgmtServer()) {
            this.log.info((Object)"Skipping initialization of ZephyrCsHandleDAO on management server.");
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + ZephyrCsHandleDAO.class.getSimpleName()));
        }
        if ((csHandleDaoStatus = super.getStatus()) != DataMgr.Status.OKAY) {
            super.init();
        }
        if ((csHandleDaoStatus = super.getStatus()) != DataMgr.Status.OKAY) {
            this.setStatus(DataMgr.Status.FAIL);
            return;
        }
        Object[] params = new Object[]{};
        try {
            handleTypeMapTMP = (Map)this.dataSource.executeQuery("SELECT id, name FROM cshandletypeenum", params, (Object)handleTypeMapper);
            handleSubTypeMapTMP = (Map)this.dataSource.executeQuery("SELECT id, name, cshandletypeid FROM cshandlesubtypeenum", params, (Object)handleSubTypeMapper);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName() + ": " + (Object)((Object)e)));
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.handleTypeMap = handleTypeMapTMP;
                this.handleSubTypeMap = handleSubTypeMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    public void updateDAO(DAOTableEvent event) {
        this.log.fine((Object)("updateDAO ENTER ----" + event));
        super.updateDAO(event);
    }

    public CsHandle getHandle(String handleString, String domain, AddressType addressType, long csDomainId) {
        this.log.fine((Object)"getHandle ENTER ---- ");
        long handleTypeValue = 0L;
        long handleTypeId = 0L;
        long handleSubtypeId = 0L;
        if (addressType != null) {
            if (this.handleTypeMap.get(addressType.getValue()) == null || this.handleTypeMap.get(addressType.getValue()) == 0L) {
                handleTypeId = this.handleSubTypeMap.get(addressType.getValue()).getTypeId();
                handleSubtypeId = this.handleSubTypeMap.get(addressType.getValue()).getId();
                handleTypeValue = Long.parseLong(String.valueOf(handleTypeId).concat(String.valueOf(handleSubtypeId)));
            } else {
                handleTypeId = this.handleTypeMap.get(addressType.getValue());
                handleSubtypeId = 0L;
                handleTypeValue = Long.parseLong(String.valueOf(handleTypeId).concat(String.valueOf(handleSubtypeId)));
            }
        } else {
            handleTypeId = this.handleSubTypeMap.get(AddressType.AVAYA_SIP.getValue()).getTypeId();
            handleSubtypeId = this.handleSubTypeMap.get(AddressType.AVAYA_SIP.getValue()).getId();
            handleTypeValue = Long.parseLong(String.valueOf(handleTypeId).concat(String.valueOf(handleSubtypeId)));
        }
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getHandle : handleTypeValue = " + handleTypeValue + ", handleTypeId = " + handleTypeId + " and handleSubtypeId = " + handleSubtypeId));
        }
        String handleMapKey = this.getHandleMapKey(handleString, csDomainId);
        boolean handleWithDomain = this.isHandleWithDomain(handleTypeId, handleSubtypeId);
        if (handleWithDomain) {
            handleMapKey = handleMapKey + '@' + domain;
        }
        return this.findCsHandle(handleString, csDomainId, handleTypeId, handleSubtypeId, handleMapKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsHandle findCsHandle(String handleString, long csDomainId, long handleTypeId, long handleSubtypeId, String handleMapKey) {
        try {
            this.lock.acquireReadLock();
            Map handles = (Map)this.handleMap.get(csDomainId);
            if (handles != null && (this.survivabilityServerId == null || handles.containsKey(handleMapKey))) {
                CsHandle csHandle = this.searchCsHandleInCache(handleTypeId, handleSubtypeId, handleMapKey, handles);
                if (csHandle != null) {
                    CsHandle csHandle2 = csHandle;
                    return csHandle2;
                }
                if (this.survivabilityServerId == null) {
                    this.log.finer((Object)"getHandle EXIT : return null as survivabilityServerId is null");
                    CsHandle csHandle3 = null;
                    return csHandle3;
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        Map<Long, CsHandle> map = this.getHandleMapFromDB(handleString, csDomainId, handleTypeId, handleSubtypeId);
        this.log.finer((Object)"getHandle EXIT : return null");
        return this.searchForCsHandle(handleMapKey, map);
    }

    private CsHandle searchCsHandleInCache(long handleTypeId, long handleSubtypeId, String handleMapKey, Map<String, Object> handles) {
        Object csHandle = handles.get(handleMapKey);
        if (csHandle != null) {
            if (!(csHandle instanceof List)) {
                if (this.handleMatches((CsHandle)csHandle, handleMapKey)) {
                    this.log.finer((Object)("getHandle EXIT : return csHandle = " + csHandle));
                    return (CsHandle)csHandle;
                }
            } else {
                List handleList = (List)csHandle;
                for (CsHandle handle : handleList) {
                    if (!this.handleMatches(handle, handleMapKey) || handle.getCsHandleTypeId() != handleTypeId || !this.subtypeIdMatches(handle.getCsHandleSubTypeId(), handleSubtypeId)) continue;
                    this.log.finer((Object)("getHandle EXIT : return csHandle = " + csHandle));
                    return handle;
                }
            }
        }
        return null;
    }

    private boolean isHandleWithDomain(long handleTypeId, long handleSubtypeId) {
        return handleTypeId != this.handleSubTypeMap.get(AddressType.AVAYA_SIP.getValue()).getTypeId() || handleSubtypeId != this.handleSubTypeMap.get(AddressType.AVAYA_E164.getValue()).getId() && handleSubtypeId != this.handleSubTypeMap.get(AddressType.AVAYA_SIP.getValue()).getId();
    }

    private boolean subtypeIdMatches(Long csHandleSubTypeId, long inputSubTypeId) {
        return csHandleSubTypeId == null ? inputSubTypeId == 0L : csHandleSubTypeId == inputSubTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, CsHandle> getHandleMapFromDB(String handleString, long csDomainId, long handleTypeId, long handleSubtypeId) {
        Object[] params = new Object[]{csDomainId, handleString, handleTypeId, handleSubtypeId};
        Map map = null;
        try {
            this.lock.acquireReadLock();
            map = (Map)this.dataSource.executeQuery(this.getHandleByTypeAndSubType, params, (Object)csHandleMapper);
        }
        catch (DMException e) {
            this.log.warn((Object)("Exception querying for handle with parameters " + handleString + " " + csDomainId + " Exception:" + e.getMessage()));
        }
        finally {
            this.lock.releaseReadLock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsHandle searchForCsHandle(String fullHandle, Map<Long, CsHandle> map) {
        if (map != null) {
            try {
                this.lock.acquireWriteLock();
                for (CsHandle handle : map.values()) {
                    if (!this.handleMatches(handle, fullHandle)) continue;
                    CsHandle csHandle = handle;
                    return csHandle;
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return null;
    }

    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cshandle");
        list.add("asmcommprofile");
        list.add("cshandletypeenum");
        list.add("cshandlesubtypeenum");
        list.add("csuser");
        return list;
    }

    @SMConsole(description="Get all cached SIP Handle objects.")
    public Map<Long, Map<String, Object>> getAllCsHandles() {
        this.lock.acquireReadLock();
        try {
            Map map = this.handleMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected String getGetAllHandleTypesQuery() {
        return "SELECT id, name FROM cshandletypeenum";
    }

    protected String getGetAllHandleSubTypesQuery() {
        return "SELECT id, name, cshandletypeid FROM cshandlesubtypeenum";
    }

    protected String getGetHandleByTypeAndSubTypeQuery() {
        return this.getHandleByTypeAndSubType;
    }

    @SMConsole(description="Get Handle by Address Type String")
    public CsHandle getCsHandle(String handleString, String domain, String addressType, long csDomainId) {
        AddressType addressType2 = AddressType.getAddressNameByValue((String)addressType);
        return this.getHandle(handleString, domain, addressType2, csDomainId);
    }
}

