/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.GUIPages;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.common.logging.client.Logger;
import com.avaya.common.logging.helper.EventCode;
import com.avaya.normalEventing.EventLogger;
import com.avaya.operationEventing.OperationalEventLogger;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public abstract class GenericAlarm
extends TimerTask {
    protected static Logger log = AsmLogger.getLogger(GenericAlarm.class);
    private Date lastTimerFire = null;
    private WeakReference<GenericAlarmRecoveryIntf> failedObj = null;
    private Class<? extends GenericAlarmRecoveryIntf> failedObjClazz = null;
    protected String guiPage = null;
    protected Exception exception = null;
    protected int timerFireCount = 0;
    protected AlarmStatus status = AlarmStatus.PRELOGGED;
    protected Map<AlarmStatus, Boolean> statusMap = new HashMap<AlarmStatus, Boolean>();
    protected String alarmKey = null;
    protected static int junitAlarmCount = -1;
    protected static long junitAlarmInterval = -1L;
    protected static Logger junitLog = null;

    public static void setForJunit(Logger logger, int alarmCount, long alarmInterval) {
        junitLog = logger;
        junitAlarmCount = alarmCount;
        junitAlarmInterval = alarmInterval;
    }

    public void init(GenericAlarmRecoveryIntf failedObj, Exception exception, String alarmKey) {
        WeakReference<GenericAlarmRecoveryIntf> weakReference = this.failedObj = failedObj == null ? null : new WeakReference<GenericAlarmRecoveryIntf>(failedObj);
        if (failedObj != null) {
            this.failedObjClazz = failedObj.getClass();
        }
        this.guiPage = GUIPages.get(failedObj);
        if (this.guiPage.length() == 0 && failedObj != null) {
            this.guiPage = "Unknown (" + this.getFailedObjectClassName() + ")";
        }
        this.exception = exception;
        this.lastTimerFire = null;
        this.timerFireCount = 0;
        this.alarmKey = alarmKey;
        this.logTheEvent(this.getCurrentEventPair());
        this.updateStatusMap();
    }

    public GenericAlarm clone() {
        GenericAlarm newAlarm = null;
        try {
            newAlarm = (GenericAlarm)this.getClass().newInstance();
            newAlarm.failedObj = this.failedObj;
            newAlarm.failedObjClazz = this.failedObjClazz;
            newAlarm.guiPage = this.guiPage;
            newAlarm.exception = this.exception;
            newAlarm.timerFireCount = this.timerFireCount;
            newAlarm.status = this.status;
            newAlarm.statusMap = this.statusMap;
            newAlarm.lastTimerFire = this.lastTimerFire;
            newAlarm.alarmKey = this.alarmKey;
        }
        catch (Exception e) {
            log.error((Object)("Could not create a new instance of the Alarm: " + e));
        }
        return newAlarm;
    }

    private EventPair getCurrentEventPair() {
        EventCode eventCode = null;
        Object[] eventArgs = null;
        boolean isLeadingTimer = GenericAlarmHandler.incTimerFireCount(this);
        if (this.isAtWarningThreshold()) {
            eventCode = this.getWarnEventCode();
            eventArgs = this.getWarnEventArgs();
            if (this.status != AlarmStatus.ALARMED && eventCode != null) {
                this.status = AlarmStatus.WARNING;
            }
        } else if (this.isAtAlarmThreshold()) {
            this.status = AlarmStatus.ALARMED;
            eventCode = this.getAlarmEventCode();
            eventArgs = this.getAlarmEventArgs();
        }
        if (eventCode != null && isLeadingTimer) {
            return new EventPair(eventCode, eventArgs);
        }
        return null;
    }

    private void logTheEvent(EventPair pair) {
        if (pair != null && this.allowToLogCurrentStatus()) {
            EventCode eventCode = pair.getEventCode();
            Object[] eventArgs = pair.getEventArgs();
            if (junitLog != null) {
                junitLog.logEvent(eventCode, eventArgs);
            } else if (this.isOperationalEvent()) {
                OperationalEventLogger.logOpEvent(eventCode, eventArgs);
            } else {
                EventLogger.logEvent(eventCode, eventArgs);
            }
        }
    }

    private void updateStatusMap() {
        for (AlarmStatus status : this.statusMap.keySet()) {
            if (status == this.status) continue;
            this.statusMap.put(status, false);
        }
        this.statusMap.put(this.status, true);
    }

    public int getTimerFireCount() {
        return this.timerFireCount;
    }

    public String getFailedObjectClassName() {
        Object tmpFailedObj;
        String name = "";
        if (this.failedObj != null && (tmpFailedObj = this.failedObj.get()) != null) {
            name = tmpFailedObj.getClass().getSimpleName();
        }
        return name;
    }

    public GenericAlarmRecoveryIntf getFailedObj() {
        GenericAlarmRecoveryIntf recovIntf = null;
        if (this.failedObj != null && (recovIntf = (GenericAlarmRecoveryIntf)this.failedObj.get()) == null) {
            recovIntf = (GenericAlarmRecoveryIntf)((Object)DMFactory.getInstance().getDataMgr(this.failedObjClazz, false));
            if (recovIntf == null) {
                if (log.isFineEnabled()) {
                    log.fine((Object)("getFailedObj: Object reference was garbage collected.  Cancelling the alarm: " + this.getClass().getSimpleName()));
                }
                this.cancel();
            } else {
                if (log.isFineEnabled()) {
                    log.fine((Object)("getFailedObj: Object reference was changed, updating for " + this.getClass().getSimpleName()));
                }
                this.failedObj = new WeakReference<GenericAlarmRecoveryIntf>(recovIntf);
            }
        }
        return recovIntf;
    }

    public Exception getException() {
        return this.exception;
    }

    public AlarmStatus getStatus() {
        return this.status;
    }

    public Date getTimerFire() {
        return this.lastTimerFire;
    }

    public boolean isOperationalEvent() {
        return false;
    }

    public abstract int getMaxFailuresAllowed();

    public abstract EventCode getWarnEventCode();

    public abstract Object[] getWarnEventArgs();

    public abstract EventCode getAlarmEventCode();

    public abstract Object[] getAlarmEventArgs();

    public abstract EventCode getClearEventCode();

    public abstract Object[] getClearEventArgs();

    public abstract boolean isAtAlarmThreshold();

    public abstract boolean isAtWarningThreshold();

    public abstract boolean canClearAlarm();

    public abstract long getTimerInterval();

    public abstract void timerFired();

    public abstract boolean isSingularFailure();

    @Override
    public void run() {
        try {
            EventPair eventPair = null;
            boolean upgradeToAlarm = false;
            long previousTimerInterval = this.getTimerInterval();
            ++this.timerFireCount;
            this.lastTimerFire = new Date();
            this.timerFired();
            if (this.canClearAlarm()) {
                this.status = AlarmStatus.CLEARED;
                if (GenericAlarmHandler.clearTimerFireCount(this)) {
                    eventPair = new EventPair(this.getClearEventCode(), this.getClearEventArgs());
                }
            } else {
                eventPair = this.getCurrentEventPair();
            }
            if (previousTimerInterval != this.getTimerInterval()) {
                upgradeToAlarm = true;
            }
            this.logTheEvent(eventPair);
            this.updateStatusMap();
            if (upgradeToAlarm) {
                GenericAlarmHandler.upgradeToAlarm(this);
            }
        }
        catch (Exception e) {
            log.error((Object)"run: Caught an exception.  Cancelling timer.", (Throwable)e);
            try {
                this.cancel();
            }
            catch (Exception e1) {
                log.error((Object)"Exception caught trying to remove timer.  Could not remove from map or cancel it.", (Throwable)e1);
            }
        }
    }

    public boolean allowToLogCurrentStatus() {
        if (!this.hasLogged(this.status)) {
            switch (this.status) {
                case CLEARED: {
                    return this.hasLogged(AlarmStatus.WARNING) || this.hasLogged(AlarmStatus.ALARMED);
                }
                case WARNING: {
                    return !this.hasLogged(AlarmStatus.ALARMED);
                }
                case ALARMED: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasLogged(AlarmStatus newStatus) {
        Boolean hasLogged = this.statusMap.get((Object)newStatus);
        return hasLogged != null && hasLogged == true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.alarmKey + ") for " + this.getFailedObjectClassName() + ", Fires: " + this.timerFireCount + " [" + (Object)((Object)this.status) + "] on " + (this.lastTimerFire == null ? "never" : this.lastTimerFire);
    }

    public boolean equals(Object o) {
        if (o instanceof GenericAlarm) {
            GenericAlarm a = (GenericAlarm)o;
            return a.getFailedObjectClassName().equals(this.getFailedObjectClassName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFailedObjectClassName().hashCode();
    }

    private class EventPair {
        private EventCode eventCode;
        private Object[] eventArgs;

        public EventPair(EventCode eventCode, Object[] eventArgs) {
            this.eventCode = eventCode;
            this.eventArgs = eventArgs == null ? new Object[]{} : eventArgs;
        }

        public EventCode getEventCode() {
            return this.eventCode;
        }

        public Object[] getEventArgs() {
            return this.eventArgs;
        }
    }

    protected static enum AlarmStatus {
        WARNING,
        ALARMED,
        CLEARED,
        PRELOGGED;

    }
}

