/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.alarming.datamgr.DAOAssetIdentityAlarm;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.SMAssetIdentityException;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.EntityLinkTableDAO;
import com.avaya.asm.datamgr.dao.HostNameDAO;
import com.avaya.asm.datamgr.dao.InstanceDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.objectapi.AssetLinkInfo;
import com.avaya.asm.datamgr.objectapi.EntityLink;
import com.avaya.asm.datamgr.objectapi.EntityLinkTable;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.asm.datamgr.objectapi.ListenPort;
import com.avaya.asm.datamgr.objectapi.ResolvedIPAddress;
import com.avaya.asm.datamgr.objectapi.ResolvedName;
import com.avaya.asm.datamgr.objectapi.ResolvedNameChangeObj;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssetDM
extends BusinessLogicDM
implements GenericAlarmRecoveryIntf {
    private final Logger log = AsmLogger.getLogger(AssetDM.class);
    protected static DMFactory dmFactory;
    private static DataDistLayerFactory ddlFactory;
    protected Long mySIPEntityId;
    protected String myAssetIPv4;
    protected String myAssetIPv6;
    protected Map<IPAddress.IPAddressFamily, Map<AsmConstants.TRANSPORT, AssetLinkInfo>> assetLinkInfoMap = new HashMap<IPAddress.IPAddressFamily, Map<AsmConstants.TRANSPORT, AssetLinkInfo>>();
    private Class<? extends InstanceDAO> instanceClass;

    public static DMFactory getFactory() {
        if (dmFactory == null) {
            dmFactory = DMFactory.getInstance();
        }
        return dmFactory;
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(assetDM.class);
    }

    protected static DataDistLayerFactory getDDLFactory() {
        if (ddlFactory == null) {
            ddlFactory = DataDistLayerFactory.getInstance();
        }
        return ddlFactory;
    }

    public static void setDDLFactory(DataDistLayerFactory ddlFactory) {
        AssetDM.ddlFactory = ddlFactory;
    }

    public AssetDM() {
        this.assetLinkInfoMap.put(IPAddress.IPAddressFamily.IPV4, new HashMap());
        this.assetLinkInfoMap.put(IPAddress.IPAddressFamily.IPV6, new HashMap());
    }

    protected InstanceDAO getMyInstanceDAO() {
        if (this.instanceClass == null) {
            for (Class<? extends DataAccessObject> daoClass : AssetDM.getFactory().getAllDAOClasses()) {
                if (daoClass == null || !InstanceDAO.class.isAssignableFrom(daoClass) || AsmInstanceDAO.class.equals(daoClass)) continue;
                this.instanceClass = daoClass;
                this.log.info((Object)("Instance class is " + this.instanceClass.getCanonicalName()));
                return (InstanceDAO)AssetDM.getFactory().getDataMgr(this.instanceClass);
            }
            for (Class<? extends DataAccessObject> daoClass : AssetDM.getFactory().getAllDAOClasses()) {
                if (daoClass == null || !InstanceDAO.class.isAssignableFrom(daoClass)) continue;
                this.instanceClass = daoClass;
                this.log.info((Object)("Instance class is " + this.instanceClass.getCanonicalName()));
                return (InstanceDAO)AssetDM.getFactory().getDataMgr(this.instanceClass);
            }
        }
        return (InstanceDAO)AssetDM.getFactory().getDataMgr(this.instanceClass);
    }

    public void setMyInstanceClass(Class<? extends InstanceDAO> instanceClass) {
        if (instanceClass == null) {
            throw new IllegalArgumentException("InstanceClass parameter should not be null!");
        }
        if (instanceClass.equals(this.instanceClass)) {
            return;
        }
        this.log.info((Object)("Setting instance class to " + instanceClass.getCanonicalName()));
        this.instanceClass = instanceClass;
        if (!AsmCommon.jUnitEnvironment) {
            this.reinit();
        }
    }

    protected EntityLinkTableDAO getEntityLinkDAO() {
        return (EntityLinkTableDAO)AssetDM.getFactory().getDataMgr(EntityLinkTableDAO.class);
    }

    protected HostNameDAO getHostNameDAO() {
        return (HostNameDAO)AssetDM.getFactory().getDataMgr(HostNameDAO.class);
    }

    protected SIPEntityDAO getSIPEntityDAO() {
        return (SIPEntityDAO)AssetDM.getFactory().getDataMgr(SIPEntityDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        this.assetLinkInfoMap = new HashMap<IPAddress.IPAddressFamily, Map<AsmConstants.TRANSPORT, AssetLinkInfo>>();
        this.assetLinkInfoMap.put(IPAddress.IPAddressFamily.IPV4, new HashMap());
        this.assetLinkInfoMap.put(IPAddress.IPAddressFamily.IPV6, new HashMap());
        this.myAssetIPv4 = null;
        this.myAssetIPv6 = null;
        this.mySIPEntityId = null;
        InstanceDAO dao = this.getMyInstanceDAO();
        if (dao == null) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)"Can't initialize AssetDM without loading InstanceDAO first!");
            return;
        }
        dao.registerListener(this);
        try {
            this.lock.acquireWriteLock();
            DataMgr.Status status = DataMgr.Status.OKAY;
            for (assetDM dm : assetDM.values()) {
                DataMgr dmInst = dm.get();
                if (!dmInst.okay()) {
                    status = DataMgr.Status.FAIL;
                    this.log.error((Object)("Failed to init: " + dm));
                }
                dmInst.registerListener(this);
            }
            this.mySIPEntityId = dao.getMySIPEntityId();
            if (this.mySIPEntityId == null) {
                this.log.warn((Object)("Instance unresolved.  Cannot determine if there is an Asset or not for product type '" + (Object)((Object)DMUtilities.getProductType()) + "'"));
                return;
            }
            this.setupAssetData();
            this.setStatus(status);
        }
        catch (Exception e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)"Problem initializing AssetDM.", (Throwable)e);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void setupAssetData() {
        this.setupAssetData(IPAddress.IPAddressFamily.IPV4);
        this.setupAssetData(IPAddress.IPAddressFamily.IPV6);
    }

    private void setupAssetData(IPAddress.IPAddressFamily ipAddrFamily) {
        List<String> assetIPs = this.getMyAssetIpList(ipAddrFamily);
        String myAssetIP = assetIPs == null || assetIPs.size() == 0 ? null : assetIPs.get(0);
        this.log.info((Object)(myAssetIP == null ? "There is no Asset." : "Setting myAsset" + (Object)((Object)ipAddrFamily) + " to " + myAssetIP));
        if (ipAddrFamily == IPAddress.IPAddressFamily.IPV6) {
            this.myAssetIPv6 = myAssetIP;
        } else {
            this.myAssetIPv4 = myAssetIP;
        }
        if (myAssetIP != null) {
            for (AsmConstants.TRANSPORT trans : AsmConstants.TRANSPORT.values()) {
                this.assetLinkInfoMap.get((Object)ipAddrFamily).put(trans, new AssetLinkInfo(myAssetIP, this.getAssetPort(trans, ipAddrFamily), trans));
            }
        }
    }

    public AssetLinkInfo getAssetLinkInfo(AsmConstants.TRANSPORT trans) {
        return this.getAssetLinkInfo(trans, IPAddress.IPAddressFamily.IPV4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetLinkInfo getAssetLinkInfo(AsmConstants.TRANSPORT trans, IPAddress.IPAddressFamily ipAddrFamily) {
        if (ipAddrFamily == null) {
            return null;
        }
        try {
            this.lock.acquireReadLock();
            AssetLinkInfo assetLinkInfo = this.assetLinkInfoMap.get((Object)ipAddrFamily).get((Object)trans);
            return assetLinkInfo;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all the asset link information.  Returns settings by IP address family and transport to AssetLinkInfo")
    public Map<IPAddress.IPAddressFamily, Map<AsmConstants.TRANSPORT, AssetLinkInfo>> getAllAssetLinkInfo() {
        return Collections.unmodifiableMap(this.assetLinkInfoMap);
    }

    @SMConsole(description="Get the IPv4 address of the Asset")
    public String getMyAssetIp() {
        return this.getMyAssetIp(IPAddress.IPAddressFamily.IPV4.toString());
    }

    public String getMyAssetIp(IPAddress.IPAddressFamily ipAddrFamily) {
        return ipAddrFamily == IPAddress.IPAddressFamily.IPV6 ? this.myAssetIPv6 : this.myAssetIPv4;
    }

    @SMConsole(description="Get the IP address of the Asset by IP address family")
    public String getMyAssetIp(String ipAddrFamilyStr) {
        IPAddress.IPAddressFamily ipAddrFamily;
        try {
            ipAddrFamily = IPAddress.IPAddressFamily.valueOf(ipAddrFamilyStr);
        }
        catch (Exception e) {
            return "Bad address family type: " + ipAddrFamilyStr;
        }
        return this.getMyAssetIp(ipAddrFamily);
    }

    public Integer getAssetPort(AsmConstants.TRANSPORT transport, IPAddress.IPAddressFamily ipAddrFamily) {
        Integer listenport = this.getAssetPortFromListenport(transport, ipAddrFamily);
        if (listenport == null) {
            listenport = this.getAssetPortFromEntityLink(transport, ipAddrFamily);
        }
        return listenport;
    }

    public Integer getAssetPort(AsmConstants.TRANSPORT transport) {
        return this.getAssetPort(transport, IPAddress.IPAddressFamily.IPV4);
    }

    private Integer getAssetPortFromListenport(AsmConstants.TRANSPORT transport, IPAddress.IPAddressFamily ipAddrFamily) {
        SIPEntityDAO seDAO = this.getSIPEntityDAO();
        ListenPort port = seDAO.getListenPort(null, transport.toString(), ipAddrFamily, true, this.mySIPEntityId);
        if (port == null) {
            port = seDAO.getListenPort(null, transport.toString(), ipAddrFamily, null, this.mySIPEntityId);
        }
        return port == null ? null : Integer.valueOf(port.getPortNumber());
    }

    private Integer getAssetPortFromEntityLink(AsmConstants.TRANSPORT transport, IPAddress.IPAddressFamily ipAddrFamily) {
        EntityLinkTableDAO eltDAO = this.getEntityLinkDAO();
        EntityLinkTable elt = eltDAO.getEntityLinkTable(this.mySIPEntityId);
        List<EntityLink> links = elt.getEntityLinks(transport.toString());
        for (EntityLink link : links) {
            if (link.getIPAddressFamily() != ipAddrFamily) continue;
            return link.getListenportentity1();
        }
        return null;
    }

    private List<String> getMyAssetIpList(IPAddress.IPAddressFamily ipAddrFamily) {
        String myAssetIp = null;
        ArrayList<String> assetList = new ArrayList<String>();
        SIPEntity mySipEntity = ((SIPEntityDAO)AssetDM.getFactory().getDataMgr(SIPEntityDAO.class)).getSIPEntity(this.mySIPEntityId);
        if (this.mySIPEntityId != null && mySipEntity != null) {
            String managementServerIpAddress = AssetDM.getDDLFactory().getIntraClusterName();
            String entityAddr = mySipEntity.getFqdnoripaddr(ipAddrFamily);
            if (entityAddr != null) {
                if (!IPAddress.isIPAddress(entityAddr)) {
                    ResolvedName resolvedName = this.getHostNameDAO().getResolvedName(entityAddr);
                    if (resolvedName != null) {
                        FQDNOrIpAddr mgmtServerIp = new FQDNOrIpAddr(managementServerIpAddress);
                        for (ResolvedIPAddress address : resolvedName.getAddresses()) {
                            String ipAddress = address.getIpaddress();
                            if (mgmtServerIp.isEqualTo(ipAddress)) {
                                myAssetIp = null;
                                return null;
                            }
                            if (IPAddress.getAddressFamily(ipAddress) != ipAddrFamily) continue;
                            if (myAssetIp == null) {
                                myAssetIp = ipAddress;
                                assetList.add(myAssetIp);
                                continue;
                            }
                            this.log.warn((Object)("Found multiple possible ASSET IP addresses in provisioned DNS!  Using " + myAssetIp));
                        }
                    }
                } else if (!IPAddress.areEqual(managementServerIpAddress, entityAddr)) {
                    myAssetIp = entityAddr;
                    assetList.add(myAssetIp);
                }
            }
        }
        if (assetList.size() > 1) {
            GenericAlarmHandler.handleFailureEvent(this, new SMAssetIdentityException("Found multiple possible ASSET IP addresses.", (String)assetList.get(0)));
        }
        return assetList;
    }

    protected boolean isCorrected(GenericAlarm alarm) {
        if (DAOAssetIdentityAlarm.class.equals(alarm.getClass())) {
            List<String> ipAddrsV4 = this.getMyAssetIpList(IPAddress.IPAddressFamily.IPV4);
            List<String> ipAddrsV6 = this.getMyAssetIpList(IPAddress.IPAddressFamily.IPV6);
            return ipAddrsV4 != null && ipAddrsV6 != null && ipAddrsV4.size() < 2 && ipAddrsV6.size() < 2;
        }
        return true;
    }

    @Override
    public boolean postAlarmAttemptRecovery(GenericAlarm alarm) {
        return this.isCorrected(alarm);
    }

    @Override
    public boolean preAlarmAttemptRecovery(GenericAlarm alarm) {
        return this.isCorrected(alarm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof Instance || newObject instanceof Instance) {
            Instance instance = this.getMyInstanceDAO().getMyInstance();
            if (instance != null && !instance.equals(newObject)) return;
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"Notified of Instance change; re-initializing");
            }
            this.reinit();
            return;
        } else if (oldObject instanceof ResolvedNameChangeObj || newObject instanceof ResolvedNameChangeObj) {
            ResolvedName newResolvedName;
            ResolvedName oldResolvedName = oldObject == null ? null : ((ResolvedNameChangeObj)oldObject).getResolvedName();
            ResolvedName resolvedName = newResolvedName = newObject == null ? null : ((ResolvedNameChangeObj)newObject).getResolvedName();
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"hostNameChanged: Notified of host name change");
            }
            if (oldResolvedName != null) {
                for (ResolvedIPAddress ip : oldResolvedName.getAddresses()) {
                    if (!IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv4) && !IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv6)) continue;
                    this.reinit();
                    return;
                }
            }
            if (newResolvedName == null) return;
            for (ResolvedIPAddress ip : newResolvedName.getAddresses()) {
                if (!IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv4) && !IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv6)) continue;
                this.reinit();
            }
            return;
        } else if (oldObject instanceof ResolvedName || newObject instanceof ResolvedName) {
            ResolvedName oldResolvedName = (ResolvedName)oldObject;
            ResolvedName newResolvedName = (ResolvedName)newObject;
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"hostNameChanged: Notified of host name change");
            }
            if (oldResolvedName != null) {
                for (ResolvedIPAddress ip : oldResolvedName.getAddresses()) {
                    if (!IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv4) && !IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv6)) continue;
                    this.reinit();
                    return;
                }
            }
            if (newResolvedName == null) return;
            for (ResolvedIPAddress ip : newResolvedName.getAddresses()) {
                if (!IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv4) && !IPAddress.areEqual(ip.getIpaddress(), this.myAssetIPv6)) continue;
                this.reinit();
            }
            return;
        } else if (oldObject instanceof EntityLink || newObject instanceof EntityLink) {
            EntityLink oldLink = (EntityLink)oldObject;
            EntityLink newLink = (EntityLink)newObject;
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"entityLinkChanged: Notified of entity link change");
            }
            try {
                this.lock.acquireWriteLock();
                if (this.mySIPEntityId == null || (oldLink == null || !this.mySIPEntityId.equals(oldLink.getEntity1_id()) && !this.mySIPEntityId.equals(oldLink.getEntity2_id())) && (newLink == null || !this.mySIPEntityId.equals(newLink.getEntity1_id()) && !this.mySIPEntityId.equals(newLink.getEntity2_id()))) return;
                this.setupAssetData();
                return;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        } else if (oldObject instanceof SIPEntity || newObject instanceof SIPEntity) {
            SIPEntity newEntity = (SIPEntity)newObject;
            SIPEntity oldEntity = (SIPEntity)oldObject;
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"sipEntityChanged: Notified of sip entity change");
            }
            try {
                this.lock.acquireWriteLock();
                if (this.mySIPEntityId == null) return;
                if (newEntity != null && newEntity.getId() == this.mySIPEntityId.longValue()) {
                    this.setupAssetData();
                    return;
                }
                if (oldEntity == null || oldEntity.getId() != this.mySIPEntityId.longValue()) return;
                this.reinit();
                return;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        } else {
            this.log.warn((Object)("Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    public static enum assetDM implements BLDMEnumType
    {
        ENTITY_LINK_TABLE_DAO(EntityLinkTableDAO.class),
        HOST_NAME_DAO(HostNameDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class);

        private Class<? extends DataMgr> subDM;

        private assetDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return AssetDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

