/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.CassandraMetaAPI;
import com.avaya.asm.datamgr.CassandraMetaDAO;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import java.util.Collection;
import java.util.Map;

public class CassandraMetaDM
implements CassandraMetaAPI {
    private final Logger log = AsmLogger.getLogger(CassandraMetaDM.class);
    CassandraDAOFactory<CassandraMetaDAO> appParamsDAOFactory = new CassandraDAOFactory();

    @Override
    public boolean getAllKeyspaces(Collection<KeyspaceMetaData> keyspaces, CassandraConnectionInfo cConnInfo) {
        CassandraMetaDAO dao = this.getCassandraMetaDAO(cConnInfo);
        if (dao == null) {
            return false;
        }
        return dao.getAllKeyspaces(keyspaces);
    }

    @Override
    public boolean getColumnFamilies(String keyspace, Collection<ColumnFamilyMetaData> columnFamilies, CassandraConnectionInfo cConnInfo) {
        CassandraMetaDAO dao = this.getCassandraMetaDAO(cConnInfo);
        if (dao == null) {
            return false;
        }
        return dao.getColumnFamilies(keyspace, columnFamilies);
    }

    @Override
    public boolean getAllColumnFamilies(Collection<ColumnFamilyMetaData> columnFamilies, CassandraConnectionInfo cConnInfo) {
        CassandraMetaDAO dao;
        String fcn_name = "getAllColumnFamilies";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllColumnFamilies: enter, columnFamilies.size()=" + columnFamilies.size() + ", cConnInfo=" + cConnInfo));
        }
        if ((dao = this.getCassandraMetaDAO(cConnInfo)) == null) {
            this.log.error((Object)("getAllColumnFamilies: getCassandraMetaDAO returned null for cConnInfo=" + cConnInfo));
            return false;
        }
        boolean rc = dao.getAllColumnFamilies(columnFamilies);
        if (isFiner) {
            this.log.finer((Object)("getAllColumnFamilies: leave, columnFamilies.size()=" + columnFamilies.size() + ", rc=" + rc));
        }
        return rc;
    }

    @Override
    public void dropKeyspace(String keyspace, CassandraConnectionInfo cConnInfo) throws DMException {
        CassandraMetaDAO dao;
        String fcn_name = "dropKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("dropKeyspace: enter, keyspace=" + keyspace + ", cConnInfo=" + cConnInfo));
        }
        if ((dao = this.getCassandraMetaDAO(cConnInfo)) == null) {
            String msg = "dropKeyspace: getCassandraMetaDAO failed";
            throw new DMException(msg);
        }
        dao.dropKeyspace(keyspace);
        if (isFiner) {
            this.log.finer((Object)("dropKeyspace: leave, keyspace " + keyspace + " dropped."));
        }
    }

    @Override
    public void dropColumnFamily(String columnFamily, CassandraConnectionInfo cConnInfo) throws DMException {
        CassandraMetaDAO dao;
        String fcn_name = "dropColumnFamily";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("dropColumnFamily: enter, columnFamily=" + columnFamily + ", cConnInfo=" + cConnInfo));
        }
        if ((dao = this.getCassandraMetaDAO(cConnInfo)) == null) {
            String msg = "dropColumnFamily: getCassandraMetaDAO failed";
            throw new DMException(msg);
        }
        dao.dropColumnFamily(columnFamily);
        if (isFiner) {
            this.log.finer((Object)("dropColumnFamily: leave, columnFamily " + columnFamily + " dropped."));
        }
    }

    public CassandraMetaDAO getCassandraMetaDAO(CassandraConnectionInfo cConnInfo) {
        String fcn_name = "getCassandraMetaDAO";
        CassandraMetaDAO dao = this.appParamsDAOFactory.getDAOInstance(cConnInfo, CassandraMetaDAO.class);
        if (dao == null) {
            String msg = "getCassandraMetaDAO: getDAOInstance failed, cConnInfo=" + cConnInfo;
            this.log.error((Object)msg);
            return null;
        }
        return dao;
    }

    @Override
    public void alterKeyspaceReplicationStrategy(String keyspace, Map<String, String> replParms, CassandraConnectionInfo cConnInfo) throws DMException {
        CassandraMetaDAO dao;
        String fcn_name = "alterKeyspaceReplicationStrategy";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("alterKeyspaceReplicationStrategy: enter, keyspace=" + keyspace + ", replParms=" + replParms));
        }
        if ((dao = this.getCassandraMetaDAO(cConnInfo)) == null) {
            String msg = "alterKeyspaceReplicationStrategy: getCassandraMetaDAO failed";
            throw new DMException(msg);
        }
        dao.alterKeyspaceReplicationStrategy(keyspace, replParms);
        if (isFiner) {
            this.log.finer((Object)"alterKeyspaceReplicationStrategy: leave");
        }
    }

    @Override
    public ColumnFamilyMetaData getColumnFamily(String keyspace, String cfName, CassandraConnectionInfo cConnInfo) throws DMException {
        String fcn_name = "getColumnFamily";
        CassandraMetaDAO dao = this.getCassandraMetaDAO(cConnInfo);
        if (dao == null) {
            String msg = "getColumnFamily: getCassandraMetaDAO failed";
            throw new DMException(msg);
        }
        return dao.getColumnFamily(keyspace, cfName);
    }
}

