/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DynAsmCommProfileAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.DynAsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.cassandra.TokenRangeIterator;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.objectapi.DynAsmCommProfile;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.exceptions.TruncateException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DynAsmCommProfileDM
implements DynAsmCommProfileAPI {
    private final Logger log = AsmLogger.getLogger(DynAsmCommProfileDM.class);
    private CassandraDAOFactory<DynAsmCommProfileDAO> dynAsmCommProfileDAOFactory = new CassandraDAOFactory();
    private CassandraConnectionInfo cConnInfo = null;
    private static final boolean RETRY_DOWNGRADING_CONSISTENCY = true;

    public DynAsmCommProfileDM(CassandraConnectionInfo cConnInfo) {
        this.cConnInfo = cConnInfo;
    }

    public DynAsmCommProfileDM() {
    }

    protected DynAsmCommProfileDAO getDynAsmCommProfileDAO() throws DMException {
        DynAsmCommProfileDAO dao = this.dynAsmCommProfileDAOFactory.getDAOInstance(this.cConnInfo, DynAsmCommProfileDAO.class);
        if (dao == null) {
            this.log.error((Object)("getDynAsmCommProfileDAO: getDAOInstance failed, cConnInfo=" + this.cConnInfo));
            throw new DMException("getDynAsmCommProfileDAO: getDAOInstance failed");
        }
        return dao;
    }

    public TokenRangeIterator newTokenRangeIterator(List<InetAddress> downNodes) {
        String fcn_name = "newTokenRangeIterator";
        TokenRangeIterator tokenRangeIterator = null;
        try {
            DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
            tokenRangeIterator = dynAsmCommProfileDAO.newTokenRangeIterator(downNodes);
        }
        catch (DMException | UnknownHostException e) {
            e.printStackTrace();
            this.log.error((Object)"newTokenRangeIterator Error while creating BucketRangeIterator!");
        }
        return tokenRangeIterator;
    }

    @Override
    public DynAsmCommProfile getDynAsmCommProfile(long commProfileId) throws DMException {
        String fcn_name = "getDynAsmCommProfile";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("getDynAsmCommProfile: enter with commProfileId=" + commProfileId));
        }
        if (commProfileId < 0L) {
            this.log.error((Object)("getDynAsmCommProfile Illegal argument passed commProfileId=" + commProfileId));
            throw new IllegalArgumentException("getDynAsmCommProfile commProfileId: " + commProfileId);
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        DynAsmCommProfile dynAsmCommProfile = dynAsmCommProfileDAO.getDynAsmCommProfile(commProfileId);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.fine((Object)("getDynAsmCommProfile: leave, dynAsmCommProfile=" + dynAsmCommProfile + ", queryTime=" + (endTime - startTime)));
        }
        return dynAsmCommProfile;
    }

    @Override
    public DynAsmCommProfile getDynAsmCommProfile(long commProfileId, DynAsmCommProfileAPI.ConsistencyScope cscope) throws DMException {
        String fcn_name = "getDynAsmCommProfile";
        boolean isFiner = this.log.isFinerEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("getDynAsmCommProfile: enter with commProfileId=" + commProfileId));
        }
        if (commProfileId < 0L) {
            this.log.error((Object)("getDynAsmCommProfile Illegal argument passed commProfileId=" + commProfileId));
            throw new IllegalArgumentException("getDynAsmCommProfile commProfileId: " + commProfileId);
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        DynAsmCommProfile dynAsmCommProfile = dynAsmCommProfileDAO.getDynAsmCommProfile(commProfileId, cscope);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.finer((Object)("getDynAsmCommProfile: leave, dynAsmCommProfile=" + dynAsmCommProfile + ", queryTime=" + (endTime - startTime)));
        }
        return dynAsmCommProfile;
    }

    @Override
    public List<DynAsmCommProfile> getAllDynAsmCommProfiles(List<Long> commProfileIds) throws DMException {
        String fcn_name = "getAllDynAsmCommProfile";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("getAllDynAsmCommProfile: enter with commProfileIds=" + commProfileIds));
        }
        if (commProfileIds.isEmpty()) {
            this.log.info((Object)"getAllDynAsmCommProfile No commProfileId to search as commProfileIds is empty");
            throw new IllegalArgumentException("getAllDynAsmCommProfile commProfileId: " + commProfileIds);
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        List<DynAsmCommProfile> dynAsmCommProfileList = dynAsmCommProfileDAO.getAllDynAsmCommProfiles(commProfileIds);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.finer((Object)("getAllDynAsmCommProfile: leave, dynAsmCommProfileList=" + dynAsmCommProfileList + ", queryTime=" + (endTime - startTime)));
        }
        return dynAsmCommProfileList;
    }

    @Override
    public void setUserCommunityId(long commProfileId, Long updateUserCommunityId, DynAsmCommProfileAPI.ConsistencyScope cScope) throws DMException {
        String fcn_name = "setUserCommunityId";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("setUserCommunityId: enter with commProfileId=" + commProfileId + ",updateUserCommunityId=" + updateUserCommunityId + ",cScope=" + (Object)((Object)cScope)));
        }
        if (commProfileId < 0L || updateUserCommunityId == null) {
            this.log.error((Object)("setUserCommunityId Illegal argument passed commProfileId=" + commProfileId + ",updateUserCommunityId=" + updateUserCommunityId));
            throw new IllegalArgumentException("setUserCommunityId commProfileId: " + commProfileId + ",updateUserCommunityId=" + updateUserCommunityId);
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        dynAsmCommProfileDAO.setUserCommunityId(commProfileId, updateUserCommunityId, cScope, true);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.finer((Object)("setUserCommunityId: leave, queryTime=" + (endTime - startTime)));
        }
    }

    @Override
    public Long compareAndSetUserCommunityId(long commProfileId, Long expectedUserCommunityId, Long updateUserCommunityId, DynAsmCommProfileAPI.ConsistencyScope cScope) throws DMException {
        return this.compareAndSetUserCommunityId(commProfileId, expectedUserCommunityId, updateUserCommunityId, cScope, null);
    }

    @Override
    public Long compareAndSetUserCommunityId(long commProfileId, Long expectedUserCommunityId, Long updateUserCommunityId, DynAsmCommProfileAPI.ConsistencyScope cScope, DynAsmCommProfileDAO.CompareAndSetStats stats) throws DMException {
        String fcn_name = "compareAndSetUserCommunityId";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("compareAndSetUserCommunityId: enter with commProfileId=" + commProfileId + ",expectedUserCommunityId=" + expectedUserCommunityId + ",updateUserCommunityId=" + updateUserCommunityId + ",cScope=" + (Object)((Object)cScope)));
        }
        if (commProfileId < 0L || expectedUserCommunityId == null && updateUserCommunityId == null) {
            this.log.error((Object)("compareAndSetUserCommunityId Illegal argument passed commProfileId=" + commProfileId + ",expectedUserCommunityId=" + expectedUserCommunityId + ",updateUserCommunityId=" + updateUserCommunityId));
            throw new IllegalArgumentException("compareAndSetUserCommunityId commProfileId: " + commProfileId + ",expectedUserCommunityId=" + expectedUserCommunityId + ",updateUserCommunityId=" + updateUserCommunityId);
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        Long userCommunity = dynAsmCommProfileDAO.compareAndSetUserCommunityId(commProfileId, expectedUserCommunityId, updateUserCommunityId, cScope, true, stats);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.finer((Object)("compareAndSetUserCommunityId: leave, userCommunity=" + userCommunity + ", queryTime=" + (endTime - startTime)));
        }
        return userCommunity;
    }

    @Override
    public void deleteDynAsmCommProfile(long commProfileId) throws DMException {
        String fcn_name = "deleteDynAsmCommProfile";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("deleteDynAsmCommProfile: enter with commProfileId=" + commProfileId));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (commProfileId < 0L) {
            this.log.error((Object)("deleteDynAsmCommProfile Illegal argument passed commProfileId=" + commProfileId));
            throw new IllegalArgumentException("deleteDynAsmCommProfile commProfileId: " + commProfileId);
        }
        dynAsmCommProfileDAO.deleteDynAsmCommProfile(commProfileId);
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("deleteDynAsmCommProfile" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)"deleteDynAsmCommProfile: Leave ");
        }
    }

    @Override
    public void getCommProfileIdsByLocalTokenRanges(List<InetAddress> downNodes, Collection<Long> commProfileIds) throws DMException {
        TokenRangeIterator tokenRangeIterator;
        String fcn_name = "getCommProfileIdsByLocalBucket";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        TokenRange next = null;
        if (isFiner) {
            this.log.finer((Object)("getCommProfileIdsByLocalBucket: enter with downNodes=" + downNodes + ",commProfileIds=" + commProfileIds));
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        if ((tokenRangeIterator = this.newTokenRangeIterator(downNodes)) != null) {
            next = tokenRangeIterator.getNext();
        }
        while (next != null) {
            dynAsmCommProfileDAO.getCommProfileIdsByTokenRange(next, commProfileIds);
            next = tokenRangeIterator.getNext();
        }
        if (isFinest) {
            long endTime = System.currentTimeMillis();
            this.log.finest((Object)("getCommProfileIdsByLocalBucket" + (endTime - startTime)));
        }
        if (isFiner) {
            this.log.finer((Object)("getCommProfileIdsByLocalBucket Leave with List commProfileSetids=" + commProfileIds.size()));
        }
    }

    @Override
    public void deleteAllDynAsmCommProfile() throws DMException {
        String fcn_name = "deleteAllDynAsmCommProfile";
        boolean isFiner = this.log.isFinerEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)"deleteAllDynAsmCommProfile: enter");
        }
        DynAsmCommProfileDAO dynAsmCommProfileDAO = this.getDynAsmCommProfileDAO();
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        try {
            dynAsmCommProfileDAO.truncateDynAsmCommProfile();
        }
        catch (DMException dme) {
            Throwable thr = dme.getNestedException();
            if (thr instanceof TruncateException) {
                this.log.info((Object)("deleteAllDynAsmCommProfile: TruncateException trying to truncate the table, will now delete each record, exception=" + thr));
                this.getAndDeleteAllDynAsmCommProfiles(dynAsmCommProfileDAO);
            }
            throw dme;
        }
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.finer((Object)("deleteAllDynAsmCommProfile: leave, queryTime=" + (endTime - startTime)));
        }
    }

    private void getAndDeleteAllDynAsmCommProfiles(DynAsmCommProfileDAO dynAsmCommProfileDAO) throws DMException {
        String fcn_name = "getAndDeleteAllDynAsmCommProfiles";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        if (isFiner) {
            this.log.finer((Object)"getAndDeleteAllDynAsmCommProfiles: enter");
        }
        if (isFiner) {
            startTime = System.currentTimeMillis();
        }
        ArrayList<Long> commProfileIds = new ArrayList<Long>();
        dynAsmCommProfileDAO.getCommProfileIdsByTokenRange(null, commProfileIds);
        if (isFinest) {
            this.log.finest((Object)("getAndDeleteAllDynAsmCommProfiles: getAllDynAsmCommProfiles() returned commProfileIds.size=" + commProfileIds.size()));
        }
        dynAsmCommProfileDAO.deleteDynAsmCommProfiles(commProfileIds);
        if (isFiner) {
            long endTime = System.currentTimeMillis();
            this.log.finer((Object)("getAndDeleteAllDynAsmCommProfiles: leave, queryTime=" + (endTime - startTime)));
        }
    }
}

