/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.CallHistoryDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.SMCallHistoryAPI;
import com.avaya.asm.datamgr.dao.AsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dynamic.DynamicDataMgr;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CallHistoryKey;
import com.avaya.ustore.SMVersionChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SMCallHistoryDM
extends DynamicDataMgr
implements SMCallHistoryAPI {
    CallHistoryDM callHistoryDM = new CallHistoryDM();
    private final Logger log = AsmLogger.getLogger(SMCallHistoryDM.class);
    private static DMFactory factory;
    protected SMVersionChecker smversionChecker;
    private static final UserStoreKeyspace globalUserDCKeyspace;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public void setFactory(DMFactory dmFactory) {
        factory = dmFactory;
    }

    @Override
    public void addCallHistory(long cscommprofilesetId, List<CallLog> callLogs) throws DMException {
        String fcn_name = "addCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter, cscommProfilesetId=" + cscommprofilesetId + ", callLogs.size()=" + callLogs.size()));
        }
        CallHistoryKey key = this.getKey(cscommprofilesetId);
        this.callHistoryDM.addCallHistory(key, callLogs);
        if (isFiner) {
            this.log.finer((Object)"addCallHistory: leave");
        }
    }

    @Override
    public void deleteCallHistoryById(long cscommprofilesetId, List<UUID> callLogUuids) throws DMException {
        String fcn_name = "deleteCallHistoryById";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryById: enter, cscommProfilesetId=" + cscommprofilesetId + ", callLogUuids.size()=" + callLogUuids.size()));
        }
        this.migrateCallLogsToGlobalDC(cscommprofilesetId, true);
        CallHistoryKey key = this.getKey(cscommprofilesetId);
        if (key == null) {
            this.log.warn((Object)("deleteCallHistoryById: cannot get key for set id " + cscommprofilesetId));
            return;
        }
        this.callHistoryDM.deleteCallHistoryById(key, callLogUuids);
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryById: leave");
        }
    }

    @Override
    public void deleteCallHistoryByLimit(long cscommprofilesetId, int maxLogs) throws DMException {
        String fcn_name = "deleteCallHistoryByLimit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryByLimit: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs));
        }
        this.migrateCallLogsToGlobalDC(cscommprofilesetId, true);
        CallHistoryKey key = this.getKey(cscommprofilesetId);
        this.callHistoryDM.deleteCallHistoryByLimit(key, maxLogs);
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryByLimit: leave");
        }
    }

    @Override
    public List<CallLog> getCallHistory(long cscommprofilesetId, Integer maxLogs) throws DMException {
        CallHistoryKey key;
        String fcn_name = "getCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        boolean containsGlobalUserDcKS = false;
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs));
        }
        if ((key = this.getKey(cscommprofilesetId)) != null) {
            containsGlobalUserDcKS = key.getKeyspace().equals(globalUserDCKeyspace);
        }
        List<CallLog> callLogs = null;
        boolean isMigrationNeeded = false;
        if (containsGlobalUserDcKS) {
            callLogs = this.callHistoryDM.getCallHistory(key, maxLogs, true);
            if (callLogs == null || callLogs.isEmpty()) {
                isMigrationNeeded = true;
            } else {
                CallLog firstCL = callLogs.get(0);
                Boolean isGlobalMigrated = firstCL.isGlobalMigrated();
                if (firstCL.getUUID().equals(this.getMinTimeUUID()) && isGlobalMigrated != null && isGlobalMigrated.booleanValue()) {
                    callLogs = callLogs.subList(1, callLogs.size());
                } else {
                    isMigrationNeeded = true;
                }
            }
            if (isMigrationNeeded) {
                this.migrateCallLogsToGlobalDC(cscommprofilesetId, false);
                callLogs = null;
            }
        }
        if (callLogs == null) {
            callLogs = this.callHistoryDM.getCallHistory(key, maxLogs);
        }
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: leave, having found " + callLogs.size() + " Call Logs."));
        }
        return callLogs;
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing SMCallHistoryDM");
        this.smversionChecker = new SMVersionChecker("8.1.2");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (dmTypes dm : dmTypes.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing SMCallHistoryDM");
    }

    protected CallHistoryKey getKey(long cscommprofilesetId) {
        Boolean checkMinimumSMVersions = this.smversionChecker.checkMinimumSMVersions();
        if (Boolean.TRUE.equals(checkMinimumSMVersions)) {
            return new CallHistoryKey(cscommprofilesetId, globalUserDCKeyspace);
        }
        return this.getCommunityKey(cscommprofilesetId);
    }

    protected CallHistoryKey getCommunityKey(long cscommprofilesetId) {
        String fcn_name = "getCommunityKey";
        AsmCommProfile acp = ((AsmCommProfileDAO)dmTypes.ASM_COMMPROFILE_DAO.get()).getAsmCommProfileBySetId(cscommprofilesetId);
        if (acp == null) {
            this.log.warn((Object)("getCommunityKey: cannot get AsmCommProfile for cscommprofilesetId=" + cscommprofilesetId));
            return null;
        }
        Long userCommId = acp.getUserCommunityId();
        if (userCommId == null) {
            this.log.warn((Object)("getCommunityKey: cannot get userCommId for set id " + cscommprofilesetId));
            return null;
        }
        List<Long> asmInstIds = ((UserCommunityDAO)dmTypes.USER_COMMUNITY_DAO.get()).getUserCommAsmInstanceIds(userCommId);
        if (asmInstIds == null) {
            this.log.warn((Object)("getCommunityKey: cannot get asmInstIds for comm id " + userCommId + ", set id " + cscommprofilesetId));
            return null;
        }
        ArrayList<AsmInstance> instances = new ArrayList<AsmInstance>();
        for (Long id : asmInstIds) {
            AsmInstance instance = ((AsmInstanceDAO)dmTypes.ASM_INSTANCE_DAO.get()).getAsmInstance(id);
            if (instance == null) {
                this.log.warn((Object)("getCommunityKey: cannot get AsmInstance for comm id " + userCommId + ", set id " + cscommprofilesetId + ", asm instance id " + id));
                return null;
            }
            instances.add(instance);
        }
        return new CallHistoryKey(cscommprofilesetId, new UserStoreKeyspace(instances));
    }

    @Override
    public void deleteAllCallHistory(long cscommprofilesetId) throws DMException {
    }

    @Override
    public void moveCallHistory(long oldCommProfileSetId, long newCommProfileSetId) throws DMException {
    }

    @Override
    public boolean checkAndSetGlobalTimeToLive(long seconds) throws DMException {
        UserStoreKeyspace keyspace = new UserStoreKeyspace("global_user_dc");
        return this.callHistoryDM.checkAndSetTimeToLive(keyspace, seconds);
    }

    protected void migrateCallLogsToGlobalDC(long cscommprofilesetId, boolean checkMigrationLogPresent) throws DMException {
        String fcn_name = "migrateCallLogsToGlobalDC";
        Boolean checkMinimumSMVersions = this.smversionChecker.checkMinimumSMVersions();
        if (!Boolean.TRUE.equals(checkMinimumSMVersions)) {
            return;
        }
        if (checkMigrationLogPresent && this.callHistoryDM.calllogsMigratedToGlobalDC(cscommprofilesetId)) {
            this.log.info((Object)("migrateCallLogsToGlobalDCSpecialCallLog is present for cscommprofilesetId : " + cscommprofilesetId + ", Migration is already Done."));
            return;
        }
        this.callHistoryDM.moveCallHistory(this.getCommunityKey(cscommprofilesetId), this.getKey(cscommprofilesetId));
        this.callHistoryDM.setMigrationCallLog(cscommprofilesetId);
    }

    public UUID getMinTimeUUID() throws DMException {
        return this.callHistoryDM.getMinTimeUUID();
    }

    static {
        globalUserDCKeyspace = new UserStoreKeyspace("global_user_dc");
    }

    public static enum dmTypes implements BLDMEnumType
    {
        ASM_INSTANCE_DAO(AsmInstanceDAO.class),
        USER_COMMUNITY_DAO(UserCommunityDAO.class),
        ASM_COMMPROFILE_DAO(AsmCommProfileDAO.class);

        private Class<? extends DataMgr> subDM;

        private dmTypes(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return SMCallHistoryDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

