/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.CommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AsmCommProfileDAO
extends CommProfileDAO {
    private final Logger log = AsmLogger.getLogger(AsmCommProfileDAO.class);
    public static final String commProfileType = "SIP";
    private final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, AsmCommProfile> profileMap = new ConcurrentHashMap<Long, AsmCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new AsmCommProfile(id, (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), rs.getString("forkingpolicy"), rs.getInt("simultaneous_devices"), (Long)rs.getObject("origappset_id"), (Long)rs.getObject("termappset_id"), (Long)rs.getObject("usercommunity_id"), (Long)rs.getObject("subscriptionset_id"), (Long)rs.getObject("homelocation_id"), (Long)rs.getObject("survivability_server_id"), (Long)rs.getObject("asm_conf_factory_set_id"), rs.getBoolean("block_reg_if_max"), rs.getBoolean("call_logging"), (Long)rs.getObject("emer_origappset_id"), (Long)rs.getObject("emer_termappset_id"), (Long)rs.getObject("asm_assign_policy_id"), (Long)rs.getObject("asm_region_community_id")));
            }
            return profileMap;
        }
    };

    @Override
    public String getMainTable() {
        return "asmcommprofile";
    }

    @Override
    protected String getSelectFields() {
        return "SELECT cs.id, asm.forkingpolicy, asm.simultaneous_devices, asm.origappset_id, asm.termappset_id, asm.usercommunity_id, asm.subscriptionset_id, asm.homelocation_id, asm.survivability_server_id, asm.asm_conf_factory_set_id, asm.block_reg_if_max, asm.call_logging, cs.cscommprofilesetid, cs.preferredhandleid, asm.emer_origappset_id, asm.emer_termappset_id, asm.asm_assign_policy_id, asm.asm_region_community_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id " + (this.localOnly ? "JOIN dyn_asmcommprofile dasm ON dasm.id=asm.id" : "");
    }

    @Override
    protected ResultSetMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        if (this.localOnly && this.getMainTable().equals(event.getTableName())) {
            return;
        }
        super.updateDAO(event);
    }

    public AsmCommProfile getAsmCommProfile(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null) {
                AsmCommProfile asmCommProfile = (AsmCommProfile)this.csCommProfileMap.get(id);
                return asmCommProfile;
            }
            AsmCommProfile asmCommProfile = null;
            return asmCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public AsmCommProfile getEnterpriseAsmCommProfile(Long id) {
        AsmCommProfile profile = this.getAsmCommProfile(id);
        if (profile == null) {
            try {
                Map map = (Map)this.dataSource.executeQuery(this.getProfileBase + " AND asm.id=?", this.getUpdateParams(id), this.getMapper());
                profile = (AsmCommProfile)map.get(id);
            }
            catch (DMException e) {
                this.log.error((Object)("getEnterpriseAsmCommProfile: DMException thrown, e=" + e), (Throwable)e);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmCommProfile getAsmCommProfileBySetId(Long setId) {
        try {
            this.lock.acquireReadLock();
            Long id = (Long)this.setIdMap.get(setId);
            if (id != null) {
                AsmCommProfile asmCommProfile = (AsmCommProfile)this.csCommProfileMap.get(id);
                return asmCommProfile;
            }
            AsmCommProfile asmCommProfile = null;
            return asmCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all AsmCommProfiles cached in memory.")
    public Map<Long, CsCommProfile> getAsmCommProfiles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsCommProfile> map = Collections.unmodifiableMap(this.csCommProfileMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static void main(String[] args) {
        AsmCommProfileDAO dao = new AsmCommProfileDAO();
        dao.printQueries();
    }

    @Override
    protected String getCommProfileType() {
        return commProfileType;
    }

    @Override
    protected boolean joinAsmCommProfile() {
        return false;
    }
}

