/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmAddressMappingGroupDAO;
import com.avaya.asm.datamgr.dao.AsmRemoteClientAddressDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmAddressMappingGroupParm;
import com.avaya.asm.datamgr.objectapi.AsmEnterpriseToRemoteMapParm;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AsmEnterpriseToRemoteMapDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(AsmRemoteClientAddressDAO.class);
    protected Map<Long, AsmEnterpriseToRemoteMapParm> asmEnterpriseToRemoteMap = new HashMap<Long, AsmEnterpriseToRemoteMapParm>();
    public static final String queryAsmEnterpriseToRemoteMap = "SELECT id, enterprise_address, remote_address, ipaddr_family, address_mapping_group_id, enterprise_asminstance_id FROM asm_enterprise_to_remote_map";
    public static final String getAsmEnterpriseToRemoteMapById = "SELECT id, enterprise_address, remote_address, ipaddr_family, address_mapping_group_id, enterprise_asminstance_id FROM asm_enterprise_to_remote_map WHERE id = ?";
    protected final String ADDRESS_MAPPING_TABLE = "asm_enterprise_to_remote_map";
    public static ArrayList<String> list;
    private static final ResultSetMapper asmEnterpriseToRemotesMapper;
    private static final ResultSetMapper asmEnterpriseToRemoteOneMapper;

    public ResultSetMapper getAsmEnterpriseToRemotesMapper() {
        return asmEnterpriseToRemotesMapper;
    }

    public ResultSetMapper getAsmEnterpriseToRemoteOneMapper() {
        return asmEnterpriseToRemoteOneMapper;
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        HashMap asmEnterpriseToRemoteMapTMP;
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".init: ";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)(fcn_name + "Enter"));
        }
        this.getDataMgr(AsmAddressMappingGroupDAO.class);
        Object[] params = new Object[]{};
        try {
            asmEnterpriseToRemoteMapTMP = (HashMap)this.dataSource.executeQuery(queryAsmEnterpriseToRemoteMap, params, this.getAsmEnterpriseToRemotesMapper());
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error " + fcn_name), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.asmEnterpriseToRemoteMap = asmEnterpriseToRemoteMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                if (isFine) {
                    log.fine((Object)(fcn_name + "completed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeDeleteDAO(DAOTableEvent tableEvent) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".cascadeDeleteDAO: ";
        boolean isFine = log.isFineEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)(fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id));
        }
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        boolean lockHeld = false;
        try {
            if (this.asmEnterpriseToRemoteMap != null) {
                Set<Map.Entry<Long, AsmEnterpriseToRemoteMapParm>> set = this.asmEnterpriseToRemoteMap.entrySet();
                Iterator<Map.Entry<Long, AsmEnterpriseToRemoteMapParm>> it = set.iterator();
                this.lock.acquireWriteLock();
                lockHeld = true;
                while (it.hasNext()) {
                    Map.Entry<Long, AsmEnterpriseToRemoteMapParm> entry = it.next();
                    if (entry.getValue().getAddressMappingGroupId() != id) continue;
                    it.remove();
                }
            } else {
                log.warn((Object)("Null value in map for " + fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id));
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id + "; re-initializing. e = "), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(fcn_name + (Object)((Object)operation) + " operation on table " + tableName + " with key " + id + ". Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " Successful"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        boolean lockHeld = false;
        AsmEnterpriseToRemoteMapParm newAsmEnterpriseToRemoteMapParm = null;
        try {
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                newAsmEnterpriseToRemoteMapParm = (AsmEnterpriseToRemoteMapParm)this.dataSource.executeQuery(getAsmEnterpriseToRemoteMapById, params, this.getAsmEnterpriseToRemoteOneMapper());
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            if (this.asmEnterpriseToRemoteMap.remove(id) == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                log.warn((Object)(fcn_name + "AsmEnterpriseToRemoteMapParm was null for " + (Object)((Object)tableEvent.getOperation()) + " operation; we are probably out of sync"));
            }
            if (operation != DAOReplicationEvent.OperationType.DELETE && newAsmEnterpriseToRemoteMapParm != null) {
                if (isFiner) {
                    log.finer((Object)(AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".updateDAO: Retrieved " + newAsmEnterpriseToRemoteMapParm.toString()));
                }
                this.asmEnterpriseToRemoteMap.put(id, newAsmEnterpriseToRemoteMapParm);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing, e = "), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " Successful"));
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        list = new ArrayList();
        list.add("asm_enterprise_to_remote_map");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmEnterpriseToRemoteMapParm getEnterpriseToRemoteMapById(Long id) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".get: AsmEnterpriseToRemoteMapDAO" + id;
        try {
            this.lock.acquireReadLock();
            for (AsmEnterpriseToRemoteMapParm asmETRMP : this.asmEnterpriseToRemoteMap.values()) {
                if (asmETRMP.getId().longValue() != id.longValue()) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " :  Mapped SM Remote Address is : " + this.asmEnterpriseToRemoteMap.get(asmETRMP.getId())));
                }
                AsmEnterpriseToRemoteMapParm asmEnterpriseToRemoteMapParm = this.asmEnterpriseToRemoteMap.get(asmETRMP.getId());
                return asmEnterpriseToRemoteMapParm;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getAsmInstanceIdFromRemoteAddress(String ipAddressToBeMapped, Long groupId) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".getAsmInstanceIdFromRemoteAddress:";
        Long defaultAsmInstanceId = new Long(-1L);
        try {
            this.lock.acquireReadLock();
            FQDNOrIpAddr ipAddrToBeMapped = new FQDNOrIpAddr(ipAddressToBeMapped);
            for (AsmEnterpriseToRemoteMapParm asmETRMP : this.asmEnterpriseToRemoteMap.values()) {
                Long asmInstanceId;
                if (!ipAddrToBeMapped.isEqualTo(asmETRMP.getRemoteAddress()) || asmETRMP.getAddressMappingGroupId().longValue() != groupId.longValue() || (asmInstanceId = asmETRMP.getEnterpriseAsmInstanceId()) == null) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " ipAddressToBeMapped = " + ipAddressToBeMapped + ", groupId = " + groupId + ", asmInstanceId =  " + asmInstanceId));
                }
                Long l = asmInstanceId;
                return l;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)(fcn_name + " ipAddressToBeMapped = " + ipAddressToBeMapped + ", groupId = " + groupId + ", asmInstanceId =  " + defaultAsmInstanceId));
        }
        return defaultAsmInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteAddressFromEnterpriseAddress(String ipAddressToBeMapped, Long groupId) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".getRemoteAddressFromEnterpriseAddress : " + ipAddressToBeMapped;
        String defaultAddress = "";
        try {
            this.lock.acquireReadLock();
            FQDNOrIpAddr ipAddrToBeMapped = new FQDNOrIpAddr(ipAddressToBeMapped);
            for (AsmEnterpriseToRemoteMapParm asmETRMP : this.asmEnterpriseToRemoteMap.values()) {
                String addr;
                if (!ipAddrToBeMapped.isEqualTo(asmETRMP.getEnterpriseAddress()) || asmETRMP.getAddressMappingGroupId().longValue() != groupId.longValue() || (addr = asmETRMP.getRemoteAddress()) == null) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Mapped remote address is : " + addr));
                }
                String string = addr;
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return defaultAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnterpriseAddressFromRemoteAddress(String ipAddressToBeMapped, Long groupId) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".getEnterpriseAddressFromRemoteAddress : " + ipAddressToBeMapped;
        String defaultAddress = "";
        try {
            this.lock.acquireReadLock();
            FQDNOrIpAddr ipAddrToBeMapped = new FQDNOrIpAddr(ipAddressToBeMapped);
            for (AsmEnterpriseToRemoteMapParm asmETRMP : this.asmEnterpriseToRemoteMap.values()) {
                String addr;
                if (!ipAddrToBeMapped.isEqualTo(asmETRMP.getRemoteAddress()) || asmETRMP.getAddressMappingGroupId().longValue() != groupId.longValue() || (addr = asmETRMP.getEnterpriseAddress()) == null) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + " : Mapped enterprise address is : " + addr));
                }
                String string = addr;
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return defaultAddress;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (log.isFinerEnabled()) {
            log.finer((Object)(AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmAddressMappingGroupParm || newObject instanceof AsmAddressMappingGroupParm) {
            AsmAddressMappingGroupParm oldAsmAddressMappingGroupParm = (AsmAddressMappingGroupParm)oldObject;
            AsmAddressMappingGroupParm newAsmAddressMappingGroupParm = (AsmAddressMappingGroupParm)newObject;
            if (oldAsmAddressMappingGroupParm != null && newAsmAddressMappingGroupParm != null && oldAsmAddressMappingGroupParm.equals(newAsmAddressMappingGroupParm)) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".objectChanged:  groupId CHANGED with same groupId - ignored"));
                }
                return;
            }
            if (oldAsmAddressMappingGroupParm != null) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)(AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".objectChanged: group mapping with id " + oldAsmAddressMappingGroupParm.getId() + " DELETED"));
                }
                DAOTableEvent event = new DAOTableEvent("asm_enterprise_to_remote_map", DAOReplicationEvent.OperationType.DELETE, oldAsmAddressMappingGroupParm.getId());
                this.cascadeDeleteDAO(event);
            }
            if (newObject != null && log.isFinestEnabled()) {
                log.finest((Object)(AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".objectChanged: receive event notify that a new group id " + newAsmAddressMappingGroupParm.getId() + " is added in mapping group table "));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRemoteAddressFromAsmInstanceIdAndGroupId(Long asmInstanceId, Long groupId, IPAddress.IPAddressFamily endptIpFamily) {
        String fcn_name = AsmEnterpriseToRemoteMapDAO.class.getSimpleName() + ".getRemoteAddressFromAsmInstanceIdAndGroupId: ";
        String defaultAddress = "";
        try {
            this.lock.acquireReadLock();
            for (AsmEnterpriseToRemoteMapParm asmETRMP : this.asmEnterpriseToRemoteMap.values()) {
                String addr;
                if (log.isFinestEnabled()) {
                    log.finest((Object)(fcn_name + asmETRMP.getEnterpriseAsmInstanceId() + "/" + asmInstanceId + "; " + asmETRMP.getAddressMappingGroupId() + "/" + groupId + "; " + asmETRMP.getIpaddrFamily() + "/" + endptIpFamily.toString()));
                }
                if (asmETRMP.getEnterpriseAsmInstanceId().longValue() != asmInstanceId.longValue() || asmETRMP.getAddressMappingGroupId().longValue() != groupId.longValue() || !asmETRMP.getIpaddrFamily().equalsIgnoreCase(endptIpFamily.toString()) || (addr = asmETRMP.getRemoteAddress()) == null) continue;
                if (log.isFinerEnabled()) {
                    log.finer((Object)(fcn_name + "asmInstanceId = " + asmInstanceId + ", groupId = " + groupId + ", mapped remote address = " + addr + ", endpt IP family = " + (Object)((Object)endptIpFamily) + "/" + asmETRMP.getIpaddrFamily()));
                }
                String string = addr;
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)(fcn_name + "asmInstanceId = " + asmInstanceId + ", groupId = " + groupId + ", unmapped default address = " + "" + ", endpt IP family = " + (Object)((Object)endptIpFamily)));
        }
        return "";
    }

    static {
        asmEnterpriseToRemotesMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashMap<Long, AsmEnterpriseToRemoteMapParm> map = new HashMap<Long, AsmEnterpriseToRemoteMapParm>();
                while (rs.next()) {
                    Long id = rs.getLong("id");
                    String enterpriseAddress = rs.getString("enterprise_address");
                    String remoteAddress = rs.getString("remote_address");
                    String ipaddrFamily = rs.getString("ipaddr_family");
                    Long groupId = rs.getLong("address_mapping_group_id");
                    Long asmInstanceId = rs.getLong("enterprise_asminstance_id");
                    AsmEnterpriseToRemoteMapParm asmEnterpriseToRemoteMapParm = new AsmEnterpriseToRemoteMapParm(id, enterpriseAddress, remoteAddress, ipaddrFamily, groupId, asmInstanceId);
                    map.put(id, asmEnterpriseToRemoteMapParm);
                }
                return map;
            }
        };
        asmEnterpriseToRemoteOneMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    Long id = rs.getLong("id");
                    String enterpriseAddress = rs.getString("enterprise_address");
                    String remoteAddress = rs.getString("remote_address");
                    String ipaddrFamily = rs.getString("ipaddr_family");
                    Long groupId = rs.getLong("address_mapping_group_id");
                    Long asmInstanceId = rs.getLong("enterprise_asminstance_id");
                    return new AsmEnterpriseToRemoteMapParm(id, enterpriseAddress, remoteAddress, ipaddrFamily, groupId, asmInstanceId);
                }
                return null;
            }
        };
    }
}

