/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.CommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.CmCommProfile;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CmCommProfileDAO
extends CommProfileDAO {
    private final Logger log = AsmLogger.getLogger(CmCommProfileDAO.class);
    public static final String commProfileType = "CM";
    private final String getCmCommProfileBySetId = this.getSelectFields() + " WHERE cs.cscommprofilesetid=?";
    private static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, CmCommProfile> profileMap = new ConcurrentHashMap<Long, CmCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new CmCommProfile((Long)id, (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("station_id")));
            }
            return profileMap;
        }
    };
    private static final ResultSetMapper mapperGetcmCommProfileBySetId = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            CmCommProfile cmCommProfile = null;
            if (rs.next()) {
                cmCommProfile = new CmCommProfile((Long)rs.getLong("id"), (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("station_id"));
            }
            return cmCommProfile;
        }
    };

    @Override
    public String getMainTable() {
        return "cmcommprofile";
    }

    @Override
    protected String getSelectFields() {
        return "SELECT cs.id, cs.cscommprofilesetid, cs.preferredhandleid, cm.station_id FROM cscommprofile cs JOIN cmcommprofile cm ON cs.id=cm.id";
    }

    @Override
    protected ResultSetMapper getMapper() {
        return mapper;
    }

    public CmCommProfile getCmCommProfile(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null) {
                CmCommProfile cmCommProfile = (CmCommProfile)this.csCommProfileMap.get(id);
                return cmCommProfile;
            }
            CmCommProfile cmCommProfile = null;
            return cmCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public CmCommProfile getCmCommProfileBySetId(Long setId) {
        String fcn_name = "getCmCommProfileBySetId";
        CmCommProfile cmCommProfile = null;
        Long id = (Long)this.setIdMap.get(setId);
        if (id != null) {
            return (CmCommProfile)this.csCommProfileMap.get(id);
        }
        if (this.localOnly) {
            Object[] params = new Object[]{setId};
            try {
                cmCommProfile = (CmCommProfile)this.dataSource.executeQuery(this.getCmCommProfileBySetId, params, mapperGetcmCommProfileBySetId);
            }
            catch (DMException e) {
                this.log.error((Object)("getCmCommProfileBySetId: Exception while executing query=" + this.getCmCommProfileBySetId), (Throwable)e);
            }
            return cmCommProfile;
        }
        return cmCommProfile;
    }

    @SMConsole(description="Get all CmCommProfiles cached in memory.")
    public Map<Long, CsCommProfile> getCmCommProfiles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsCommProfile> map = Collections.unmodifiableMap(this.csCommProfileMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected String getCommProfileType() {
        return commProfileType;
    }

    public static void main(String[] args) {
        CmCommProfileDAO dao = new CmCommProfileDAO();
        dao.printQueries();
    }
}

