/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmTerminalGroupParm;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceSettingsDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(DeviceSettingsDAO.class);
    protected Map<Long, AsmTerminalGroupParm> deviceSettingsMap = new HashMap<Long, AsmTerminalGroupParm>();
    public static final String getAllDeviceSettings = "SELECT id, name, terminal_group_num, reg_expire_secs, reg_min_expire_secs, line_resv_secs, afs_sub_expire_secs, afs_sub_min_expire_secs,  ds_sub_expire_secs, ds_sub_min_expire_secs, mw_sub_expire_secs, mw_sub_min_expire_secs,  ppm_sub_expire_secs, ppm_sub_min_expire_secs, regev_sub_expire_secs, regev_sub_min_expire_secs,  ringer_volume, ringer_cadence, receiver_volume, speaker_volume, vmmserver_ipaddress,  vmmserver_port, vmmreport_period_secs, snmp_ipaddress, snmp_community, station_admin_password,  complex_password_salt, complex_password_algorithm, complex_password_hash,  quick_login_status, reactive_mon_intvl_secs, timer_b_secs, registration_policy, vlan_number,  call_control_phb, audio_phb, video_phb, call_control_802_priority, audio_802_priority, video_802_priority,  signaling_mode, media_mode, time_zone FROM asmterminalgroupparm";
    public static final String getDeviceSettingsById = "SELECT id, name, terminal_group_num, reg_expire_secs, reg_min_expire_secs, line_resv_secs, afs_sub_expire_secs, afs_sub_min_expire_secs,  ds_sub_expire_secs, ds_sub_min_expire_secs, mw_sub_expire_secs, mw_sub_min_expire_secs,  ppm_sub_expire_secs, ppm_sub_min_expire_secs, regev_sub_expire_secs, regev_sub_min_expire_secs,  ringer_volume, ringer_cadence, receiver_volume, speaker_volume, vmmserver_ipaddress,  vmmserver_port, vmmreport_period_secs, snmp_ipaddress, snmp_community, station_admin_password,  complex_password_salt, complex_password_algorithm, complex_password_hash,  quick_login_status, reactive_mon_intvl_secs, timer_b_secs, registration_policy, vlan_number,  call_control_phb, audio_phb, video_phb, call_control_802_priority, audio_802_priority, video_802_priority,  signaling_mode, media_mode, time_zone FROM asmterminalgroupparm WHERE id = ?";
    protected static final String defaultGroupName = "Default Group";
    private static final ResultSetMapper deviceSettingsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmTerminalGroupParm> map = new HashMap<Long, AsmTerminalGroupParm>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                String groupName = rs.getString("name");
                Integer terminalGroupNum = rs.getInt("terminal_group_num");
                terminalGroupNum = terminalGroupNum == 0 ? (groupName.equals(DeviceSettingsDAO.defaultGroupName) ? Integer.valueOf(0) : null) : terminalGroupNum;
                HashMap<String, Integer> minSubscriptionExpirationMap = new HashMap<String, Integer>();
                minSubscriptionExpirationMap.put("avaya-cm-feature-status", rs.getInt("afs_sub_min_expire_secs"));
                minSubscriptionExpirationMap.put("dialog", rs.getInt("ds_sub_min_expire_secs"));
                minSubscriptionExpirationMap.put("message-summary", rs.getInt("mw_sub_min_expire_secs"));
                minSubscriptionExpirationMap.put("avaya-ccs-profile", rs.getInt("ppm_sub_min_expire_secs"));
                minSubscriptionExpirationMap.put("reg", rs.getInt("regev_sub_min_expire_secs"));
                HashMap<String, Integer> maxSubscriptionExpirationMap = new HashMap<String, Integer>();
                maxSubscriptionExpirationMap.put("avaya-cm-feature-status", rs.getInt("afs_sub_expire_secs"));
                maxSubscriptionExpirationMap.put("dialog", rs.getInt("ds_sub_expire_secs"));
                maxSubscriptionExpirationMap.put("message-summary", rs.getInt("mw_sub_expire_secs"));
                maxSubscriptionExpirationMap.put("avaya-ccs-profile", rs.getInt("ppm_sub_expire_secs"));
                maxSubscriptionExpirationMap.put("reg", rs.getInt("regev_sub_expire_secs"));
                AsmTerminalGroupParm asmTerminalGroupParms = new AsmTerminalGroupParm(id, groupName, terminalGroupNum, rs.getInt("reg_min_expire_secs"), rs.getInt("reg_expire_secs"), rs.getInt("line_resv_secs"), minSubscriptionExpirationMap, maxSubscriptionExpirationMap, rs.getInt("ringer_volume"), rs.getInt("ringer_cadence"), rs.getInt("receiver_volume"), rs.getInt("speaker_volume"), rs.getString("vmmserver_ipaddress"), rs.getInt("vmmserver_port"), rs.getInt("vmmreport_period_secs"), rs.getString("snmp_ipaddress"), rs.getString("snmp_community"), rs.getString("station_admin_password"), rs.getString("complex_password_salt"), rs.getString("complex_password_algorithm"), rs.getString("complex_password_hash"), rs.getString("quick_login_status"), rs.getInt("reactive_mon_intvl_secs"), rs.getInt("timer_b_secs"), rs.getString("registration_policy"), rs.getInt("vlan_number"), rs.getInt("call_control_phb"), rs.getInt("audio_phb"), rs.getInt("video_phb"), rs.getInt("call_control_802_priority"), rs.getInt("audio_802_priority"), rs.getInt("video_802_priority"), rs.getString("signaling_mode"), rs.getString("media_mode"), rs.getString("time_zone"));
                map.put(id, asmTerminalGroupParms);
            }
            return map;
        }
    };

    public DeviceSettingsDAO() {
        super(true);
    }

    public ResultSetMapper getDeviceSettingsMapper() {
        return deviceSettingsMapper;
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        HashMap deviceSettingsMapTMP;
        String fcn_name = DeviceSettingsDAO.class.getSimpleName() + ".init: ";
        boolean isFine = log.isFineEnabled();
        if (isFine) {
            log.fine((Object)(fcn_name + "Enter"));
        }
        Object[] params = new Object[]{};
        try {
            deviceSettingsMapTMP = (HashMap)this.dataSource.executeQuery(getAllDeviceSettings, params, this.getDeviceSettingsMapper());
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error" + fcn_name), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.deviceSettingsMap = deviceSettingsMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
                if (isFine) {
                    log.fine((Object)(fcn_name + "completed"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        String fcn_name = DeviceSettingsDAO.class.getSimpleName() + ".updateDAO: ";
        boolean isFine = log.isFineEnabled();
        boolean isFiner = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = tableEvent.getKey();
        if (isFine) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean lockHeld = false;
        AsmTerminalGroupParm oldObject = null;
        AsmTerminalGroupParm newObject = null;
        try {
            block20: {
                try {
                    AsmTerminalGroupParm oldDeviceSettings;
                    AsmTerminalGroupParm newDeviceSettings = null;
                    Map dbMap = null;
                    if (operation != DAOReplicationEvent.OperationType.INSERT && (oldDeviceSettings = this.deviceSettingsMap.get(id)) != null) {
                        oldObject = oldDeviceSettings;
                    }
                    if (operation != DAOReplicationEvent.OperationType.DELETE) {
                        Object[] params = new Object[]{id};
                        dbMap = (Map)this.dataSource.executeQuery(getDeviceSettingsById, params, this.getDeviceSettingsMapper());
                        newObject = newDeviceSettings = (AsmTerminalGroupParm)dbMap.get(id);
                    }
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    if (this.deviceSettingsMap.remove(id) == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                        log.warn((Object)(fcn_name + "AsmTerminalGroupParm was null for " + (Object)((Object)tableEvent.getOperation()) + " operation; we are probably out of sync"));
                    }
                    if (operation != DAOReplicationEvent.OperationType.DELETE && newDeviceSettings != null) {
                        if (isFiner) {
                            log.finer((Object)(fcn_name + "Retrieved " + newDeviceSettings.toString()));
                        }
                        this.deviceSettingsMap.put(id, newDeviceSettings);
                    }
                }
                catch (Exception e) {
                    if (lockHeld) {
                        this.lock.releaseWriteLock();
                        lockHeld = false;
                    }
                    log.error((Object)("Error updating " + this.logTag(operation, tableName, id) + "; re-initializing. e = "), (Throwable)e);
                    this.reinit();
                    if (this.okay()) break block20;
                    log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                    if (lockHeld) {
                        this.lock.releaseWriteLock();
                    }
                    if (isFine) {
                        log.fine((Object)(fcn_name + " Successful"));
                    }
                    return;
                }
            }
            if (isFine) {
                log.fine((Object)(fcn_name + ": oldObject=" + oldObject + ", newObject=" + newObject));
            }
            if (oldObject != null || newObject != null) {
                this.updateListeners(oldObject, newObject);
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
            if (isFine) {
                log.fine((Object)(fcn_name + " Successful"));
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmterminalgroupparm");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmTerminalGroupParm getDeviceSettingsMap(int termGrpNum) {
        String fcn_name = DeviceSettingsDAO.class.getSimpleName() + ".getDeviceSettingsMap: " + termGrpNum;
        boolean isFiner = log.isFineEnabled();
        try {
            this.lock.acquireReadLock();
            for (AsmTerminalGroupParm asmTGP : this.deviceSettingsMap.values()) {
                if (asmTGP.getTerminalGroupNumber() == null || !asmTGP.getTerminalGroupNumber().equals(termGrpNum)) continue;
                if (isFiner) {
                    log.finer((Object)(fcn_name + " : Found Device Settings: " + this.deviceSettingsMap.get(asmTGP.getId())));
                }
                AsmTerminalGroupParm asmTerminalGroupParm = this.deviceSettingsMap.get(asmTGP.getId());
                return asmTerminalGroupParm;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }
}

