/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.DAOResult;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.DynAsmCommProfile;
import com.avaya.asm.datamgr.objectapi.DynamicAsmCommProfile;
import com.avaya.asm.datamgr.objectapi.SkinnyAsmCommProfile;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicAsmCommProfileDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(DynamicAsmCommProfileDAO.class);
    protected static final String initDynAsmCommProfileTable = "TRUNCATE dyn_asmcommprofile;INSERT INTO dyn_asmcommprofile (id, dyn_usercommunity_id, dyn_survivability_server_id) SELECT id, usercommunity_id AS dyn_usercommunity_id, survivability_server_id AS dyn_survivability_server_id FROM asmcommprofile;DELETE FROM dyn_asmcommprofile WHERE id IN (SELECT cs.id FROM cscommprofile cs JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON u.id=set.csuserid WHERE cs.commprofiletype='SIP' AND u.isdeleted=true)";
    protected static final String setIsLocalBySurvivabilityServerId = "UPDATE dyn_asmcommprofile SET is_local=true WHERE dyn_survivability_server_id=?";
    protected static final String setIsLocalByUserCommunityId = "UPDATE dyn_asmcommprofile SET is_local=true WHERE dyn_usercommunity_id IN (SELECT asmusercommunity_id from asmusercommunityassign WHERE asminstance_id=?);";
    protected static final String setIsLocalByAsmCompactId = "UPDATE dyn_asmcommprofile SET is_local=true WHERE dyn_usercommunity_id < 0 AND ((-dyn_usercommunity_id)>>?)&?=?;";
    protected static final String setIsLocalByCommProfileSetId = "UPDATE dyn_asmcommprofile SET is_local=true WHERE id IN (SELECT id from cscommprofile WHERE commprofiletype='SIP' AND cscommprofilesetid IN (###))";
    protected static final String updateSurvivabilityServerIdByIsLocal = "UPDATE dyn_asmcommprofile SET dyn_survivability_server_id=? WHERE is_local=true";
    protected static final String updateUserCommIdAndSurvivabilityServerId = "INSERT INTO dyn_asmcommprofile(id, is_local, dyn_usercommunity_id, dyn_survivability_server_id) VALUES(?,?,?,?) ON CONFLICT(id) DO UPDATE SET is_local=?, dyn_usercommunity_id=?, dyn_survivability_server_id=? WHERE dyn_asmcommprofile.id=?";
    protected static final String getAsmCommProfile = "SELECT asm.id, asm.usercommunity_id, asm.survivability_server_id, asm.homelocation_id, asm.asm_assign_policy_id, asm.asm_region_community_id FROM asmcommprofile asm JOIN cscommprofile cs ON cs.id=asm.id JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON u.id=set.csuserid WHERE u.isdeleted=false AND asm.id=?";
    protected static final String getCommProfileIdByUserId = "SELECT cs.id FROM cscommprofile cs JOIN cscommprofileset set ON set.id=cs.cscommprofilesetid JOIN csuser u ON set.csuserid=u.id WHERE cs.commprofiletype='SIP' AND u.id=?";
    protected static final String getDynAsmCommProfiles = "SELECT id, dyn_usercommunity_id, dyn_survivability_server_id, is_local FROM dyn_asmcommprofile";
    protected static final String getDynAsmCommProfileByCommProfileId = "SELECT id, dyn_usercommunity_id, dyn_survivability_server_id, is_local FROM dyn_asmcommprofile WHERE id=?";
    protected static final String deleteDynAsmCommProfile = "DELETE FROM dyn_asmcommprofile WHERE id=?";
    protected static final String getCommProfileIdByCommProfileSetId = "SELECT id, cscommprofilesetid FROM cscommprofile WHERE commprofiletype='SIP' AND cscommprofilesetid=?";
    protected static final String getCommProfileSetIdByCommProfileId = "SELECT id, cscommprofilesetid FROM cscommprofile WHERE id=?";
    private static List<String> dependentTables = new ArrayList<String>();
    private static final ResultSetMapper mapper;
    private static final ResultSetMapper dynAsmCommProfileMapper;
    private static final ResultSetMapper commProfileIdMapper;
    private static final ResultSetMapper commProfileSetIdMapper;
    protected static final ResultSetMapper csUserMapper;

    public DynamicAsmCommProfileDAO() {
        super(true);
    }

    @Override
    public DataMgr.Status reinit() {
        log.info((Object)"reinit: reinitializing!!!");
        DataMgr.Status status = super.reinit();
        if (DataMgr.Status.OKAY.equals((Object)status)) {
            this.updateListeners(null, new SkinnyAsmCommProfile(0L, null, null, null, null, null));
        }
        return status;
    }

    @Override
    public void init() {
        this.setStatus(DataMgr.Status.OKAY);
    }

    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        SkinnyAsmCommProfile newProfile;
        SkinnyAsmCommProfile oldProfile;
        Long id;
        String tableName;
        DAOReplicationEvent.OperationType operation;
        block16: {
            operation = tableEvent.getOperation();
            tableName = tableEvent.getTableName();
            id = tableEvent.getKey();
            if (log.isFineEnabled()) {
                log.fine((Object)this.logTag(operation, tableName, id));
            }
            oldProfile = null;
            newProfile = null;
            try {
                if ("csuser".equals(tableName)) {
                    Long commProfileId;
                    if (operation == DAOReplicationEvent.OperationType.UPDATE && (commProfileId = (Long)this.dataSource.executeQuery(getCommProfileIdByUserId, new Object[]{id}, csUserMapper)) != null) {
                        Map map = (Map)this.dataSource.executeQuery(getAsmCommProfile, new Object[]{commProfileId}, mapper);
                        if (map.isEmpty()) {
                            oldProfile = new SkinnyAsmCommProfile(commProfileId, null, null, null, null, null);
                        } else {
                            newProfile = (SkinnyAsmCommProfile)map.get(commProfileId);
                        }
                    }
                } else if ("asmcommprofile".equals(tableName) || "dyn_asmcommprofile".equals(tableName)) {
                    if (operation != DAOReplicationEvent.OperationType.DELETE) {
                        if ("dyn_asmcommprofile".equals(tableName)) {
                            String dynUserCommunityId = tableEvent.getTblEventData().get("dyn_usercommunity_id");
                            Long userCommunityId = Long.valueOf(dynUserCommunityId);
                            Long survivabilityServerId = dynUserCommunityId != null ? Long.valueOf(dynUserCommunityId) : null;
                            newProfile = new SkinnyAsmCommProfile(id, userCommunityId, survivabilityServerId, null, null, null);
                        } else {
                            Map map = (Map)this.dataSource.executeQuery(getAsmCommProfile, new Object[]{id}, mapper);
                            newProfile = (SkinnyAsmCommProfile)map.get(id);
                        }
                    }
                    if (operation != DAOReplicationEvent.OperationType.INSERT) {
                        oldProfile = new SkinnyAsmCommProfile(id, null, null, null, null, null);
                    }
                } else {
                    log.warn((Object)("updatedDAO: received unexpected event: " + tableEvent));
                }
            }
            catch (DMException e) {
                oldProfile = null;
                newProfile = null;
                log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (this.okay()) break block16;
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        if (oldProfile != null || newProfile != null) {
            this.updateListeners(oldProfile, newProfile);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        return dependentTables;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    public void initMainTable() {
        try {
            Object[] params = new Object[]{};
            this.dataSource.executeUpdate(initDynAsmCommProfileTable, params);
        }
        catch (DMException e) {
            log.error((Object)("initMainTable: caught DMException: " + e), (Throwable)e);
        }
    }

    public Long getAsmCommProfileId(Long commProfileSetId) {
        try {
            Object[] params = new Object[]{commProfileSetId};
            Map map = (Map)this.dataSource.executeQuery(getCommProfileIdByCommProfileSetId, params, commProfileIdMapper);
            return (Long)map.get(commProfileSetId);
        }
        catch (DMException e) {
            return null;
        }
    }

    public Long getCommProfileSetId(Long asmCommProfileId) {
        try {
            Object[] params = new Object[]{asmCommProfileId};
            Map map = (Map)this.dataSource.executeQuery(getCommProfileSetIdByCommProfileId, params, commProfileSetIdMapper);
            return (Long)map.get(asmCommProfileId);
        }
        catch (DMException e) {
            return null;
        }
    }

    public void setUserCommunityAndSurvivabilityServer(long commProfileId, boolean isLocal, Long userCommunityId, Long survivabilityServerId) throws DMException {
        Object[] params = new Object[]{commProfileId, isLocal, userCommunityId, survivabilityServerId, isLocal, userCommunityId, survivabilityServerId, commProfileId};
        DAOResult result = this.dataSource.executeUpdate(updateUserCommIdAndSurvivabilityServerId, params);
        if (result.empty()) {
            throw new DMException("Empty result from update");
        }
    }

    public void setUserCommunityBulk(List<DynAsmCommProfile> profiles) {
        StringBuilder buf = new StringBuilder("UPDATE dyn_asmcommprofile AS dasm SET dyn_usercommunity_id=asm.dyn_usercommunity_id FROM (VALUES");
        for (DynAsmCommProfile profile : profiles) {
            buf.append("(");
            buf.append(profile.getCommProfileId());
            buf.append(",");
            buf.append(profile.getUserCommunityId());
            buf.append("),");
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append(") AS asm(id,dyn_usercommunity_id) WHERE asm.id=dasm.id;");
        if (log.isFinestEnabled()) {
            log.finest((Object)("setUserCommunityBulk: executing update: '" + buf.toString() + "'"));
        }
        try {
            Object[] params = new Object[]{};
            this.dataSource.executeUpdate(buf.toString(), params);
        }
        catch (DMException e) {
            log.error((Object)("setUserCommunityBulk: caught DMException: " + e), (Throwable)e);
        }
    }

    public void deleteDynAsmCommProfile(long commProfileId) throws DMException {
        Object[] params = new Object[]{commProfileId};
        this.dataSource.executeUpdate(deleteDynAsmCommProfile, params);
    }

    public void setIsLocalByUserCommunityId(Long asmInstanceId) {
        try {
            Object[] params = new Object[]{asmInstanceId};
            this.dataSource.executeUpdate(setIsLocalByUserCommunityId, params);
        }
        catch (DMException e) {
            log.error((Object)("setIsLocalByUserCommunityId: caught DMException: " + e), (Throwable)e);
        }
    }

    public void setIsLocalByAsmCompactId(int compactId) {
        for (int i = 0; i < AsmConstants.USER_COMMUNITY_ID.MAX_USERCOMMUNITY_ASM; ++i) {
            try {
                Object[] params = new Object[]{i * AsmConstants.USER_COMMUNITY_ID.COMPACT_ID_BITS, AsmConstants.USER_COMMUNITY_ID.COMPACT_ID_MASK, compactId};
                this.dataSource.executeUpdate(setIsLocalByAsmCompactId, params);
                continue;
            }
            catch (DMException e) {
                log.error((Object)("setIsLocalByUserCommunityId: caught DMException: " + e), (Throwable)e);
            }
        }
    }

    public void setIsLocalBySurvivabilityServerId(Long survivabilityServerId) {
        try {
            Object[] params = new Object[]{survivabilityServerId};
            this.dataSource.executeUpdate(setIsLocalBySurvivabilityServerId, params);
        }
        catch (DMException e) {
            log.error((Object)("setIsLocalBySurvivabilityServerId: caught DMException: " + e), (Throwable)e);
        }
    }

    public void updateSurvivabilityServerIdByIsLocal(Long survivabilityServerId) {
        try {
            Object[] params = new Object[]{survivabilityServerId};
            this.dataSource.executeUpdate(updateSurvivabilityServerIdByIsLocal, params);
        }
        catch (DMException e) {
            log.error((Object)("updateSurvivabilityServerIdByIsLocal: caught DMException: " + e), (Throwable)e);
        }
    }

    public void setIsLocalByCommProfileSetId(Collection<Long> commProfileSetIds) {
        try {
            String idsStr = commProfileSetIds.toString();
            int len = idsStr.length();
            String query = setIsLocalByCommProfileSetId.replace("###", idsStr.substring(1, len - 1));
            this.dataSource.executeUpdate(query, new Object[0]);
        }
        catch (DMException e) {
            log.error((Object)("setIsLocalByCommProfileSetId: caught DMException: " + e), (Throwable)e);
        }
    }

    public Map<Long, DynamicAsmCommProfile> getDynamicAsmCommProfile(long commProfileId) {
        try {
            return (Map)this.dataSource.executeQuery(getDynAsmCommProfileByCommProfileId, new Object[]{commProfileId}, dynAsmCommProfileMapper);
        }
        catch (DMException e) {
            return null;
        }
    }

    public Map<Long, DynamicAsmCommProfile> getAllDynamicAsmCommProfiles() {
        try {
            return (Map)this.dataSource.executeQuery(getDynAsmCommProfiles, new Object[0], dynAsmCommProfileMapper);
        }
        catch (DMException e) {
            return null;
        }
    }

    static {
        dependentTables.add("asmcommprofile");
        dependentTables.add("csuser");
        mapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ConcurrentHashMap<Long, SkinnyAsmCommProfile> profileMap = new ConcurrentHashMap<Long, SkinnyAsmCommProfile>();
                while (rs.next()) {
                    long id = rs.getLong("id");
                    profileMap.put(id, new SkinnyAsmCommProfile(id, (Long)rs.getObject("usercommunity_id"), (Long)rs.getObject("survivability_server_id"), (Long)rs.getObject("homelocation_id"), (Long)rs.getObject("asm_assign_policy_id"), (Long)rs.getObject("asm_region_community_id")));
                }
                return profileMap;
            }
        };
        dynAsmCommProfileMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ConcurrentHashMap<Long, DynamicAsmCommProfile> commProfileMap = new ConcurrentHashMap<Long, DynamicAsmCommProfile>();
                while (rs.next()) {
                    long id = rs.getLong("id");
                    commProfileMap.put(id, new DynamicAsmCommProfile(id, (Long)rs.getObject("dyn_usercommunity_id"), (Long)rs.getObject("dyn_survivability_server_id"), rs.getBoolean("is_local")));
                }
                return commProfileMap;
            }
        };
        commProfileIdMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ConcurrentHashMap<Long, Long> map = new ConcurrentHashMap<Long, Long>();
                while (rs.next()) {
                    map.put((Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("id"));
                }
                return map;
            }
        };
        commProfileSetIdMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ConcurrentHashMap<Long, Long> map = new ConcurrentHashMap<Long, Long>();
                while (rs.next()) {
                    map.put((Long)rs.getObject("id"), (Long)rs.getObject("cscommprofilesetid"));
                }
                return map;
            }
        };
        csUserMapper = new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getLong("id");
                }
                return null;
            }
        };
    }
}

