/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.EventPackage;
import com.avaya.asm.datamgr.objectapi.EventSubscription;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EventDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(EventDAO.class);
    protected HashMap<Long, List<EventSubscription>> setMap = new HashMap();
    protected HashMap<Long, Long> idMap = new HashMap();
    protected HashMap<Long, EventPackage> packageIdMap = new HashMap();
    protected HashMap<String, EventPackage> packageNameMap = new HashMap();
    protected static final String getEventSubscriptions = "SELECT id, subscriptionset_id, eventpackage_id, esh_sipEntity_id, esd_sipEntity_id FROM asmeventsubscription";
    protected static final String getEventSubscriptionsBySetId = "SELECT id, subscriptionset_id, eventpackage_id, esh_sipEntity_id, esd_sipEntity_id FROM asmeventsubscription WHERE subscriptionset_id = ?";
    protected static final String getEventSubscriptionById = "SELECT id, subscriptionset_id, eventpackage_id, esh_sipEntity_id, esd_sipEntity_id FROM asmeventsubscription WHERE id = ?";
    protected static final String getEventPackages = "SELECT id, name, defaulteventstateholder, defaulteventstatedistributor  FROM asmeventpackage";
    protected static final String getEventPackage = "SELECT id, name, defaulteventstateholder, defaulteventstatedistributor  FROM asmeventpackage WHERE id = ?";
    protected static final ResultSetMapper subscriptionsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap map = new HashMap();
            while (rs.next()) {
                long setId = rs.getLong("subscriptionset_id");
                if (!map.containsKey(setId)) {
                    map.put(setId, new ArrayList());
                }
                ((List)map.get(setId)).add(new EventSubscription(rs.getLong("id"), setId, rs.getLong("eventpackage_id"), (Long)rs.getObject("esh_sipEntity_id"), (Long)rs.getObject("esd_sipEntity_id")));
            }
            return map;
        }
    };
    protected static final ResultSetMapper packagesMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, EventPackage> packageMap = new HashMap<Long, EventPackage>();
            while (rs.next()) {
                long id = rs.getLong("id");
                packageMap.put(id, new EventPackage(id, rs.getString("name").trim(), rs.getString("defaulteventstateholder").trim(), rs.getString("defaulteventstatedistributor").trim()));
            }
            return packageMap;
        }
    };

    public EventDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap<String, EventPackage> packageNameMapTMP;
        HashMap packageIdMapTMP;
        HashMap setMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + EventDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            setMapTMP = (HashMap)this.dataSource.executeQuery(getEventSubscriptions, params, subscriptionsMapper);
            packageIdMapTMP = (HashMap)this.dataSource.executeQuery(getEventPackages, params, packagesMapper);
            packageNameMapTMP = new HashMap<String, EventPackage>();
            for (EventPackage eventPackage : packageIdMapTMP.values()) {
                packageNameMapTMP.put(eventPackage.getName(), eventPackage);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.setMap = setMapTMP;
                this.packageIdMap = packageIdMapTMP;
                this.packageNameMap = packageNameMapTMP;
                this.idMap = new HashMap();
                for (List list : this.setMap.values()) {
                    for (EventSubscription sub : list) {
                        this.idMap.put(sub.getId(), sub.getSubscriptionSetId());
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        int i;
        EventSubscription oldSubscription;
        DAOReplicationEvent.OperationType operation = event.getOperation();
        boolean locked = false;
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)(EventDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        ArrayList<EventPackage> oldPackages = new ArrayList<EventPackage>();
        ArrayList<EventPackage> newPackages = new ArrayList<EventPackage>();
        ArrayList<EventSubscription> oldSubscriptions = new ArrayList<EventSubscription>();
        ArrayList newSubscriptions = new ArrayList();
        try {
            this.lock.acquireWriteLock();
            locked = true;
            if ("asmeventsubscription".equals(tableName)) {
                Long setId = this.idMap.remove(id);
                oldSubscription = null;
                if (setId != null && this.setMap.containsKey(setId)) {
                    for (EventSubscription sub : this.setMap.get(setId)) {
                        if (sub.getId() != id.longValue()) continue;
                        oldSubscription = sub;
                        break;
                    }
                    this.setMap.get(setId).remove(oldSubscription);
                    oldSubscriptions.add(oldSubscription);
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getEventSubscriptionById, params, subscriptionsMapper);
                    if (map.size() != 1) {
                        throw new DMException("Invalid data for " + (Object)((Object)operation) + " event");
                    }
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        Long key;
                        setId = key = (Long)iterator.next();
                    }
                    if (map.get(setId) == null || ((List)map.get(setId)).size() != 1) {
                        throw new DMException("Invalid data for " + (Object)((Object)operation) + " event");
                    }
                    this.idMap.put(id, setId);
                    if (!this.setMap.containsKey(setId)) {
                        this.setMap.put(setId, new ArrayList());
                    }
                    this.setMap.get(setId).add((EventSubscription)((List)map.get(setId)).get(0));
                    newSubscriptions.add(((List)map.get(setId)).get(0));
                }
            } else if ("asmeventpackage".equals(tableName)) {
                EventPackage oldPackage = this.packageIdMap.remove(id);
                if (oldPackage != null) {
                    this.packageNameMap.remove(oldPackage.getName());
                    oldPackages.add(oldPackage);
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    log.warn((Object)("Event was null for " + (Object)((Object)operation) + "; we are probabaly out of sync."));
                }
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    Object[] params = new Object[]{id};
                    HashMap newMap = (HashMap)this.dataSource.executeQuery(getEventPackage, params, packagesMapper);
                    if (newMap.size() != 1) {
                        throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                    }
                    EventPackage newPackage = (EventPackage)newMap.get(id);
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new Duration " + newPackage + "for EventPackage " + id));
                    }
                    this.packageIdMap.put(id, newPackage);
                    this.packageNameMap.put(newPackage.getName(), newPackage);
                    newPackages.add(newPackage);
                }
            }
        }
        catch (Exception e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)("Error updating " + EventDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            oldPackages.clear();
            newPackages.clear();
            oldSubscriptions.clear();
            newSubscriptions.clear();
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        for (i = 0; i < (oldPackages.size() > newPackages.size() ? oldPackages.size() : newPackages.size()); ++i) {
            EventPackage newPackage;
            EventPackage oldPackage = oldPackages.size() > i ? (EventPackage)oldPackages.get(i) : null;
            EventPackage eventPackage = newPackage = newPackages.size() > i ? (EventPackage)newPackages.get(i) : null;
            if (log.isFinestEnabled()) {
                log.finest((Object)("Updating listeners with " + oldPackage + " changed to " + newPackage));
            }
            this.updateListeners(oldPackage, newPackage);
        }
        for (i = 0; i < (oldSubscriptions.size() > newSubscriptions.size() ? oldSubscriptions.size() : newSubscriptions.size()); ++i) {
            EventSubscription newSubscription;
            oldSubscription = oldSubscriptions.size() > i ? (EventSubscription)oldSubscriptions.get(i) : null;
            EventSubscription eventSubscription = newSubscription = newSubscriptions.size() > i ? (EventSubscription)newSubscriptions.get(i) : null;
            if (log.isFinestEnabled()) {
                log.finest((Object)("Updating listeners with " + oldSubscription + " changed to " + newSubscription));
            }
            this.updateListeners(oldSubscription, newSubscription);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(EventDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmeventsubscription");
        list.add("asmeventpackage");
        return list;
    }

    public List<EventSubscription> getEventSubscriptionSet(Long id) {
        try {
            this.lock.acquireReadLock();
            if (this.setMap.containsKey(id)) {
                List<EventSubscription> list = this.setMap.get(id);
                return list;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return new ArrayList<EventSubscription>();
    }

    public EventPackage getEventPackage(String name) {
        try {
            this.lock.acquireReadLock();
            EventPackage eventPackage = this.packageNameMap.get(name);
            return eventPackage;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public List<String> getEventPackageNames() {
        try {
            this.lock.acquireReadLock();
            ArrayList<String> returnList = new ArrayList<String>();
            returnList.addAll(this.packageNameMap.keySet());
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getSetsForPackage(long packageId, long eventStateHolder) {
        ArrayList<Long> setIds = new ArrayList<Long>();
        try {
            this.lock.acquireReadLock();
            block3: for (List<EventSubscription> list : this.setMap.values()) {
                for (EventSubscription subscription : list) {
                    if (subscription.getEventPackageId() != packageId || subscription.getEventStateHolder() != eventStateHolder) continue;
                    setIds.add(subscription.getSubscriptionSetId());
                    continue block3;
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return setIds;
    }

    @SMConsole(description="Get all provisioned Event Subscription Sets.")
    public HashMap<Long, List<EventSubscription>> getAllEventSubscriptionSets() {
        try {
            this.lock.acquireReadLock();
            HashMap<Long, List<EventSubscription>> hashMap = this.setMap;
            return hashMap;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Event Packages.")
    public HashMap<Long, EventPackage> getAllEventPackages() {
        try {
            this.lock.acquireReadLock();
            HashMap<Long, EventPackage> hashMap = this.packageIdMap;
            return hashMap;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public List<EventPackage> getEventPackages() {
        ArrayList<EventPackage> eventPacks = new ArrayList<EventPackage>();
        for (Map.Entry<Long, EventPackage> eventPack : this.getAllEventPackages().entrySet()) {
            eventPacks.add(eventPack.getValue());
        }
        return eventPacks;
    }

    @Override
    protected Object getMainCollection() {
        HashSet<Serializable> list = new HashSet<Serializable>();
        for (List<EventSubscription> esList : this.setMap.values()) {
            list.addAll(esList);
        }
        list.addAll(this.packageNameMap.values());
        return list;
    }

    public static final class EVENT_STATE_HOLDER {
        public static final String ASM = "local";
        public static final String CM = "homecm";
        public static final String PRIM_FS = "primaryfs";
    }

    public static final class EVENT_PACKAGE {
        public static final String BANDWIDTH = "bandwidth";
        public static final String DIALOG = "dialog";
        public static final String FEAT_STAT = "avaya-cm-feature-status";
        public static final String MSG_SUM = "message-summary";
        public static final String CALL_CENTER_INFO = "avaya-cm-cc-info";
        public static final String PPM = "avaya-ccs-profile";
        public static final String REG = "reg";
        public static final String RESYNC = "avaya-resync";
        public static final String PRESENCE = "presence";
        public static final String ECALERT = "av-ecalert";
        public static final String PUSH_NOTIFICATION = "avaya-push-notification";
        public static final String HOMING = "avaya-cm-homing";
    }
}

