/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.DigitPattern;
import com.avaya.asm.datamgr.objectapi.OriginationDigitPatternRow;
import com.avaya.asm.datamgr.objectapi.OriginationDigitPatternSet;
import com.avaya.asm.datamgr.objectapi.OriginationPatternSetRouter;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OriginationDigitPatternSetDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(OriginationDigitPatternSetDAO.class);
    private Map<Long, OriginationPatternSetRouter> origPatSetRouterMap = new ConcurrentHashMap<Long, OriginationPatternSetRouter>();
    private Map<Long, OriginationDigitPatternSet> origPatternSetMap = new ConcurrentHashMap<Long, OriginationDigitPatternSet>();
    private Map<Long, OriginationDigitPatternRow> origPatternRowMap = new ConcurrentHashMap<Long, OriginationDigitPatternRow>();
    private List<OriginationDigitPatternRow> origPatternRowMapValues = new ArrayList<OriginationDigitPatternRow>();
    public static final String queryAllOrigPatternSet = "SELECT id, name FROM digitmap_origination_pattern_set";
    public static final String queryOrigPatternSet = "SELECT id, name FROM digitmap_origination_pattern_set WHERE id = ?";
    public static final String queryAllOrigPatternRow = "SELECT id, mindigits, maxdigits, digitpattern, sipdomain_id, digitmap_origination_pattern_set_id FROM digitmap_origination_pattern";
    public static final String queryOrigPatternRow = "SELECT id, mindigits, maxdigits, digitpattern, sipdomain_id, digitmap_origination_pattern_set_id FROM digitmap_origination_pattern WHERE id = ?";
    private static final ResultSetMapper originationDigitPatternSetMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, OriginationDigitPatternSet> origPatSetMap = new ConcurrentHashMap<Long, OriginationDigitPatternSet>();
            while (rs.next()) {
                long id = rs.getLong("id");
                origPatSetMap.put(id, new OriginationDigitPatternSet(id, rs.getString("name")));
            }
            return origPatSetMap;
        }
    };
    private static final ResultSetMapper originationDigitPatternRowsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, OriginationDigitPatternRow> origPatRowMap = new ConcurrentHashMap<Long, OriginationDigitPatternRow>();
            while (rs.next()) {
                long id = rs.getLong("id");
                origPatRowMap.put(id, new OriginationDigitPatternRow(id, rs.getShort("mindigits"), rs.getShort("maxdigits"), rs.getString("digitpattern"), rs.getLong("sipdomain_id"), rs.getLong("digitmap_origination_pattern_set_id")));
            }
            return origPatRowMap;
        }
    };

    private void insertRowIntoOrigPatSetRouterMap(Map<Long, OriginationPatternSetRouter> origPatSetRouterMap, OriginationDigitPatternRow row) throws DMException {
        if (row == null) {
            return;
        }
        Long sipDomainId = row.getSipDomainId();
        OriginationPatternSetRouter origPatSetRouter = origPatSetRouterMap.get(sipDomainId);
        if (origPatSetRouter == null) {
            origPatSetRouter = new OriginationPatternSetRouter();
            origPatSetRouterMap.put(sipDomainId, origPatSetRouter);
        }
        try {
            for (DigitPattern pattern : row.getDigitPatterns()) {
                origPatSetRouter.insert(pattern, row);
            }
        }
        catch (IllegalArgumentException e1) {
            throw new DMException(e1);
        }
        catch (UnsupportedOperationException e2) {
            throw new DMException(e2);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Inserted " + row + " into OriginationPatternSetRouter"));
        }
    }

    private void deleteRowFromOrigPatSetRouterMap(OriginationDigitPatternRow row) throws DMException {
        OriginationPatternSetRouter origPatSetRouter;
        Long sipDomainId;
        block7: {
            if (row == null) {
                return;
            }
            sipDomainId = row.getSipDomainId();
            origPatSetRouter = this.origPatSetRouterMap.get(sipDomainId);
            if (origPatSetRouter == null) {
                throw new DMException(row + " existed in origPatternRowMap but not in origPatSetRouterMap!");
            }
            try {
                for (DigitPattern pattern : row.getDigitPatterns()) {
                    origPatSetRouter.delete(pattern, row);
                }
            }
            catch (UnsupportedOperationException e) {
                if ("pattern/min/max not found".equals(e.getMessage())) break block7;
                throw new DMException(e);
            }
        }
        if (origPatSetRouter.isEmpty()) {
            this.origPatSetRouterMap.remove(sipDomainId);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Removed " + row + " from OriginationPatternSetRouter"));
        }
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    @Override
    public synchronized void init() {
        if (log.isFineEnabled()) {
            log.info((Object)("Initializing " + OriginationDigitPatternSetDAO.class.getSimpleName()));
        }
        ConcurrentHashMap<Long, OriginationPatternSetRouter> origPatSetRouterMapTMP = new ConcurrentHashMap<Long, OriginationPatternSetRouter>();
        Map origPatternSetMapTMP = new ConcurrentHashMap();
        Map origPatternRowMapTMP = new ConcurrentHashMap();
        ArrayList origPatternRowMapValuesTMP = null;
        try {
            DMException innerException = null;
            Object[] params = new Object[]{};
            origPatternSetMapTMP = (Map)this.dataSource.executeQuery(queryAllOrigPatternSet, params, originationDigitPatternSetMapper);
            origPatternRowMapTMP = (Map)this.dataSource.executeQuery(queryAllOrigPatternRow, params, originationDigitPatternRowsMapper);
            origPatternRowMapValuesTMP = new ArrayList(origPatternRowMapTMP.values());
            for (Map.Entry entry : origPatternRowMapTMP.entrySet()) {
                try {
                    this.insertRowIntoOrigPatSetRouterMap(origPatSetRouterMapTMP, (OriginationDigitPatternRow)entry.getValue());
                }
                catch (DMException e1) {
                    this.setStatus(DataMgr.Status.FAIL);
                    log.error((Object)("Error on initializing for key=" + entry.getKey() + ", and value=" + entry.getValue()), (Throwable)e1);
                    innerException = e1;
                }
            }
            if (this.failed() && innerException != null) {
                throw innerException;
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e2) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e2);
            GenericAlarmHandler.handleFailureEvent(this, e2);
        }
        this.origPatSetRouterMap = origPatSetRouterMapTMP;
        this.origPatternSetMap = origPatternSetMapTMP;
        this.origPatternRowMap = origPatternRowMapTMP;
        this.origPatternRowMapValues = origPatternRowMapValuesTMP;
    }

    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        block19: {
            DAOReplicationEvent.OperationType operation = event.getOperation();
            String tableName = event.getTableName();
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            Long id = event.getKey();
            if (log.isFineEnabled()) {
                log.fine((Object)(OriginationDigitPatternSetDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
            }
            try {
                if ("digitmap_origination_pattern_set".equals(tableName)) {
                    OriginationDigitPatternSet remSet = this.origPatternSetMap.remove(id);
                    if (remSet == null && operation != DAOReplicationEvent.OperationType.INSERT) {
                        log.warn((Object)("Tried to remove a OriginationDigitPatternSet for a " + (Object)((Object)operation) + " that didn't exist; we are probably out of sync."));
                    }
                    if (operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) {
                        Object[] params = new Object[]{id};
                        Map sets = (Map)this.dataSource.executeQuery(queryOrigPatternSet, params, originationDigitPatternSetMapper);
                        OriginationDigitPatternSet set = (OriginationDigitPatternSet)sets.get(id);
                        if (set == null) {
                            throw new DMException("updateDAO query returned null");
                        }
                        if (log.isFinerEnabled()) {
                            log.finer((Object)("Retrieved new OriginationDigitPatternSet " + set));
                        }
                        this.origPatternSetMap.put(id, set);
                    }
                } else if ("digitmap_origination_pattern".equals(tableName)) {
                    OriginationDigitPatternRow remRow = this.origPatternRowMap.remove(id);
                    if (remRow != null) {
                        this.deleteRowFromOrigPatSetRouterMap(remRow);
                    } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                        log.warn((Object)("Tried to remove a OriginationDigitPatternRow for a " + (Object)((Object)operation) + " that didn't exist; we are probably out of sync."));
                    }
                    if (operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) {
                        Object[] params = new Object[]{id};
                        Map rows = (Map)this.dataSource.executeQuery(queryOrigPatternRow, params, originationDigitPatternRowsMapper);
                        OriginationDigitPatternRow row = (OriginationDigitPatternRow)rows.get(id);
                        if (row == null) {
                            throw new DMException("updateDAO query returned null");
                        }
                        if (log.isFinerEnabled()) {
                            log.finer((Object)("Retrieved new OriginationDigitPatternRow " + row));
                        }
                        this.origPatternRowMap.put(id, row);
                        this.insertRowIntoOrigPatSetRouterMap(this.origPatSetRouterMap, row);
                    }
                    this.origPatternRowMapValues = new ArrayList<OriginationDigitPatternRow>(this.origPatternRowMap.values());
                }
            }
            catch (DMException e) {
                log.error((Object)("Error updating " + OriginationDigitPatternSetDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (this.okay()) break block19;
                log.finer((Object)"Update NOT successful.");
                return;
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(OriginationDigitPatternSetDAO.class.getSimpleName() + " update successful"));
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)this.toString());
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("digitmap_origination_pattern_set");
        list.add("digitmap_origination_pattern");
        return list;
    }

    public OriginationDigitPatternSet getOriginationDigitPatternSet(Long origDigitPatternSetId) {
        return this.origPatternSetMap.get(origDigitPatternSetId);
    }

    public OriginationDigitPatternRow getOriginationDigitPatternRow(Long origDigitPatternRowId) {
        return this.origPatternRowMap.get(origDigitPatternRowId);
    }

    public List<OriginationDigitPatternRow> getAllOriginationDigitPatternRows() {
        return this.origPatternRowMapValues;
    }

    public List<OriginationDigitPatternRow> getOriginationDigitPatternRowBySetId(Long origDigitPatternSetId) {
        ArrayList<OriginationDigitPatternRow> matchedPatternRows = new ArrayList<OriginationDigitPatternRow>();
        for (OriginationDigitPatternRow patternRow : this.getAllOriginationDigitPatternRows()) {
            if (!patternRow.getOrigPatternSetId().equals(origDigitPatternSetId)) continue;
            matchedPatternRows.add(patternRow);
        }
        return matchedPatternRows;
    }

    public OriginationPatternSetRouter getOriginationPatternSetRouter(Long domainId) {
        Long domainKey = domainId;
        if (domainKey == null) {
            domainKey = 0L;
        }
        OriginationPatternSetRouter origPatSetRouter = this.origPatSetRouterMap.get(domainKey);
        if (log.isFineEnabled()) {
            log.fine((Object)("OriginationPatternSetRouter for domain " + domainId + (origPatSetRouter == null ? " not found" : " found")));
        }
        return origPatSetRouter;
    }

    @SMConsole(description="Get the Origination Digit Pattern Sets.")
    public String getAllOriginationPatternSets() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("Key: origPatternSetId\n");
        for (Map.Entry<Long, OriginationDigitPatternSet> origSetEntry : this.origPatternSetMap.entrySet()) {
            Long origPatternSetId = origSetEntry.getKey();
            buf.append(origPatternSetId);
            buf.append(": ");
            buf.append(origSetEntry.getValue());
            buf.append("\n");
        }
        return buf.toString();
    }

    @SMConsole(description="Get the global Origination Pattern Rows.")
    public String getAllOriginationPatternRows() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("Key: origPatternRowId\n");
        for (Map.Entry<Long, OriginationDigitPatternRow> origRowEntry : this.origPatternRowMap.entrySet()) {
            Long origPatternRowId = origRowEntry.getKey();
            buf.append(origPatternRowId);
            buf.append(": ");
            buf.append(origRowEntry.getValue());
            buf.append("\n");
        }
        return buf.toString();
    }

    @SMConsole(description="Get the global Origination Pattern Set Router.")
    public String getAllOriginationPatternSetRouter() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("Key: SIPDomainID\n");
        for (Map.Entry<Long, OriginationPatternSetRouter> origEntry : this.origPatSetRouterMap.entrySet()) {
            Long sipDomainId = origEntry.getKey();
            buf.append(sipDomainId);
            buf.append(":\n");
            buf.append(origEntry.getValue().dumpTree());
            buf.append("\n");
        }
        return buf.toString();
    }
}

