/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.UserCommunityAssign;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class UserCommunityDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(UserCommunityDAO.class);
    protected Map<Long, UserCommunityAssign> assignMap = new HashMap<Long, UserCommunityAssign>();
    protected Map<Long, List<UserCommunityAssign>> instanceAssignMap = new HashMap<Long, List<UserCommunityAssign>>();
    protected Map<Long, List<UserCommunityAssign>> communityAssignMap = new HashMap<Long, List<UserCommunityAssign>>();
    protected Map<Long, Integer> instanceCompactIdMap = new HashMap<Long, Integer>();
    protected Map<Integer, Long> compactInstanceIdMap = new HashMap<Integer, Long>();
    protected Map<Long, List<Long>> communityIdMap = new HashMap<Long, List<Long>>();
    public static final String getInstanceCompactIds = "SELECT id, compact_id FROM asminstance";
    public static final String getInstanceCompactId = "SELECT id, compact_id FROM asminstance WHERE id = ?";
    public static final String getUserCommunityAssigns = "SELECT id, asmInstance_id, asmusercommunity_id, priorityorder FROM asmusercommunityassign";
    public static final String getUserCommunityAssign = "SELECT id, asmInstance_id, asmusercommunity_id, priorityorder FROM asmusercommunityassign WHERE id = ?";
    protected static final ResultSetMapper userCommunityAssignMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, UserCommunityAssign> map = new HashMap<Long, UserCommunityAssign>();
            while (rs.next()) {
                UserCommunityAssign assign = new UserCommunityAssign(rs.getLong("asmInstance_id"), rs.getLong("asmusercommunity_id"), rs.getInt("priorityorder"));
                map.put(rs.getLong("id"), assign);
            }
            return map;
        }
    };
    protected static final ResultSetMapper instanceCompactIdMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Integer> map = new HashMap<Long, Integer>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getInt("compact_id"));
            }
            return map;
        }
    };

    public UserCommunityDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap<Long, List<Long>> communityIdMapTMP;
        HashMap<Long, List<UserCommunityAssign>> communityAssignMapTMP;
        HashMap<Long, List<UserCommunityAssign>> instanceAssignMapTMP;
        Map assignMapTMP;
        HashMap<Integer, Long> compactInstanceIdMapTMP;
        Map instanceCompactIdMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + UserCommunityDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            instanceCompactIdMapTMP = (Map)this.dataSource.executeQuery(getInstanceCompactIds, params, instanceCompactIdMapper);
            compactInstanceIdMapTMP = new HashMap<Integer, Long>();
            for (Map.Entry e : instanceCompactIdMapTMP.entrySet()) {
                compactInstanceIdMapTMP.put((Integer)e.getValue(), (Long)e.getKey());
            }
            assignMapTMP = (Map)this.dataSource.executeQuery(getUserCommunityAssigns, params, userCommunityAssignMapper);
            instanceAssignMapTMP = new HashMap<Long, List<UserCommunityAssign>>();
            communityAssignMapTMP = new HashMap<Long, List<UserCommunityAssign>>();
            for (UserCommunityAssign assign : assignMapTMP.values()) {
                UserCommunityAssign a;
                Long asmInstanceId = assign.getAsmInstance_id();
                Long userCommunityId = assign.getAsmusercommunity_id();
                if (!instanceAssignMapTMP.containsKey(asmInstanceId)) {
                    instanceAssignMapTMP.put(asmInstanceId, new ArrayList());
                }
                ((List)instanceAssignMapTMP.get(asmInstanceId)).add(assign);
                if (!communityAssignMapTMP.containsKey(userCommunityId)) {
                    communityAssignMapTMP.put(userCommunityId, new ArrayList());
                }
                int idx = 0;
                List assigns = (List)communityAssignMapTMP.get(userCommunityId);
                Iterator iterator = assigns.iterator();
                while (iterator.hasNext() && (a = (UserCommunityAssign)iterator.next()).getPriorityorder() < assign.getPriorityorder()) {
                    ++idx;
                }
                assigns.add(idx, assign);
            }
            communityIdMapTMP = new HashMap<Long, List<Long>>();
            for (Long userCommId : communityAssignMapTMP.keySet()) {
                long dynUserCommId = this.mapDBUserCommunityIdToDynamic(userCommId, communityAssignMapTMP, instanceCompactIdMapTMP);
                this.addToCommunityIdMap(communityIdMapTMP, dynUserCommId, userCommId);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.assignMap = assignMapTMP;
                this.instanceAssignMap = instanceAssignMapTMP;
                this.communityAssignMap = communityAssignMapTMP;
                this.instanceCompactIdMap = instanceCompactIdMapTMP;
                this.compactInstanceIdMap = compactInstanceIdMapTMP;
                this.communityIdMap = communityIdMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        boolean locked = false;
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(UserCommunityDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        UserCommunityAssign oldAssign = null;
        UserCommunityAssign newAssign = null;
        try {
            this.lock.acquireWriteLock();
            locked = true;
            try {
                if ("asmusercommunityassign".equals(tableName)) {
                    long dynUserCommId;
                    long userCommunityId;
                    oldAssign = this.assignMap.remove(id);
                    if (oldAssign != null) {
                        long instanceId = oldAssign.getAsmInstance_id();
                        userCommunityId = oldAssign.getAsmusercommunity_id();
                        dynUserCommId = this.mapDBUserCommunityIdToDynamic(userCommunityId);
                        this.removeFromCommunityIdMap(this.communityIdMap, dynUserCommId, userCommunityId);
                        List<UserCommunityAssign> assigns = this.instanceAssignMap.get(instanceId);
                        assigns.remove(oldAssign);
                        if (assigns.isEmpty()) {
                            this.instanceAssignMap.remove(instanceId);
                        }
                        assigns = this.communityAssignMap.get(userCommunityId);
                        assigns.remove(oldAssign);
                        if (assigns.isEmpty()) {
                            this.communityAssignMap.remove(userCommunityId);
                        } else if (operation == DAOReplicationEvent.OperationType.DELETE) {
                            dynUserCommId = this.mapDBUserCommunityIdToDynamic(userCommunityId);
                            this.addToCommunityIdMap(this.communityIdMap, dynUserCommId, userCommunityId);
                        }
                    } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                        this.log.warn((Object)("AssignList was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                    }
                    if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                        Object[] params = new Object[]{id};
                        Map map = (Map)this.dataSource.executeQuery(getUserCommunityAssign, params, userCommunityAssignMapper);
                        newAssign = (UserCommunityAssign)map.get(id);
                        if (newAssign == null) {
                            throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                        }
                        if (this.log.isFinerEnabled()) {
                            this.log.finer((Object)("Retrieved new community assignment " + newAssign));
                        }
                        if (operation == DAOReplicationEvent.OperationType.INSERT) {
                            userCommunityId = newAssign.getAsmusercommunity_id();
                            dynUserCommId = this.mapDBUserCommunityIdToDynamic(userCommunityId);
                            this.removeFromCommunityIdMap(this.communityIdMap, dynUserCommId, userCommunityId);
                        }
                        this.assignMap.put(id, newAssign);
                        Long instanceId = newAssign.getAsmInstance_id();
                        Long userCommunityId2 = newAssign.getAsmusercommunity_id();
                        if (!this.instanceAssignMap.containsKey(instanceId)) {
                            this.instanceAssignMap.put(instanceId, new ArrayList());
                        }
                        this.instanceAssignMap.get(instanceId).add(newAssign);
                        if (!this.communityAssignMap.containsKey(userCommunityId2)) {
                            this.communityAssignMap.put(userCommunityId2, new ArrayList());
                        }
                        this.communityAssignMap.get(userCommunityId2).add(newAssign);
                        Collections.sort(this.communityAssignMap.get(userCommunityId2), new UserCommunityAssign.PriorityComparator());
                        dynUserCommId = this.mapDBUserCommunityIdToDynamic(userCommunityId2);
                        this.addToCommunityIdMap(this.communityIdMap, dynUserCommId, userCommunityId2);
                    }
                } else if ("asminstance".equals(tableName)) {
                    Integer compactId = this.instanceCompactIdMap.remove(id);
                    if (compactId != null) {
                        this.compactInstanceIdMap.remove(compactId);
                    }
                    if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                        Object[] params = new Object[]{id};
                        Map map = (Map)this.dataSource.executeQuery(getInstanceCompactId, params, instanceCompactIdMapper);
                        Integer newCompactId = (Integer)map.get(id);
                        if (newCompactId == null) {
                            throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                        }
                        this.instanceCompactIdMap.put(id, newCompactId);
                        this.compactInstanceIdMap.put(newCompactId, id);
                    }
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                this.log.error((Object)("Error updating " + UserCommunityDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                    if (locked) {
                        this.lock.releaseWriteLock();
                        locked = false;
                    }
                    return;
                }
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (oldAssign != null || newAssign != null) {
            this.updateListeners(this.mapDBUserCommunityAssignToInternal(oldAssign), this.mapDBUserCommunityAssignToInternal(newAssign));
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(UserCommunityDAO.class.getSimpleName() + " update successful"));
        }
    }

    private UserCommunityAssign mapDBUserCommunityAssignToInternal(UserCommunityAssign dbAssign) {
        return dbAssign == null ? null : new UserCommunityAssign(dbAssign.getAsmInstance_id(), this.mapDBUserCommunityIdToDynamic(dbAssign.getAsmusercommunity_id()), dbAssign.getPriorityorder());
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmusercommunityassign");
        list.add("asminstance");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"instanceId"}, description="Get the IDs of User Communities that the given instance belongs to.")
    public List<Long> getUserCommunityIds(long instanceId) {
        ArrayList<Long> returnList = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            List<UserCommunityAssign> assigns = this.instanceAssignMap.get(instanceId);
            if (assigns != null) {
                for (UserCommunityAssign assign : assigns) {
                    returnList.add(assign.getAsmusercommunity_id());
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return returnList;
    }

    @SMConsole(description="Get the IDs of all User Communities containing this Session Manager")
    public List<Long> getMyUserCommunityIds() {
        Long instanceId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        if (instanceId != null) {
            return this.getUserCommunityIds(instanceId);
        }
        return new ArrayList<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMyUserCommunityId(Long userCommunityId) {
        if (userCommunityId == null) {
            return false;
        }
        Long myInstanceId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        if (myInstanceId == null) {
            return false;
        }
        long userCommId = userCommunityId;
        if (this.isDynamicUserCommunityId(userCommId)) {
            List<Long> asmInstanceIds = this.toAsmInstanceIds(userCommId);
            for (Long asmId : asmInstanceIds) {
                if (!myInstanceId.equals(asmId)) continue;
                return true;
            }
            return false;
        }
        this.lock.acquireReadLock();
        try {
            List<UserCommunityAssign> assigns = this.communityAssignMap.get(userCommunityId);
            if (assigns != null) {
                for (UserCommunityAssign assign : assigns) {
                    if (!myInstanceId.equals(assign.getAsmInstance_id())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"userCommunityId"}, description="Get the IDs of Session Managers in the given User Community.")
    public List<Long> getUserCommAsmInstanceIds(Long userCommunityId) {
        List<Long> returnList = new ArrayList<Long>();
        if (userCommunityId != null) {
            long userCommId = userCommunityId;
            if (this.isDynamicUserCommunityId(userCommId)) {
                returnList = this.toAsmInstanceIds(userCommId);
            } else {
                this.lock.acquireReadLock();
                try {
                    List<UserCommunityAssign> assigns = this.communityAssignMap.get(userCommunityId);
                    if (assigns != null) {
                        for (UserCommunityAssign assign : assigns) {
                            returnList.add(assign.getAsmInstance_id());
                        }
                    }
                }
                finally {
                    this.lock.releaseReadLock();
                }
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the IDs of Session Managers in all User Communities.")
    public Map<Long, List<Long>> getAllUserCommAsmInstanceIds() {
        HashMap<Long, List<Long>> returnMap = new HashMap<Long, List<Long>>();
        this.lock.acquireReadLock();
        try {
            for (Long userCommunityId : this.communityAssignMap.keySet()) {
                List<Long> asmIdList = this.getUserCommAsmInstanceIds(userCommunityId);
                returnMap.put(userCommunityId, asmIdList);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return returnMap;
    }

    @SMConsole(parameterNames={"userCommunityId"}, description="Get the ASM instances of Session Managers in the given User Community.")
    public List<UserCommunityAssign> getUserCommAsmInstances(Long userCommunityId) {
        ArrayList<UserCommunityAssign> returnList = new ArrayList<UserCommunityAssign>();
        if (userCommunityId != null) {
            int priorityorder = 0;
            for (Long asmInstanceId : this.getUserCommAsmInstanceIds(userCommunityId)) {
                returnList.add(new UserCommunityAssign(asmInstanceId, userCommunityId, priorityorder++));
            }
        }
        return returnList;
    }

    @SMConsole(parameterNames={"asmInstanceIds ..."}, description="Get the ASM user community ID with the given ASM instance IDs.")
    public Long getUserCommunityIdByAsmInstanceIds(Long ... asmInstanceIds) {
        return this.getUserCommunityIdByAsmInstanceIds(Arrays.asList(asmInstanceIds));
    }

    public Long getUserCommunityIdByAsmInstanceIds(List<Long> asmInstanceIds) {
        long userCommunityId = this.toUserCommunityId(asmInstanceIds);
        return asmInstanceIds.size() > 2 ? new Long(userCommunityId) : this.mapDynamicUserCommunityIdToDB(userCommunityId);
    }

    public Long getDynamicUserCommunity(Long userCommunityId) {
        if (userCommunityId == null) {
            return null;
        }
        return this.isDynamicUserCommunityId(userCommunityId) ? userCommunityId.longValue() : this.mapDBUserCommunityIdToDynamic(userCommunityId);
    }

    public long mapDBUserCommunityIdToDynamic(long dbUserCommId) {
        return this.mapDBUserCommunityIdToDynamic(dbUserCommId, this.communityAssignMap, this.instanceCompactIdMap);
    }

    private void addToCommunityIdMap(Map<Long, List<Long>> communityIdMap, long dynUserCommId, long dbUserCommId) {
        List<Long> ucIdList = communityIdMap.get(dynUserCommId);
        if (ucIdList == null) {
            ucIdList = new ArrayList<Long>();
            communityIdMap.put(dynUserCommId, ucIdList);
        }
        if (!ucIdList.contains(dbUserCommId)) {
            ucIdList.add(dbUserCommId);
            Collections.sort(ucIdList);
        }
    }

    private void removeFromCommunityIdMap(Map<Long, List<Long>> communityIdMap, long dynUserCommId, long dbUserCommId) {
        List<Long> ucIdList = communityIdMap.get(dynUserCommId);
        if (ucIdList != null) {
            ucIdList.remove(dbUserCommId);
            if (ucIdList.isEmpty()) {
                communityIdMap.remove(dynUserCommId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long mapDBUserCommunityIdToDynamic(long dbUserCommId, Map<Long, List<UserCommunityAssign>> communityAssignMap, Map<Long, Integer> instanceCompactIdMap) {
        this.lock.acquireReadLock();
        try {
            ArrayList<Long> asmIds = new ArrayList<Long>();
            List<UserCommunityAssign> assigns = communityAssignMap.get(dbUserCommId);
            if (assigns != null) {
                int prioOrder = 0;
                for (UserCommunityAssign assign : assigns) {
                    while (prioOrder++ < assign.getPriorityorder()) {
                        asmIds.add(null);
                    }
                    asmIds.add(assign.getAsmInstance_id());
                }
            }
            long l = this.toUserCommunityId(asmIds, instanceCompactIdMap);
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long mapDynamicUserCommunityIdToDB(long userCommunityId) {
        this.lock.acquireReadLock();
        try {
            List<Long> ucIdList = this.communityIdMap.get(userCommunityId);
            Long l = ucIdList != null ? ucIdList.get(0) : null;
            return l;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private boolean isDynamicUserCommunityId(long userCommunityId) {
        return userCommunityId < 0L;
    }

    private int getAsmCompactId(long asmInstanceId) {
        return this.getAsmCompactId(asmInstanceId, this.instanceCompactIdMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAsmCompactId(Long asmInstanceId, Map<Long, Integer> instanceCompactIdMap) {
        this.lock.acquireReadLock();
        try {
            Integer compactId = instanceCompactIdMap.get(asmInstanceId);
            int n = compactId == null ? 0 : compactId;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private List<Long> toAsmInstanceIds(long userCommId) {
        return this.toAsmInstanceIds(userCommId, this.compactInstanceIdMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> toAsmInstanceIds(long userCommId, Map<Integer, Long> compactInstanceIdMap) {
        ArrayList<Long> retList = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            userCommId = -userCommId;
            for (int i = 0; i < AsmConstants.USER_COMMUNITY_ID.MAX_USERCOMMUNITY_ASM; ++i) {
                Long asmInstanceId;
                int compactId = (int)(userCommId & AsmConstants.USER_COMMUNITY_ID.COMPACT_ID_MASK);
                if (compactId != 0 && (asmInstanceId = compactInstanceIdMap.get(compactId)) != null) {
                    retList.add(asmInstanceId);
                }
                userCommId >>= AsmConstants.USER_COMMUNITY_ID.COMPACT_ID_BITS;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retList;
    }

    private long toUserCommunityId(List<Long> asmInstanceIds) {
        return this.toUserCommunityId(asmInstanceIds, this.instanceCompactIdMap);
    }

    private long toUserCommunityId(List<Long> asmInstanceIds, Map<Long, Integer> instanceCompactIdMap) {
        long userCommId = 0L;
        ListIterator<Long> iter = asmInstanceIds.listIterator(asmInstanceIds.size());
        while (iter.hasPrevious()) {
            userCommId <<= AsmConstants.USER_COMMUNITY_ID.COMPACT_ID_BITS;
            userCommId |= (long)this.getAsmCompactId(iter.previous(), instanceCompactIdMap);
        }
        return -userCommId;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (!(oldObject instanceof AsmInstance) && !(newObject instanceof AsmInstance)) {
            this.log.warn((Object)("Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.assignMap;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

