/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.helpers.FlexCache;
import com.avaya.asm.datamgr.loadrulekeys.CacheSize;
import com.avaya.asm.datamgr.loadrulekeys.UserFields;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.User;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacheSize.class, UserFields.class})
public class UserDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(UserDAO.class);
    protected FlexCache<Long, User> userMap = new FlexCache();
    protected FlexCache<Long, User> contactListIdToUserMap = new FlexCache();
    protected FlexCache<String, User> loginNameToUserMap = new FlexCache();
    public static final String getUsersBaseQuery = "SELECT ### FROM csuser WHERE isdeleted = false";
    public static final String getLocalUsersTailEnd = " FROM csuser, cscommprofileset, cscommprofile, dyn_asmcommprofile WHERE csuser.id=cscommprofileset.csuserid AND cscommprofileset.id=cscommprofile.cscommprofilesetid AND cscommprofile.id=dyn_asmcommprofile.id AND csuser.isdeleted=false AND dyn_asmcommprofile.is_local=true";
    public static String getUsersQuery = "SELECT ### FROM csuser WHERE isdeleted = false".replace("###", "id");
    public static String getLocalUsersQuery = "SELECT csuser.id FROM csuser, cscommprofileset, cscommprofile, dyn_asmcommprofile WHERE csuser.id=cscommprofileset.csuserid AND cscommprofileset.id=cscommprofile.cscommprofilesetid AND cscommprofile.id=dyn_asmcommprofile.id AND csuser.isdeleted=false AND dyn_asmcommprofile.is_local=true";
    public static String getUserQuery = getUsersQuery + " AND id = ?";
    public static String getUserFromContactListIdQuery = getUsersQuery + " AND defaultcontactlistid = ?";
    public static String getUserFromLoginNameQuery = getUsersQuery + " AND lower(loginname) = ?";
    private int capacity = 1;
    protected static String userFields = "csuser.id";
    protected static final ResultSetMapper usersMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, User> map = new HashMap<Long, User>();
            while (rs.next()) {
                long id = rs.getLong("id");
                String loginName = userFields.contains("loginname") ? rs.getString("loginname") : null;
                String password = userFields.contains("userpassword") ? rs.getString("userpassword") : null;
                long defaultcontactlistid = userFields.contains("defaultcontactlistid") ? rs.getLong("defaultcontactlistid") : 0L;
                long defaultcommprofilesetid = userFields.contains("defaultcommprofilesetid") ? rs.getLong("defaultcommprofilesetid") : 0L;
                String displayname = userFields.contains("displayname,") || userFields.endsWith("displayname") ? rs.getString("displayname") : null;
                String displayNameAscii = userFields.contains("displaynameascii") ? rs.getString("displaynameascii") : null;
                String givenname = userFields.contains("givenname") ? rs.getString("givenname") : null;
                String surname = userFields.contains("surname") ? rs.getString("surname") : null;
                String givennameAscii = userFields.contains("givennameascii") ? rs.getString("givennameascii") : null;
                String surnameAscii = userFields.contains("surnameascii") ? rs.getString("surnameascii") : null;
                String preferredLanguage = userFields.contains("preferredlanguage") ? rs.getString("preferredlanguage") : null;
                User user = new User(id, loginName, password, displayname, displayNameAscii, givenname, givennameAscii, surname, surnameAscii, preferredLanguage, defaultcontactlistid, defaultcommprofilesetid);
                map.put(id, user);
            }
            return map;
        }
    };
    protected static final ResultSetMapper usersMapperByLoginName = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<String, User> map = new HashMap<String, User>();
            while (rs.next()) {
                long id = rs.getLong("id");
                String loginName = userFields.contains("loginname") ? rs.getString("loginname") : null;
                String password = userFields.contains("userpassword") ? rs.getString("userpassword") : null;
                long defaultcontactlistid = userFields.contains("defaultcontactlistid") ? rs.getLong("defaultcontactlistid") : 0L;
                long defaultcommprofilesetid = userFields.contains("defaultcommprofilesetid") ? rs.getLong("defaultcommprofilesetid") : 0L;
                String displayname = userFields.contains("displayname,") || userFields.endsWith("displayname") ? rs.getString("displayname") : null;
                String displayNameAscii = userFields.contains("displaynameascii") ? rs.getString("displaynameascii") : null;
                String givenname = userFields.contains("givenname") ? rs.getString("givenname") : null;
                String surname = userFields.contains("surname") ? rs.getString("surname") : null;
                String givennameAscii = userFields.contains("givennameascii") ? rs.getString("givennameascii") : null;
                String surnameAscii = userFields.contains("surnameascii") ? rs.getString("surnameascii") : null;
                String preferredLanguage = userFields.contains("preferredlanguage") ? rs.getString("preferredlanguage") : null;
                User user = new User(id, loginName, password, displayname, displayNameAscii, givenname, givennameAscii, surname, surnameAscii, preferredLanguage, defaultcontactlistid, defaultcommprofilesetid);
                if (loginName == null) continue;
                map.put(loginName.toLowerCase(), user);
            }
            return map;
        }
    };

    public UserDAO() {
        super(true);
    }

    protected int getCapacity() {
        return this.capacity;
    }

    protected void setCapacity(int capacity) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.capacity = capacity;
    }

    protected boolean setUserFields(List<String> fields) {
        if (!fields.contains("id")) {
            fields.add("id");
        }
        Collections.sort(fields);
        String query = "";
        for (String field : fields) {
            if (query.isEmpty()) {
                query = "csuser." + field;
                continue;
            }
            query = query + ", csuser." + field;
        }
        if (query.equals(userFields)) {
            return false;
        }
        userFields = query;
        getLocalUsersQuery = "SELECT " + userFields + getLocalUsersTailEnd;
        getUsersQuery = getUsersBaseQuery.replace("###", userFields);
        getUserQuery = getUsersQuery + " AND id = ?";
        return true;
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinitNeeded = false;
        int bestCacheValue = 1;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cachesize".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    int cap = Integer.parseInt(value);
                    if (cap <= 0) {
                        bestCacheValue = -1;
                        continue block0;
                    }
                    if (bestCacheValue == -1 || cap <= bestCacheValue) continue;
                    bestCacheValue = cap;
                }
                continue;
            }
            if ("userfields".equals(((String)entry.getKey()).toLowerCase())) {
                ArrayList<String> fields = new ArrayList<String>();
                for (String value : (Set)entry.getValue()) {
                    String[] types;
                    for (String type : types = value.split(",")) {
                        String t = type.toLowerCase().trim();
                        if (fields.contains(t)) continue;
                        fields.add(t);
                    }
                }
                reinitNeeded |= this.setUserFields(fields);
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.getCapacity()) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting FlexCache capacity to " + bestCacheValue));
            }
            this.capacity = bestCacheValue;
            reinitNeeded = true;
        }
        if (reinitNeeded && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        FlexCache userMapTMP = new FlexCache();
        FlexCache<Object, Object> contactListIdToUserMapTMP = new FlexCache();
        FlexCache<Object, Object> loginNameToUserMapTMP = new FlexCache();
        try {
            Object[] params = new Object[]{};
            HashMap resultMap = (HashMap)this.dataSource.executeQuery(this.getCapacity() >= 0 ? getLocalUsersQuery : getUsersQuery, params, usersMapper);
            userMapTMP = new FlexCache(this.getCapacity(), resultMap, true);
            contactListIdToUserMapTMP = new FlexCache<Long, User>(this.getCapacity(), this.getContactListIdToUserMapFromResultMap(resultMap), true);
            loginNameToUserMapTMP = new FlexCache<String, User>(this.getCapacity(), this.getLoginNameToUserMapFromResultMap(resultMap), true);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.userMap = userMapTMP;
                this.contactListIdToUserMap = contactListIdToUserMapTMP;
                this.loginNameToUserMap = loginNameToUserMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    protected String logTag(DAOReplicationEvent.OperationType operation, String tableName, long id) {
        if (AsmCommon.jUnitEnvironment) {
            return "";
        }
        return this.getClass().getSimpleName() + ".updateDAO(" + (Object)((Object)operation) + " " + tableName + " " + id + "): ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean lockHeld = false;
        User oldUser = null;
        User newUser = null;
        try {
            String loginName;
            if (this.getCapacity() < 0 && operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                Map resultMap = (Map)this.dataSource.executeQuery(getUserQuery, params, usersMapper);
                newUser = (User)resultMap.get(id);
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldUser = this.userMap.remove(id);
            long dfltContactListId = 0L;
            if (oldUser != null) {
                dfltContactListId = oldUser.getDefaultContactListId();
                this.contactListIdToUserMap.remove(dfltContactListId);
                loginName = oldUser.getLoginName();
                if (loginName != null) {
                    this.loginNameToUserMap.remove(loginName.toLowerCase());
                }
            }
            if (newUser != null) {
                this.userMap.put(id, newUser);
                dfltContactListId = newUser.getDefaultContactListId();
                this.contactListIdToUserMap.put(dfltContactListId, newUser);
                loginName = newUser.getLoginName();
                if (loginName != null) {
                    this.loginNameToUserMap.put(loginName.toLowerCase(), newUser);
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            oldUser = null;
            newUser = null;
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (oldUser == null ? newUser != null : !oldUser.equals(newUser)) {
            this.updateListeners(oldUser, newUser);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        if (this.getCapacity() >= 0) {
            list.add("dyn_asmcommprofile");
        }
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return this.userMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(Long id) {
        String fcn_name = "getUser";
        if (id == null) {
            return null;
        }
        User csuser = null;
        try {
            this.lock.acquireReadLock();
            csuser = this.userMap.get(id);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (csuser != null) {
            return csuser;
        }
        if (this.getCapacity() < 0) {
            this.log.warn((Object)("getUser: We couldn't find the user with csuserId: " + id + " in the cache, and should have."));
        }
        try {
            Object[] params = new Object[]{id};
            Map resultMap = (Map)this.dataSource.executeQuery(getUserQuery, params, usersMapper);
            if (resultMap != null) {
                csuser = (User)resultMap.get(id);
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("getUser: Retrieved a CsUser entry and will add it into the cache: " + csuser));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("getUser: Error adding user into the cache: " + this.getClass().getSimpleName() + " object"), (Throwable)e);
        }
        if (csuser != null) {
            try {
                this.lock.acquireWriteLock();
                this.userMap.put(id, csuser);
                this.contactListIdToUserMap.put(csuser.getDefaultContactListId(), csuser);
                String loginName = csuser.getLoginName();
                if (loginName != null) {
                    this.loginNameToUserMap.put(loginName.toLowerCase(), csuser);
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return csuser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserForContactListId(Long id) {
        if (id == null) {
            return null;
        }
        User csuser = null;
        try {
            this.lock.acquireReadLock();
            csuser = this.contactListIdToUserMap.get(id);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (csuser != null) {
            return csuser;
        }
        if (this.getCapacity() < 0) {
            return null;
        }
        try {
            Object[] params = new Object[]{id};
            Map resultMap = (Map)this.dataSource.executeQuery(getUserFromContactListIdQuery, params, usersMapper);
            if (resultMap != null) {
                csuser = (User)resultMap.get(id);
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Retrieved new CsUser into cache: " + csuser));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading user into cache: " + this.getClass().getSimpleName() + " object"), (Throwable)e);
        }
        if (csuser != null) {
            try {
                this.lock.acquireWriteLock();
                this.userMap.put(id, csuser);
                this.contactListIdToUserMap.put(csuser.getDefaultContactListId(), csuser);
                String loginName = csuser.getLoginName();
                if (loginName != null) {
                    this.loginNameToUserMap.put(loginName.toLowerCase(), csuser);
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return csuser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserForLoginName(String loginName) {
        if (loginName == null || loginName.isEmpty()) {
            return null;
        }
        User csuser = null;
        try {
            this.lock.acquireReadLock();
            csuser = this.loginNameToUserMap.get(loginName.toLowerCase());
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (csuser != null) {
            return csuser;
        }
        if (this.getCapacity() < 0) {
            return null;
        }
        try {
            Object[] params = new Object[]{loginName.toLowerCase()};
            Map resultMap = (Map)this.dataSource.executeQuery(getUserFromLoginNameQuery, params, usersMapperByLoginName);
            if (resultMap != null) {
                csuser = (User)resultMap.get(loginName);
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Retrieved new CsUser into cache: " + csuser));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading user into cache: " + this.getClass().getSimpleName() + " object"), (Throwable)e);
        }
        if (csuser != null) {
            try {
                this.lock.acquireWriteLock();
                this.userMap.put(csuser.getId(), csuser);
                this.contactListIdToUserMap.put(csuser.getDefaultContactListId(), csuser);
                String userLoginName = csuser.getLoginName();
                if (userLoginName != null) {
                    this.loginNameToUserMap.put(userLoginName.toLowerCase(), csuser);
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return csuser;
    }

    @SMConsole(description="Show contents of CsUser DAO - userMap")
    public Map<Long, User> getUserDAOContents() {
        try {
            this.lock.acquireReadLock();
            Map<Long, User> map = this.userMap.getCopyOfInternalMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Show contents of CsUser DAO - contactListIdToUserMap")
    public Map<Long, User> getContactListIdToUserMapContents() {
        try {
            this.lock.acquireReadLock();
            Map<Long, User> map = this.contactListIdToUserMap.getCopyOfInternalMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Show contents of CsUser DAO - loginNameToUserMap")
    public Map<String, User> getLoginNameToUserMapContents() {
        try {
            this.lock.acquireReadLock();
            Map<String, User> map = this.loginNameToUserMap.getCopyOfInternalMap();
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public HashMap<Long, User> getContactListIdToUserMapFromResultMap(HashMap<Long, User> resultMap) {
        HashMap<Long, User> contactListIdToUserMap = new HashMap<Long, User>();
        for (User user : resultMap.values()) {
            contactListIdToUserMap.put(user.getDefaultContactListId(), user);
        }
        return contactListIdToUserMap;
    }

    public HashMap<String, User> getLoginNameToUserMapFromResultMap(HashMap<Long, User> resultMap) {
        HashMap<String, User> loginNameToUserMap = new HashMap<String, User>();
        for (User user : resultMap.values()) {
            if (user == null || user.getLoginName() == null) continue;
            loginNameToUserMap.put(user.getLoginName().toLowerCase(), user);
        }
        return loginNameToUserMap;
    }

    public Map<Long, Long> getUserIdToContactListIdMap() {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>();
        for (User user : this.userMap.values()) {
            resultMap.put(user.getId(), user.getDefaultContactListId());
        }
        return resultMap;
    }

    public Set<Long> getAllContactListIds() {
        if (this.contactListIdToUserMap != null) {
            return this.contactListIdToUserMap.keySet();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"userId"}, description="Delete entries from the CsUser DAO maps.")
    public void deleteEntrysFromUserDAO(Long userId) {
        try {
            User user;
            this.lock.acquireWriteLock();
            if (userId != null && (user = this.userMap.get(userId)) != null) {
                Long defaultContactListId = user.getDefaultContactListId();
                String loginName = user.getLoginName();
                this.userMap.remove(userId);
                if (defaultContactListId != null) {
                    this.contactListIdToUserMap.remove(defaultContactListId);
                }
                if (loginName != null) {
                    this.loginNameToUserMap.remove(loginName.toLowerCase());
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }
}

