/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.datamgr.BSMNoEntityLinksAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.BSMNoEntityLinksAlarmException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.EntityLinkTableDAO;
import com.avaya.asm.datamgr.dao.branch.BranchFeatureServerDAO;
import com.avaya.asm.datamgr.dao.branch.BranchSIPEntityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.EntityLink;
import com.avaya.asm.datamgr.objectapi.EntityLinkTable;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.common.logging.client.Logger;
import java.util.List;

public class BranchEntityLinkTableDAO
extends EntityLinkTableDAO {
    private final Logger log = AsmLogger.getLogger(BranchEntityLinkTableDAO.class);
    protected static final String getEntityLinksByEntity = "SELECT el.id, el.entity1_id, el.entity2_id, el.listenportentity1, el.listenportentity2, el.trusted, el.ipaddr_family, el.transportprotocol, el.service_state FROM entitylink el JOIN sipentity se ON se.id = el.entity2_id WHERE se.entitytype <> 'ENDPTCONC' AND (entity1_id=? OR entity2_id=?)";

    @Override
    public void init() {
        Long mySIPEntityId;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + BranchEntityLinkTableDAO.class.getSimpleName()));
        }
        if ((mySIPEntityId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMySIPEntityId()) == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)"Don't know my SIP entity ID");
            }
            this.setStatus(DataMgr.Status.OKAY);
            return;
        }
        Long featureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId();
        List<Long> otherFeatureServerIds = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getOtherFeatureServerIds();
        Object[] params = new Object[]{mySIPEntityId, mySIPEntityId};
        this.init(getEntityLinksByEntity, params, otherFeatureServerIds);
        if (featureServerId != null) {
            EntityLinkTable elt = this.getEntityLinkTable(featureServerId);
            if (elt.getEntityLinks(mySIPEntityId).isEmpty()) {
                BSMNoEntityLinksAlarmException e = new BSMNoEntityLinksAlarmException("No administered entity links could be found from the BSM to core CM");
                GenericAlarmHandler.handleFailureEvent(this, e);
            }
            List<EntityLink> entityLinks = elt.getEntityLinks(mySIPEntityId);
            EntityLinkTable eltBSM = this.getEntityLinkTable(mySIPEntityId);
            SIPEntity.IPAddrFamilyType lspIPAddrFamilyType = ((BranchSIPEntityDAO)this.getDataMgr(BranchSIPEntityDAO.class)).getLSPAddressFamily();
            EntityLink.IPAddrFamily lspIPAddrFamily = lspIPAddrFamilyType == SIPEntity.IPAddrFamilyType.IPv4 ? EntityLink.IPAddrFamily.IPv4 : EntityLink.IPAddrFamily.IPv6;
            for (EntityLink link : entityLinks) {
                if (link.getIPAddrFamily() == lspIPAddrFamily) continue;
                if (this.log.isFineEnabled()) {
                    this.log.fine((Object)("Filtering entity link " + link + " based on LSP IP address family: " + (Object)((Object)lspIPAddrFamily)));
                }
                elt.removeEntityLink(link);
                eltBSM.removeEntityLink(link);
            }
        }
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)"updateDAO: reinitialize");
        }
        this.reinit();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("objectChanged(" + oldObject + ", " + newObject + ")"));
        }
        this.reinit();
    }

    @Override
    protected boolean isCorrected(GenericAlarm alarm) {
        if (alarm instanceof BSMNoEntityLinksAlarm) {
            Long featureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId();
            if (featureServerId == null) {
                return false;
            }
            if (this.entityLinkTableMap.isEmpty()) {
                return false;
            }
            if (!this.entityLinkTableMap.containsKey(featureServerId)) {
                return false;
            }
            this.log.error((Object)("cleared BSMNoEntityLinksAlarm, found entity links to feature server: " + featureServerId));
            return true;
        }
        return super.isCorrected(alarm);
    }
}

