/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.PPMAsmCommProfileDAO;
import com.avaya.asm.datamgr.objectapi.AsmCommProfile;
import com.avaya.common.logging.client.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class BranchPPMAsmCommProfileDAO
extends PPMAsmCommProfileDAO {
    private final Logger log = AsmLogger.getLogger(BranchPPMAsmCommProfileDAO.class);
    protected String asmCommProfileBySetId = "SELECT cs.id, asm.forkingpolicy, asm.simultaneous_devices, asm.origappset_id, asm.termappset_id, asm.usercommunity_id, asm.subscriptionset_id, asm.homelocation_id, asm.survivability_server_id, asm.asm_conf_factory_set_id, asm.block_reg_if_max, asm.call_logging, cs.cscommprofilesetid, cs.preferredhandleid, asm.emer_origappset_id, asm.emer_termappset_id, asm.asm_assign_policy_id, asm.asm_region_community_id FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id ";
    protected String CONDITION_SETID = " where cs.cscommprofilesetid=?";
    protected String CONDITION_CSID = " where cs.id=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsmCommProfile getAsmCommProfileBySetId(Long setId) {
        String fcn_name = "getAsmCommProfileBySetId";
        AsmCommProfile asmCommprofile = super.getAsmCommProfileBySetId(setId);
        if (asmCommprofile != null) {
            return asmCommprofile;
        }
        try {
            AsmCommProfile asm;
            Object object;
            this.lock.acquireReadLock();
            Map profileMap = null;
            try {
                profileMap = (ConcurrentMap)this.dataSource.executeQuery(this.asmCommProfileBySetId + this.CONDITION_SETID, new Object[]{setId}, this.getMapper());
            }
            catch (DMException e) {
                this.log.error((Object)(fcn_name + " Exception while executing query =" + this.asmCommProfileBySetId), (Throwable)e);
            }
            if (profileMap != null && (object = profileMap.values().iterator()).hasNext() && (asm = (AsmCommProfile)object.next()).getCsCommProfileSetId().equals(setId)) {
                asmCommprofile = asm;
            }
            object = asmCommprofile;
            return object;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsmCommProfile getAsmCommProfile(Long id) {
        AsmCommProfile asmCommprofile;
        String fcn_name = "getAsmCommProfile";
        boolean is_finer = this.log.isFinerEnabled();
        if (is_finer) {
            this.log.finer((Object)(fcn_name + " enter with id=" + id));
        }
        if ((asmCommprofile = super.getAsmCommProfile(id)) != null) {
            this.log.finer((Object)(fcn_name + " Leaving without On Demand query and with asmCommprofile=" + asmCommprofile));
            return asmCommprofile;
        }
        try {
            this.lock.acquireReadLock();
            Map profileMap = null;
            try {
                profileMap = (ConcurrentMap)this.dataSource.executeQuery(this.asmCommProfileBySetId + this.CONDITION_CSID, new Object[]{id}, this.getMapper());
            }
            catch (DMException e) {
                this.log.error((Object)(fcn_name + " Exception while executing query =" + this.asmCommProfileBySetId));
            }
            if (profileMap != null) {
                for (AsmCommProfile asm : profileMap.values()) {
                    if (asm.getId() != id.longValue()) continue;
                    asmCommprofile = asm;
                    break;
                }
            }
            if (is_finer) {
                this.log.finer((Object)(fcn_name + " Leaving with asmCommProfile=" + asmCommprofile));
            }
            AsmCommProfile asmCommProfile = asmCommprofile;
            return asmCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

