/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraSystemPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;

public class CassandraSystemPreparedStatements
extends PreparedStatements<CassandraSystemPreparedStatementType> {
    private final Logger log = AsmLogger.getLogger(this.getClass());
    static final String GET_ALL_COLUMNFAMILIES_SYSTEM = "SELECT keyspace_name,columnfamily_name,cf_id FROM system.schema_columnfamilies;";
    static final String GET_ALL_COLUMNFAMILIES_SYSTEM_SCHEMA = "SELECT keyspace_name,table_name,id FROM system_schema.tables;";
    protected volatile String currentGetAllColumnFamiliesQuery = null;
    static final String RELEASE_VERSION_QUERY = "SELECT release_version FROM system.local;";
    static final String GET_LOCAL_NODE_DATA = "SELECT listen_address, data_center, host_id, rack, release_version, schema_version FROM system.local";
    static final String GET_ALL_REMOTE_NODE_DATA = "SELECT peer, data_center, host_id, rack, release_version, schema_version FROM system.peers";

    public CassandraSystemPreparedStatements(SessionDAO dao) {
        super(CassandraSystemPreparedStatementType.class, dao);
    }

    @Override
    protected PreparedStatement prepareStatement(CassandraSystemPreparedStatementType queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        String fcn_name = "prepareStatement";
        String query = null;
        switch (queryType) {
            case GET_ALL_COLUMNFAMILIES: {
                query = this.determineGetAllColumnFamiliesQuery();
                break;
            }
            case GET_LOCAL_CASSANDRA_NODE_DATA: {
                query = GET_LOCAL_NODE_DATA;
                break;
            }
            case GET_ALL_REMOTE_CASSANDRA_NODE_DATA: {
                query = GET_ALL_REMOTE_NODE_DATA;
                break;
            }
            default: {
                String msg = "prepareStatement: Unimplemented query, queryType=" + (Object)((Object)queryType);
                this.log.error((Object)msg);
                throw new DMException(msg);
            }
        }
        return this.prepareQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineGetAllColumnFamiliesQuery() {
        String fcn_name = "determineGetAllColumnFamiliesQuery";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("determineGetAllColumnFamiliesQuery: enter, currentGetAllColumnFamiliesQuery=" + this.currentGetAllColumnFamiliesQuery));
        }
        String query = null;
        CassandraSystemPreparedStatements cassandraSystemPreparedStatements = this;
        synchronized (cassandraSystemPreparedStatements) {
            if (this.currentGetAllColumnFamiliesQuery == null) {
                KeyspaceMetaData ksMD = this.dao.getKeyspace("system_schema");
                String string = query = ksMD != null ? GET_ALL_COLUMNFAMILIES_SYSTEM_SCHEMA : GET_ALL_COLUMNFAMILIES_SYSTEM;
                if (isFinest) {
                    this.log.finest((Object)("determineGetAllColumnFamiliesQuery: ksMD for system_schema=" + ksMD + ", query=" + query));
                }
            } else {
                block24: {
                    try {
                        int idx;
                        ResultSet rs = this.dao.executeQuery(RELEASE_VERSION_QUERY);
                        if (rs.isExhausted()) break block24;
                        Row row = rs.one();
                        String rlsVersion = row.getString(0);
                        if (isFinest) {
                            this.log.finest((Object)("determineGetAllColumnFamiliesQuery: Read release_version from system.local, rlsVersion=" + rlsVersion));
                        }
                        if ((idx = rlsVersion.indexOf(46)) == -1) break block24;
                        String majorStr = rlsVersion.substring(0, idx);
                        try {
                            int major = Integer.parseInt(majorStr);
                            String string = query = major >= 3 ? GET_ALL_COLUMNFAMILIES_SYSTEM_SCHEMA : GET_ALL_COLUMNFAMILIES_SYSTEM;
                            if (isFinest) {
                                this.log.finest((Object)("determineGetAllColumnFamiliesQuery: major=" + major + ", query=" + query));
                            }
                        }
                        catch (NumberFormatException e) {
                            this.log.error((Object)("determineGetAllColumnFamiliesQuery: Received " + e.getClass().getSimpleName() + " converting '" + majorStr + "' to an int, rlsVersion=" + rlsVersion), (Throwable)e);
                        }
                    }
                    catch (DMException e) {
                        this.log.error((Object)("determineGetAllColumnFamiliesQuery: Received " + e.getClass().getSimpleName() + " executing " + RELEASE_VERSION_QUERY), (Throwable)e);
                    }
                }
                if (query == null) {
                    if (isFinest) {
                        this.log.finest((Object)("determineGetAllColumnFamiliesQuery: query is still null, currentGetAllColumnFamiliesQuery=" + this.currentGetAllColumnFamiliesQuery));
                    }
                    switch (this.currentGetAllColumnFamiliesQuery) {
                        case "SELECT keyspace_name,table_name,id FROM system_schema.tables;": {
                            query = GET_ALL_COLUMNFAMILIES_SYSTEM;
                            break;
                        }
                        case "SELECT keyspace_name,columnfamily_name,cf_id FROM system.schema_columnfamilies;": {
                            query = GET_ALL_COLUMNFAMILIES_SYSTEM_SCHEMA;
                        }
                    }
                }
            }
            this.currentGetAllColumnFamiliesQuery = query;
        }
        if (isFiner) {
            this.log.finer((Object)("determineGetAllColumnFamiliesQuery: leave, query=" + query));
        }
        return query;
    }
}

