/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.DeviceDataPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.datastax.driver.core.PreparedStatement;

public class DeviceDataPreparedStatements
extends PreparedStatements<DeviceDataPreparedStatementType> {
    public static final String ACP_ID = "acpid";
    private static final String SET = " SET ";
    public static final String DEVICE_CF = "__KEYSPACE__.device";
    private static final String ALL_DEVICE_DATA_FIELDS = "acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime";
    private static final String ALL_DEVICE_DATA_FIELDS_WITH_FAMILIES = "acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime, families";
    private static final String ALL_DEVICE_DATA_FIELDS_WITH_IS_GLOBAL_MIGRATED = "acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime, is_global_migrated";
    public static final String SMEM_DEVICE_DATA_FIELDS = "acpid, devicehandle, dataname, datavalue, updatedatetime";
    private static final String UPDATE_DEVICE_DATA_FIELDS = "acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, updatedatetime";
    private static final String GLOBAL_UPDATE_DEVICE_DATA_FIELDS = "acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, updatedatetime,families";
    private static final String DEVICE_DATA_NO_VALUE_FIELDS = "acpid, datacategory, devicehandle, dataname, ownercsuserid, createddatetime, updatedatetime";
    private static final String INSERT_DEVICE_QRY = "INSERT INTO __KEYSPACE__.device";
    private static final String DELETE_DEVICE_QRY = "DELETE FROM __KEYSPACE__.device";
    public static final String GET_DEVICE_QRY_FOR_SMEM_WITH_DATACATEGORY_AND_LIMIT = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE datacategory=? LIMIT ? ALLOW FILTERING";
    public static final String GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_AND_DATACATEGORY_AND_LIMIT = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE TOKEN(acpid) > TOKEN(?) AND datacategory=? LIMIT ? ALLOW FILTERING";
    public static final String GET_DEVICE_QRY_FOR_SMEM_FOR_ACPID_DATACATEGORY_AND_HANDLE_RANGE = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE acpid = ? AND datacategory = ? AND deviceHandle >= ?";
    public static final String GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_START_AND_END_TOKEN_AND_DATACATEGORY_AND_LIMIT = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE TOKEN(acpid) >= ? AND TOKEN(acpid) < ? AND datacategory=? LIMIT ? ALLOW FILTERING";
    public static final String GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_NEXT_ACPID_AND_END_TOKEN_AND_DATACATEGORY_AND_LIMIT = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE TOKEN(acpid) > TOKEN(?) AND TOKEN(acpid) < ? AND datacategory=? LIMIT ? ALLOW FILTERING";
    public static final String GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_START_TOKEN_ONLY_AND_DATACATEGORY_AND_LIMIT = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE TOKEN(acpid) >= ? AND datacategory=? LIMIT ? ALLOW FILTERING";
    public static final String GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_END_TOKEN_ONLY_AND_DATACATEGORY_AND_LIMIT = "SELECT acpid, devicehandle, dataname, datavalue, updatedatetime FROM __KEYSPACE__.device WHERE TOKEN(acpid) < ? AND datacategory=? LIMIT ? ALLOW FILTERING";
    public static final String GET_DEVICE_QRY_FOR_SMGR_FOR_ACP_DATACATEGORY_AND_HANDLE_RANGE = "SELECT acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime FROM __KEYSPACE__.device WHERE acpid = ? AND datacategory = ? AND deviceHandle >= ? AND deviceHandle < ?";
    public static final String GET_DEVICE_QRY = "SELECT acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime FROM __KEYSPACE__.device";
    public static final String GET_DEVICE_QRY_WITH_FAMILIES = "SELECT acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime, families FROM __KEYSPACE__.device";
    public static final String GET_DEVICE_QRY_NO_VALUES = "SELECT acpid, datacategory, devicehandle, dataname, ownercsuserid, createddatetime, updatedatetime FROM __KEYSPACE__.device";
    private static final String UPDATE_DEVICE_QRY = "UPDATE __KEYSPACE__.device";
    private static final String ONE_WHERE_CLAUSE_FIELD = " WHERE acpid=?";
    private static final String TWO_WHERE_CLAUSE_FIELDS = " WHERE acpid=? AND datacategory=?";
    private static final String THREE_WHERE_CLAUSE_FIELDS = " WHERE acpid=? AND datacategory=? AND devicehandle=?";
    private static final String FOUR_WHERE_CLAUSE_FIELDS = " WHERE acpid=? AND datacategory=? AND devicehandle=? AND dataname=?";
    private static final String TWO_WHERE_CLAUSE_WITH_ISGLOBALMIGRATED = " WHERE acpid=? and is_global_migrated=? ALLOW FILTERING";
    private static final String GET_DISTINCT_ACP_IDS_FROM_KEYSPACE = "SELECT DISTINCT acpid FROM __KEYSPACE__.device";

    public DeviceDataPreparedStatements(SessionDAO dao) {
        super(DeviceDataPreparedStatementType.class, dao);
    }

    @Override
    public PreparedStatement prepareStatement(DeviceDataPreparedStatementType queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        StringBuilder query = new StringBuilder();
        switch (queryType) {
            case ADD_DEVICE: {
                query.append(INSERT_DEVICE_QRY);
                query.append(" (acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
                break;
            }
            case GLOBAL_ADD_DEVICE: {
                query.append(INSERT_DEVICE_QRY);
                query.append(" (acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime, families)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?,?)");
                break;
            }
            case DELETE_DEVICE_DATA_NAME: {
                query.append(DELETE_DEVICE_QRY);
                query.append(FOUR_WHERE_CLAUSE_FIELDS);
                break;
            }
            case DELETE_DEVICE_HANDLE: {
                query.append(DELETE_DEVICE_QRY);
                query.append(THREE_WHERE_CLAUSE_FIELDS);
                break;
            }
            case DELETE_DEVICE_DATA_CATEGORY: {
                query.append(DELETE_DEVICE_QRY);
                query.append(TWO_WHERE_CLAUSE_FIELDS);
                break;
            }
            case DELETE_ALL_DEVICES: {
                query.append(DELETE_DEVICE_QRY);
                query.append(ONE_WHERE_CLAUSE_FIELD);
                break;
            }
            case GET_DEVICE_DATA_NAME: {
                query.append(GET_DEVICE_QRY);
                query.append(FOUR_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_DEVICE_DATA_NAME_WITH_FAMILIES: {
                query.append(GET_DEVICE_QRY_WITH_FAMILIES);
                query.append(FOUR_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_DEVICE_HANDLE: {
                query.append(GET_DEVICE_QRY);
                query.append(THREE_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_DEVICE_HANDLE_WITH_FAMILIES: {
                query.append(GET_DEVICE_QRY_WITH_FAMILIES);
                query.append(THREE_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_DEVICE_DATA_CATEGORY: {
                query.append(GET_DEVICE_QRY);
                query.append(TWO_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_DEVICE_DATA_CATEGORY_WITH_FAMILIES: {
                query.append(GET_DEVICE_QRY_WITH_FAMILIES);
                query.append(TWO_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_AND_DATACATEGORY_AND_LIMIT: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_AND_DATACATEGORY_AND_LIMIT);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_DATACATEGORY_AND_LIMIT: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_WITH_DATACATEGORY_AND_LIMIT);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_AND_DATACATEGORY_AND_HANDLE_RANGE: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_FOR_ACPID_DATACATEGORY_AND_HANDLE_RANGE);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_FOR_START_AND_END_TOKEN_AND_DATACATEGORY_AND_LIMIT: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_START_AND_END_TOKEN_AND_DATACATEGORY_AND_LIMIT);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_FOR_NEXT_ACPID_AND_END_TOKEN_AND_DATACATEGORY_AND_LIMIT: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_NEXT_ACPID_AND_END_TOKEN_AND_DATACATEGORY_AND_LIMIT);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_FOR_START_TOKEN_ONLY_AND_DATACATEGORY_AND_LIMIT: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_START_TOKEN_ONLY_AND_DATACATEGORY_AND_LIMIT);
                break;
            }
            case GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_FOR_END_TOKEN_ONLY_AND_DATACATEGORY_AND_LIMIT: {
                query.append(GET_DEVICE_QRY_FOR_SMEM_WITH_ACPID_FOR_END_TOKEN_ONLY_AND_DATACATEGORY_AND_LIMIT);
                break;
            }
            case GET_ALL_DEVICES: {
                query.append(GET_DEVICE_QRY);
                query.append(ONE_WHERE_CLAUSE_FIELD);
                break;
            }
            case GET_ALL_DEVICES_WITH_FAMILIES: {
                query.append(GET_DEVICE_QRY_WITH_FAMILIES);
                query.append(ONE_WHERE_CLAUSE_FIELD);
                break;
            }
            case GET_ALL_DEVICES_NO_VALUES: {
                query.append(GET_DEVICE_QRY_NO_VALUES);
                query.append(ONE_WHERE_CLAUSE_FIELD);
                break;
            }
            case GET_ALL_CONFIG_FOR_SMGR_BY_ACPID_AND_DATACATEGORY_AND_HANDLE_RANGE: {
                query.append(GET_DEVICE_QRY_FOR_SMGR_FOR_ACP_DATACATEGORY_AND_HANDLE_RANGE);
                break;
            }
            case UPDATE_DEVICE: {
                query.append(INSERT_DEVICE_QRY);
                query.append(" (acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, updatedatetime)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?)");
                break;
            }
            case GLOBAL_UPDATE_DEVICE: {
                query.append(INSERT_DEVICE_QRY);
                query.append(" (acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, updatedatetime,families)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?,?)");
                break;
            }
            case UPDATE_DEVICE_TIMESTAMP: {
                query.append(UPDATE_DEVICE_QRY);
                query.append(" SET updatedatetime=?");
                query.append(FOUR_WHERE_CLAUSE_FIELDS);
                break;
            }
            case GET_ALL_ACP_IDS_FROM_KEYSPACE: {
                query.append(GET_DISTINCT_ACP_IDS_FROM_KEYSPACE);
                break;
            }
            case GET_ALL_DEVICEDATA_WITH_MIGRATION_RECORD: {
                query.append("SELECT acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime, is_global_migrated");
                query.append(" FROM __KEYSPACE__.device");
                query.append(ONE_WHERE_CLAUSE_FIELD);
                break;
            }
            case GET_MIGRATION_DEVICEDATA: {
                query.append("SELECT acpid, datacategory, devicehandle, dataname, datavalue, ownercsuserid, createddatetime, updatedatetime, is_global_migrated");
                query.append(" FROM __KEYSPACE__.device");
                query.append(TWO_WHERE_CLAUSE_WITH_ISGLOBALMIGRATED);
                break;
            }
            case SET_MIGRATION_DEVICEDATA: {
                query.append(INSERT_DEVICE_QRY);
                query.append(" (acpid,createdDateTime,is_global_migrated,datacategory, devicehandle, dataname)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?)");
            }
        }
        return this.prepareQuery(query.toString(), keyspaceBuilder);
    }
}

