/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.helpers.SipUriFormatter;
import com.avaya.asm.datamgr.helpers.SmtpUriFormatter;
import com.avaya.asm.datamgr.helpers.UriFormatter;
import com.avaya.asm.datamgr.helpers.XmppUriFormatter;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;

public class UriUtils {
    private static final Logger log = AsmLogger.getLogger(UriUtils.class);

    public static boolean equalSipURI(SipUriFormatter lhs, SipUriFormatter rhs) {
        if (!"sip".equals(lhs.getScheme())) {
            lhs = new SipUriFormatter(lhs.getUri());
            lhs.setScheme("sip");
        }
        if (!"sip".equals(rhs.getScheme())) {
            rhs = new SipUriFormatter(rhs.getUri());
            rhs.setScheme("sip");
        }
        return UriUtils.equalURI(lhs, rhs, "sip");
    }

    public static boolean equalURI(UriFormatter lhs, UriFormatter rhs, String dfltScheme) {
        String rScheme;
        String fcn_name = "equalURI";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)("equalURI: enter, lhs=" + lhs + ", rhs=" + rhs));
        }
        if (!UriUtils.equalStrings(lhs.getDomain(), rhs.getDomain())) {
            if (isFiner) {
                log.finer((Object)("equalURI, leave false, l.domain=" + lhs.getDomain() + ", r.domain=" + rhs.getDomain()));
            }
            return false;
        }
        if (!UriUtils.equalStrings(lhs.getUser(), rhs.getUser())) {
            if (isFiner) {
                log.finer((Object)("equalURI, leave false, l.user=" + lhs.getUser() + ", r.user=" + rhs.getUser()));
            }
            return false;
        }
        String lScheme = lhs.getScheme();
        if (lScheme == null || lScheme.isEmpty()) {
            lScheme = dfltScheme;
        }
        if ((rScheme = rhs.getScheme()) == null || rScheme.isEmpty()) {
            rScheme = dfltScheme;
        }
        if (!UriUtils.equalStrings(lScheme, rScheme)) {
            if (lScheme != null && !lScheme.isEmpty() && (rScheme == null || rScheme.isEmpty())) {
                if (isFiner) {
                    log.finer((Object)("equalURI leave true, lScheme=" + lScheme + ", rScheme=" + rScheme));
                }
                return true;
            }
            if (rScheme != null && !rScheme.isEmpty() && (lScheme == null || lScheme.isEmpty())) {
                if (isFiner) {
                    log.finer((Object)("equalURI leave true, lScheme=" + lScheme + ", rScheme=" + rScheme));
                }
                return true;
            }
            if (isFiner) {
                log.finer((Object)("equalURI leave false, lScheme=" + lScheme + ", rScheme=" + rScheme));
            }
            return false;
        }
        return true;
    }

    private static void normalizeForeignDomain(UriFormatter uri) {
        if ("__foreign__".equals(uri.getDomain())) {
            UriFormatter tmpUri = new UriFormatter(uri.getUser());
            uri.setUser(tmpUri.getUser());
            uri.setDomain(tmpUri.getDomain());
        } else {
            String tmpScheme;
            UriFormatter tmpUri = new UriFormatter(uri.getUser());
            String tmpUser = tmpUri.getUser();
            String tmpDomain = tmpUri.getDomain();
            if (tmpUser != null && tmpDomain != null && tmpDomain.equals(uri.getDomain())) {
                uri.setUser(tmpUser);
            }
            if ((tmpScheme = tmpUri.getScheme()) != null) {
                String usr;
                uri.setScheme(tmpScheme);
                String string = usr = tmpUser != null ? tmpUser : tmpDomain;
                if (usr != null && !usr.equals(uri.getUser())) {
                    uri.setUser(usr);
                }
            }
        }
    }

    public static void normalizeSipURI(SipUriFormatter sipURI, String domain, String scheme) {
        sipURI.setScheme(scheme);
        UriUtils.normalizeForeignDomain(sipURI);
        if ((sipURI.getUser() == null || sipURI.getUser().isEmpty()) && domain != null) {
            sipURI.setUser(sipURI.getDomain());
            sipURI.setDomain(domain);
        }
    }

    public static void normalizeSipURIWithScheme(SipUriFormatter sipURI, String domain) {
        UriUtils.normalizeSipURI(sipURI, domain, "sip");
    }

    public static void normalizeSipURIWithoutScheme(SipUriFormatter sipURI, String domain) {
        UriUtils.normalizeSipURI(sipURI, domain, null);
    }

    public static void normalizeURI(UriFormatter uri, String domain) {
        UriUtils.normalizeForeignDomain(uri);
        if (uri.getUser() == null || uri.getUser().isEmpty()) {
            uri.setUser(uri.getDomain());
            uri.setDomain(domain);
        } else if (uri.getDomain() == null || uri.getDomain().isEmpty()) {
            uri.setDomain(domain);
        }
    }

    public static void normalizeXmppURIWithScheme(XmppUriFormatter xmppURI, String domain) {
        UriUtils.normalizeURI(xmppURI, domain, "xmpp");
    }

    public static void normalizeURI(UriFormatter uriFormatter, String domain, String scheme) {
        UriUtils.normalizeForeignDomain(uriFormatter);
        if (!UriUtils.isValidData(uriFormatter.getScheme())) {
            uriFormatter.setScheme(scheme);
        }
        if ((uriFormatter.getUser() == null || uriFormatter.getUser().isEmpty()) && domain != null) {
            uriFormatter.setUser(uriFormatter.getDomain());
            uriFormatter.setDomain(domain);
        }
    }

    public static void normalizeSmtpURIWithScheme(SmtpUriFormatter smtpURI, String domain) {
        UriUtils.normalizeURI(smtpURI, domain, "smtp");
    }

    public static String removeBrackets(String ipAddress) {
        String fcn_name = "UriUtils.removeBrackets";
        boolean isFiner = log.isFinerEnabled();
        if (isFiner) {
            log.finer((Object)("UriUtils.removeBrackets enter: " + ipAddress));
        }
        if (ipAddress.startsWith("[")) {
            if (ipAddress.endsWith("]")) {
                int len = ipAddress.length();
                String newIpAddress = ipAddress.substring(1, len - 1);
                if (IPAddress.isIPv6Address(newIpAddress)) {
                    if (isFiner) {
                        log.finer((Object)("UriUtils.removeBrackets leave: " + newIpAddress));
                    }
                    return newIpAddress;
                }
                log.warn((Object)"UriUtils.removeBrackets leave: invalid IPv6 address");
                return null;
            }
            log.warn((Object)"UriUtils.removeBrackets leave: no closing bracket");
            return null;
        }
        if (ipAddress.endsWith("]")) {
            log.warn((Object)"UriUtils.removeBrackets leave: no opening bracket");
            return null;
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("UriUtils.removeBrackets leave: " + ipAddress));
        }
        return ipAddress;
    }

    public static boolean equalStrings(String str1, String str2) {
        return UriUtils.equalObjects(str1, str2);
    }

    public static boolean equalObjects(Object obj1, Object obj2) {
        if (obj1 == null) {
            if (obj2 == null) {
                return true;
            }
        } else if (obj2 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    public static boolean isValidData(String testStr) {
        return testStr != null && !testStr.isEmpty();
    }
}

