/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.listener.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.ConnectionPoolInitializerException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraBasedDAO;
import com.avaya.asm.datamgr.listener.cassandra.ClusterChangeNotifier;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HostStateListener
implements Host.StateListener {
    private final Logger log = AsmLogger.getLogger(HostStateListener.class);
    protected Set<ClusterChangeNotifier> notifiers = new HashSet<ClusterChangeNotifier>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();
    CassandraBasedDAO cbd;

    public HostStateListener(CassandraBasedDAO cbd) {
        this.cbd = cbd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerNotifier(ClusterChangeNotifier ccn) {
        String fcn_name = "registerNotifier";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("registerNotifier: enter, ccn=" + ccn + ", notifiers.size=" + this.notifiers.size()));
        }
        this.w.lock();
        try {
            boolean isEmpty = this.notifiers.isEmpty();
            boolean rc = this.notifiers.add(ccn);
            if (isFinest) {
                this.log.finest((Object)("registerNotifier: added ccn to notifiers, rc=" + rc + ", isEmpty=" + isEmpty));
            }
            if (isEmpty && rc) {
                if (isFinest) {
                    this.log.finest((Object)"registerNotifier: registering this HostStateListener");
                }
                try {
                    this.cbd.checkCluster();
                }
                catch (ConnectionPoolInitializerException | DMException e) {
                    this.log.error((Object)("registerNotifier: checkCluster threw exception, notifiers.size=" + this.notifiers.size()), (Throwable)e);
                }
            }
            if (isFiner) {
                this.log.finer((Object)("registerNotifier: leave, notifiers.size=" + this.notifiers.size()));
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterNotifier(ClusterChangeNotifier ccn) {
        String fcn_name = "unregisterNotifier";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("unregisterNotifier: enter, ccn=" + ccn + ", notifiers.size=" + this.notifiers.size()));
        }
        this.w.lock();
        try {
            boolean rc = this.notifiers.remove(ccn);
            if (isFinest) {
                this.log.finest((Object)("unregisterNotifier: removed ccn from notifiers, rc=" + rc));
            }
            if (isFiner) {
                this.log.finer((Object)("unregisterNotifier: leave, notifiers.size=" + this.notifiers.size()));
            }
            boolean bl = rc;
            return bl;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdd(Host host) {
        String fcn_name = "onAdd";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onAdd: enter, host=" + host + ", notifiers.size=" + this.notifiers.size()));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onAdd: leave, no notifiers");
            }
            return;
        }
        InetAddress hostAddr = host.getAddress();
        this.r.lock();
        try {
            for (ClusterChangeNotifier ccn : this.notifiers) {
                ccn.nodeJoin(hostAddr);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)("onAdd: leave, host=" + host));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDown(Host host) {
        String fcn_name = "onDown";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onDown: enter, host=" + host + ", notifiers.size=" + this.notifiers.size()));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onDown: leave, no notifiers");
            }
            return;
        }
        InetAddress hostAddr = host.getAddress();
        this.r.lock();
        try {
            for (ClusterChangeNotifier ccn : this.notifiers) {
                ccn.nodeDown(hostAddr);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)("onDown: leave, host=" + host));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(Host host) {
        String fcn_name = "onRemove";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onRemove: enter, host=" + host + ", notifiers.size=" + this.notifiers.size()));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onRemove: leave, no notifiers");
            }
            return;
        }
        InetAddress hostAddr = host.getAddress();
        this.r.lock();
        try {
            for (ClusterChangeNotifier ccn : this.notifiers) {
                ccn.nodeDrop(hostAddr);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)("onRemove: leave, host=" + host));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUp(Host host) {
        String fcn_name = "onUp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("onUp: enter, host=" + host + ", notifiers.size=" + this.notifiers.size()));
        }
        if (this.notifiers.isEmpty()) {
            if (isFiner) {
                this.log.finer((Object)"onUp: leave, no notifiers");
            }
            return;
        }
        InetAddress hostAddr = host.getAddress();
        this.r.lock();
        try {
            for (ClusterChangeNotifier ccn : this.notifiers) {
                ccn.nodeUp(hostAddr);
            }
        }
        finally {
            this.r.unlock();
        }
        if (isFiner) {
            this.log.finer((Object)("onUp: leave, host=" + host));
        }
    }

    public void onRegister(Cluster arg0) {
    }

    public void onUnregister(Cluster arg0) {
    }
}

