/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.FeatureTags;
import com.avaya.asm.datamgr.Lockable;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.InstanceMonitoringParameters;
import com.avaya.asm.datamgr.objectapi.MonitorTransition;
import com.avaya.asm.datamgr.objectapi.MonitorTransitions;
import com.avaya.asm.datamgr.objectapi.MonitoredAddress;
import com.avaya.asm.datamgr.objectapi.MonitoredEntityListener;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.SipMonResponseHandling;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoredEntity
extends Lockable
implements Serializable {
    private static final long serialVersionUID = -7940192790023545219L;
    private volatile SIPEntity entity;
    private volatile boolean doMonitoring = false;
    private volatile int proactiveSecs;
    private volatile int reactiveSecs;
    private volatile int retries;
    private volatile int okResponses;
    private volatile Map<String, MonitoredAddress> addressMap = new ConcurrentHashMap<String, MonitoredAddress>(4, 0.9f, 1);
    private volatile int outstandingResponses = 0;
    private volatile AtomicLong nextScheduled = new AtomicLong();
    private volatile Mode mode = Mode.PROACTIVE;
    private volatile Status status = Status.NOTMONITORED;
    private volatile boolean trackForDeadZone;
    private static final int SAVED_TRANSITIONS = 5;
    private volatile MonitorTransitions<Status> transitions = new MonitorTransitions(5);
    private static final int SAVED_MULTIHOP_TRANSITIONS = 20;
    private volatile Map<Long, MonitorTransitions<Status>> multiHopTransitions = new ConcurrentHashMap<Long, MonitorTransitions<Status>>();
    private volatile String serverHeader = "";
    private volatile String featureTags = null;
    private volatile int retryAfter;
    private volatile boolean tentativelyUp = false;
    private volatile ZoneFileStatus writeDeadZoneFiles = ZoneFileStatus.NOCHANGE;
    private volatile transient MonitoredEntityListener listener = null;

    public MonitoredEntity(SIPEntity entity) {
        super(MonitoredEntity.class.getSimpleName() + entity.getId());
        this.setEntity(entity);
    }

    public boolean doMonitoring() {
        return this.doMonitoring;
    }

    public Long getId() {
        return this.entity.getId();
    }

    public String getFqdnoripaddr() {
        return this.entity.getFqdnoripaddr();
    }

    public List<FQDNOrIpAddr> getFQDNOrIPAddrs() {
        return this.entity.getFQDNOrIPAddrs();
    }

    public boolean hasFQDN() {
        return this.entity.hasFQDN();
    }

    public String getName() {
        return this.entity.getName();
    }

    public boolean getUseRFC3263() {
        return this.entity.getUseRFC3263();
    }

    public Long getNextScheduled() {
        return this.nextScheduled.get();
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getProactiveSecs() {
        return this.proactiveSecs;
    }

    public int getReactiveSecs() {
        return this.reactiveSecs;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getOkResponses() {
        return this.okResponses;
    }

    public Boolean matchesResponseHandling(String response) {
        return this.entity.matchesSipMonResponseHandling(response);
    }

    public void setAddressMap(Map<String, MonitoredAddress> addressMap) {
        this.addressMap = addressMap;
    }

    public void setOutstandingResponses(int outstandingResponses) {
        this.outstandingResponses = outstandingResponses;
    }

    public int getOutstandingResponses() {
        return this.outstandingResponses;
    }

    public int decrementOutstandingResponses() {
        this.acquireWriteLock();
        try {
            int n = --this.outstandingResponses;
            return n;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void setNextScheduled(long nextScheduled) {
        this.nextScheduled.set(nextScheduled);
    }

    public Map<String, MonitoredAddress> getAddressMap() {
        return Collections.unmodifiableMap(this.addressMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitoredAddress getAddress(String ipAddress, AsmConstants.TRANSPORT transport) {
        MonitoredAddress address;
        block6: {
            address = null;
            this.acquireReadLock();
            try {
                IPAddress ipAddr = IPAddress.fromString(ipAddress);
                if (ipAddr == null) break block6;
                for (MonitoredAddress addr : this.addressMap.values()) {
                    if (addr.getTransport() != transport || !ipAddr.isEqualTo(addr.getIpaddress())) continue;
                    if (address == null) {
                        address = addr;
                        continue;
                    }
                    MonitoredAddress monitoredAddress = null;
                    return monitoredAddress;
                }
            }
            finally {
                this.releaseReadLock();
            }
        }
        return address;
    }

    public void denyNewService(AsmConstants.TRANSPORT transport, boolean denyNewService) {
        for (MonitoredAddress address : this.addressMap.values()) {
            if (address.getTransport() != transport) continue;
            address.denyNewService(denyNewService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastResponse() {
        long lastResponse = 0L;
        this.acquireReadLock();
        try {
            for (MonitoredAddress address : this.addressMap.values()) {
                long addrLastResponse = address.getLastResponse();
                if (addrLastResponse <= lastResponse) continue;
                lastResponse = addrLastResponse;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return lastResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastSent() {
        long lastSent = 0L;
        this.acquireReadLock();
        try {
            for (MonitoredAddress address : this.addressMap.values()) {
                long addrSent = address.getSentOptions();
                if (addrSent <= lastSent) continue;
                lastSent = addrSent;
            }
        }
        finally {
            this.releaseReadLock();
        }
        return lastSent;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.transitions.update(status, null);
    }

    public MonitorTransition<Status> getLastTransition() {
        return this.transitions.getLastTransition();
    }

    public boolean getTentativelyUp() {
        return this.tentativelyUp;
    }

    public void setTentativelyUp(boolean tentativelyUp) {
        this.tentativelyUp = tentativelyUp;
    }

    public int getRetryAfter() {
        return this.retryAfter;
    }

    public SIPEntity getEntity() {
        return this.entity;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public FeatureTags getFeatureTags() {
        return new FeatureTags(this.featureTags);
    }

    public void setEntity(SIPEntity entity) {
        this.acquireWriteLock();
        try {
            this.entity = entity;
            if (entity.getDo_monitoring() != null) {
                this.doMonitoring = entity.getDo_monitoring();
                this.proactiveSecs = entity.getMonitor_proactive_secs();
                this.reactiveSecs = entity.getMonitor_reactive_secs();
                this.retries = entity.getMonitor_retries();
                this.okResponses = entity.getMonitor_okResponses();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public synchronized void setMonitoringParameters(InstanceMonitoringParameters parms) {
        this.doMonitoring = parms.isMonitoring();
        this.proactiveSecs = parms.getProactiveSeconds();
        this.reactiveSecs = parms.getReactiveSeconds();
        this.retries = parms.getRetries();
        this.okResponses = parms.getOkResponses();
    }

    public void setListener(MonitoredEntityListener listener) {
        this.listener = listener;
    }

    public void addressWasMarkedDown() {
        Status oldStatus;
        this.acquireWriteLock();
        try {
            oldStatus = this.status;
            this.updateStatusMode();
        }
        finally {
            this.releaseWriteLock();
        }
        if (this.listener != null) {
            this.listener.entityGotAllResponses(this, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(String servHeader, FeatureTags featTags) {
        Status oldStatus;
        boolean notifyListener = false;
        this.acquireWriteLock();
        try {
            oldStatus = this.status;
            --this.outstandingResponses;
            if (this.outstandingResponses <= 0) {
                this.tentativelyUp = false;
                this.updateStatusMode();
                if (this.listener != null) {
                    notifyListener = true;
                }
            }
            if (servHeader != null) {
                this.serverHeader = servHeader;
            }
            if (featTags != null) {
                this.featureTags = featTags.toFeatureTagsString();
            }
        }
        finally {
            this.releaseWriteLock();
        }
        if (notifyListener) {
            this.listener.entityGotAllResponses(this, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusMode() {
        this.acquireWriteLock();
        try {
            if (this.addressMap.size() == 0) {
                this.setStatus(Status.DOWN);
                this.mode = Mode.REACTIVE;
                return;
            }
            Status newStatus = Status.INITIALIZING;
            boolean denyNewService = true;
            this.retryAfter = 0;
            for (MonitoredAddress address : this.addressMap.values()) {
                MonitoredAddress.Status addressStatus = address.getStatus();
                if (addressStatus == MonitoredAddress.Status.DENY || address.denyNewService()) continue;
                denyNewService = false;
                if (addressStatus == MonitoredAddress.Status.INITIALIZING) continue;
                if (addressStatus != MonitoredAddress.Status.UP) {
                    int addressRetry = address.getRetryAfter();
                    if (addressRetry != 0 && (this.retryAfter == 0 || this.retryAfter > addressRetry)) {
                        this.retryAfter = addressRetry;
                    }
                    if (newStatus == Status.UP || newStatus == Status.PARTIALLYUP) {
                        newStatus = Status.PARTIALLYUP;
                        continue;
                    }
                    newStatus = Status.DOWN;
                    continue;
                }
                if (newStatus == Status.DOWN || newStatus == Status.PARTIALLYUP) {
                    newStatus = Status.PARTIALLYUP;
                    continue;
                }
                newStatus = Status.UP;
            }
            this.setStatus(denyNewService ? Status.DENY : newStatus);
            this.mode = this.status == Status.DOWN || this.status == Status.PARTIALLYUP ? Mode.REACTIVE : Mode.PROACTIVE;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.getName().equals(((MonitoredEntity)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponses() {
        StringBuilder buf = new StringBuilder();
        this.acquireReadLock();
        try {
            if (this.addressMap.size() == 0) {
                buf.append("no resolved addresses");
            } else {
                for (MonitoredAddress address : this.addressMap.values()) {
                    buf.append(address.getKey());
                    buf.append("=\"");
                    buf.append(address.getReason());
                    buf.append("\" ");
                }
                buf.delete(buf.length() - 1, buf.length());
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.acquireReadLock();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            StringBuilder returnString = new StringBuilder("MonitoredEntity[id=" + this.getId() + ", fqdnoripaddrs=" + this.getFQDNOrIPAddrs() + ", name=\"" + this.getName() + "\", status=" + (Object)((Object)this.status) + ", mode=" + (Object)((Object)this.mode) + ", retryAfter=" + this.retryAfter + ", tentativelyUp=" + this.tentativelyUp + ", outstanding=" + this.outstandingResponses + ", nextScheduled=" + dateFormat.format(this.nextScheduled.get()));
            if (this.addressMap != null) {
                returnString.append(", addressMap=" + this.addressMap);
            }
            returnString.append(", multiHopTransitions=" + this.multiHopTransitions);
            returnString.append(", mon=" + this.doMonitoring() + "/" + this.getProactiveSecs() + "/" + this.getReactiveSecs() + "/" + this.getRetries() + "/" + this.getOkResponses());
            returnString.append(", handling=[");
            Map<Long, SipMonResponseHandling> handlings = this.entity.getSipMonResponseHandling();
            if (handlings == null) {
                returnString.append("null");
            } else {
                for (SipMonResponseHandling handling : handlings.values()) {
                    returnString.append(handling + " ");
                }
            }
            returnString.append("]");
            returnString.append(", serverHeader=\"" + this.serverHeader + "\"");
            returnString.append(", featureTags=" + this.getFeatureTags());
            returnString.append("]");
            String string = returnString.toString();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public ZoneFileStatus needToWriteDeadZoneFiles() {
        return this.writeDeadZoneFiles;
    }

    public void setWriteDeadZoneFiles(ZoneFileStatus newWriteDeadZoneStatus) {
        if (newWriteDeadZoneStatus == ZoneFileStatus.MODIFYZONE) {
            if (this.writeDeadZoneFiles == ZoneFileStatus.NOCHANGE) {
                this.writeDeadZoneFiles = newWriteDeadZoneStatus;
            }
            return;
        }
        this.writeDeadZoneFiles = newWriteDeadZoneStatus;
    }

    public boolean trackForDeadZone() {
        if (this.hasFQDN()) {
            return true;
        }
        return this.trackForDeadZone;
    }

    public void setTrackForDeadZone(boolean trackForDeadZone) {
        this.trackForDeadZone = trackForDeadZone;
    }

    public Map<String, String> getOptionsFeatureTags() {
        return null;
    }

    public Map<String, String> getOptionsHeaders() {
        HashMap<String, String> retVal = null;
        if (!this.entity.getIsASM()) {
            retVal = new HashMap<String, String>();
            retVal.put("Accept", this.entity.getIsAMS() ? "application/com.avaya.media-server-perf-v1+xml" : "application/com.avaya.server-perf+xml");
        }
        return retVal;
    }

    public boolean isRefusingService() {
        for (MonitoredAddress address : this.addressMap.values()) {
            if (address.isRefusingService()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status setMultiHopStatus(Long monitoringEntityId, Status newStatus, String timeString) {
        long time;
        try {
            SimpleDateFormat simpleDateFormat = MonitorTransition.DATE_FORMAT;
            synchronized (simpleDateFormat) {
                time = MonitorTransition.DATE_FORMAT.parse(timeString).getTime();
            }
        }
        catch (ParseException e) {
            return this.status;
        }
        this.acquireWriteLock();
        try {
            MonitorTransitions<Status> transitions = this.multiHopTransitions.get(monitoringEntityId);
            if (transitions == null) {
                transitions = new MonitorTransitions(20);
                this.multiHopTransitions.put(monitoringEntityId, transitions);
            }
            Status status = transitions.update(newStatus, null, time);
            return status;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEntityUp(Long monitoringEntityId) {
        this.acquireReadLock();
        try {
            MonitorTransitions<Status> transitions = this.multiHopTransitions.get(monitoringEntityId);
            if (transitions == null) {
                boolean bl = true;
                return bl;
            }
            MonitorTransition<Status> transition = transitions.getLastTransition();
            if (transition == null) {
                boolean bl = true;
                return bl;
            }
            Status status = transition.getStatus();
            boolean bl = status != Status.DOWN && status != Status.DENY;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public static enum ZoneFileStatus {
        NOCHANGE,
        REMOVEZONE,
        MODIFYZONE;

    }

    public static enum Status {
        NOTMONITORED,
        INITIALIZING,
        UP,
        PARTIALLYUP,
        DOWN,
        DENY;

    }

    public static enum Mode {
        PROACTIVE,
        REACTIVE;

    }
}

