/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;

public class UserDomainAOR {
    private static final Logger log = AsmLogger.getLogger(UserDomainAOR.class);
    private String user = null;
    private String domain = null;
    private String uri = null;

    public UserDomainAOR(String uri) {
        int atSignIdx = uri.indexOf(64);
        if (atSignIdx < 0 && log.isFineEnabled()) {
            log.fine((Object)("getAllAttributes: Invalid URI: '" + uri + "'"));
        }
        this.user = uri.substring(0, atSignIdx);
        this.domain = uri.substring(atSignIdx + 1);
        this.uri = uri;
    }

    public UserDomainAOR(String user, String domain) {
        this.user = user;
        this.domain = domain;
        this.uri = user + "@" + domain;
    }

    public String getUser() {
        return this.user;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUri() {
        return this.uri;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserDomainAOR other = (UserDomainAOR)obj;
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public String toString() {
        return "UserDomainAOR [user=" + this.user + ", domain=" + this.domain + ", uri=" + this.uri + "]";
    }
}

