/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class SMConsoleParam
implements Serializable {
    private static final long serialVersionUID = -2780164117624219198L;
    private String paramName;
    private final String paramTypeStr;
    private final Class<?> paramType;
    private final boolean typedParam;
    private Object value;
    private boolean isRequired;
    private final Set<String> allowedValues = new HashSet<String>();
    private boolean isArray;

    public SMConsoleParam(Class<?> clazz, String name, Object value) {
        this(clazz, name);
        this.setValue(value);
    }

    public SMConsoleParam(String name, String value) {
        this(name);
        this.setValue(value);
    }

    public SMConsoleParam(Class<?> clazz, String name) {
        this.paramType = clazz;
        this.paramTypeStr = clazz.getSimpleName();
        this.parseName(name);
        this.value = null;
        this.typedParam = true;
        this.isRequired = true;
        this.isArray = clazz.isArray();
    }

    public SMConsoleParam(String name) {
        this.isRequired = true;
        this.paramType = null;
        this.paramTypeStr = null;
        this.value = null;
        this.typedParam = false;
        this.isArray = false;
        this.parseName(name);
    }

    protected void parseName(String name) {
        this.paramName = name;
        if (name == null) {
            return;
        }
        if (name.indexOf("?") == 0) {
            this.paramName = name.substring(1);
            this.isRequired = false;
        }
        if (name.indexOf(":") > 0) {
            StringTokenizer st = new StringTokenizer(name, ":");
            int count = st.countTokens();
            if (count < 2) {
                throw new IllegalArgumentException("Invalid required parameters");
            }
            this.paramName = st.nextToken();
            while (st.hasMoreTokens()) {
                this.addAllowedValue(st.nextToken());
            }
        }
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String s) {
        this.parseName(s);
    }

    public String getStringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        return null;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getParamTypeStr() {
        return this.paramTypeStr;
    }

    public Class<?> getParamType() {
        return this.paramType;
    }

    public void addAllowedValue(String newValue) {
        this.allowedValues.add(newValue);
    }

    public List<String> getAllowedValues() {
        ArrayList<String> allowedValuesList = new ArrayList<String>(this.allowedValues);
        Collections.sort(allowedValuesList);
        return allowedValuesList;
    }

    public boolean isTypedParam() {
        return this.typedParam;
    }

    public boolean isAllowedParam(String paramVal) {
        if (this.paramName != null && this.allowedValues.size() == 0) {
            return this.paramName.equalsIgnoreCase(paramVal);
        }
        for (String val : this.allowedValues) {
            if (!val.equalsIgnoreCase(paramVal)) continue;
            return true;
        }
        return false;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int hashCode() {
        return (this.paramName != null ? this.paramName.hashCode() : 0) + (this.paramTypeStr != null ? this.paramTypeStr.hashCode() : 0);
    }

    public boolean equals(Object o) {
        SMConsoleParam p;
        return o != null && o instanceof SMConsoleParam && (p = (SMConsoleParam)o) != null && (this.paramName != null && this.paramName.equalsIgnoreCase(p.paramName) || this.paramName == null && p.paramName == null) && (this.paramTypeStr != null && this.paramTypeStr.equalsIgnoreCase(p.paramTypeStr) || this.paramTypeStr == null && p.paramTypeStr == null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.isRequired()) {
            builder.append("[");
        }
        if (this.paramTypeStr == null && !this.allowedValues.isEmpty()) {
            builder.append(String.class.getSimpleName());
        } else {
            builder.append(this.paramTypeStr);
        }
        builder.append(" ");
        if (this.paramName != null) {
            builder.append(this.paramName);
        }
        if (!this.allowedValues.isEmpty()) {
            builder.append("{");
            boolean addPipe = false;
            List<String> allowedV = this.getAllowedValues();
            for (String allowed : allowedV) {
                if (addPipe) {
                    builder.append("|");
                }
                builder.append(allowed);
                addPipe = true;
            }
            builder.append("}");
        }
        if (this.value != null) {
            builder.append("=" + this.value);
        }
        if (!this.isRequired()) {
            builder.append("]");
        }
        return builder.toString();
    }
}

