/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.debug;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.debug.CaptureCallback;
import com.avaya.asm.debug.CaptureResult;
import com.avaya.common.logging.client.Logger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public class CaptureHandler {
    protected static volatile CaptureHandler myInstance = null;
    private static final long DEFAULT_TIMEOUT = 32000L;
    private MessageCapture msgCapture = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaptureHandler getInstance() {
        if (myInstance != null) return myInstance;
        Class<CaptureHandler> clazz = CaptureHandler.class;
        synchronized (CaptureHandler.class) {
            if (myInstance != null) return myInstance;
            myInstance = new CaptureHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return myInstance;
        }
    }

    private CaptureHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptureResult captureMessage(CaptureCallback callback, boolean blocking, boolean persistent, String ... conditions) throws Exception {
        MessageCapture msgCapture;
        if (this.msgCapture != null) {
            throw new IllegalStateException("Message capture already set.");
        }
        this.msgCapture = msgCapture = new MessageCapture(callback, blocking, persistent, conditions);
        if (!blocking) {
            return null;
        }
        try {
            MessageCapture messageCapture = msgCapture;
            synchronized (messageCapture) {
                msgCapture.wait(msgCapture.getTimeout());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.msgCapture = null;
        CaptureResult result = msgCapture.getResult();
        return result != null ? result : new CaptureResult(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCapture() {
        MessageCapture msgCapture = this.msgCapture;
        if (msgCapture != null) {
            MessageCapture messageCapture = msgCapture;
            synchronized (messageCapture) {
                msgCapture.notify();
            }
            this.msgCapture = null;
        }
    }

    public Object getCapture() {
        return this.msgCapture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void considerMessage(SipServletMessage msg, Object source) {
        MessageCapture msgCapture = this.msgCapture;
        if (msgCapture != null) {
            boolean persistent = msgCapture.isPersistent();
            if ((persistent || msgCapture.getResult() == null) && msgCapture.matches(msg, source)) {
                MessageCapture messageCapture = msgCapture;
                synchronized (messageCapture) {
                    if (persistent && msgCapture.decrementAndGetCount() >= 0L || msgCapture.getResult() == null) {
                        CaptureResult result = new CaptureResult(msg, source);
                        msgCapture.setResult(result);
                        CaptureCallback callback = msgCapture.getCallback();
                        if (callback != null) {
                            callback.messageCaptured(result);
                            if (!msgCapture.isPersistent()) {
                                this.msgCapture = null;
                            }
                        }
                        if (msgCapture.isBlocking()) {
                            msgCapture.notify();
                        }
                    } else if (persistent) {
                        this.msgCapture = null;
                    }
                }
            } else if (msgCapture.isTimedOut()) {
                this.msgCapture = null;
            }
        }
    }

    private static class MessageCapture {
        private final long startTime;
        private final List<Condition> conditions;
        private final CaptureCallback callback;
        private final boolean blocking;
        private final boolean persistent;
        private long timeout;
        private AtomicLong count;
        private CaptureResult result;

        public MessageCapture(CaptureCallback callback, boolean blocking, boolean persistent, String[] conditions) throws Exception {
            if (persistent && callback == null) {
                throw new IllegalArgumentException("Persistent mode requires non-null CaptureCallback.");
            }
            this.startTime = System.currentTimeMillis();
            this.callback = callback;
            this.blocking = blocking;
            this.persistent = persistent;
            this.timeout = persistent ? 0L : 32000L;
            this.count = new AtomicLong(1L);
            this.conditions = new ArrayList<Condition>();
            for (String cond : conditions) {
                Condition c = new Condition(cond);
                if (c.getType() == ConditionType.TIMEOUT) {
                    this.timeout = (Long)c.getArg();
                    continue;
                }
                if (c.getType() == ConditionType.COUNT) {
                    if (!persistent) {
                        throw new IllegalArgumentException("Count allowed with persistent capture only.");
                    }
                    this.count = new AtomicLong((Long)c.getArg());
                    continue;
                }
                this.conditions.add(c);
            }
            this.result = null;
        }

        public CaptureCallback getCallback() {
            return this.callback;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public boolean isBlocking() {
            return this.blocking;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public boolean isTimedOut() {
            return this.timeout != 0L && System.currentTimeMillis() > this.startTime + this.timeout;
        }

        public long decrementAndGetCount() {
            return this.count.decrementAndGet();
        }

        public CaptureResult getResult() {
            return this.result;
        }

        public void setResult(CaptureResult result) {
            this.result = result;
        }

        public boolean matches(SipServletMessage msg, Object source) {
            for (Condition condition : this.conditions) {
                if (condition.matches(msg, source)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "MessageCapture[conditions=" + this.conditions + ", timeout=" + this.timeout + ", blocking=" + this.blocking + ", persistent=" + this.persistent + ", count=" + this.count.get() + "]";
        }
    }

    private static class Condition {
        private static final Logger log = AsmLogger.getLogger(Condition.class);
        private final ConditionType type;
        private final String name;
        private final Object arg;
        private final int instance;
        private final boolean useReq;
        private final boolean not;

        public Condition(String spec) throws Exception {
            ConditionType type;
            int eIndex;
            boolean neq;
            boolean useReq = false;
            boolean not = false;
            Object arg = null;
            String name = null;
            int instance = 0;
            if (spec.charAt(0) == '!') {
                not = true;
                spec = spec.substring(1);
            }
            if (spec.toLowerCase().startsWith("req.")) {
                useReq = true;
                spec = spec.substring(4);
            }
            boolean bl = neq = (eIndex = spec.indexOf(61)) > 0 && spec.charAt(eIndex - 1) == '!';
            String c = eIndex < 0 ? spec : spec.substring(0, neq ? eIndex - 1 : eIndex);
            String argStr = eIndex < 0 ? null : spec.substring(eIndex + 1);
            switch (c.toLowerCase()) {
                case "timeout": {
                    if (not || neq) {
                        throw new ParseException("Cannot negate timeout.", 0);
                    }
                    type = ConditionType.TIMEOUT;
                    arg = Long.parseLong(argStr);
                    if ((Long)arg >= 0L) break;
                    throw new IllegalArgumentException("Timeout cannot be negative.");
                }
                case "count": {
                    if (not || neq) {
                        throw new ParseException("Cannot negate count.", 0);
                    }
                    type = ConditionType.COUNT;
                    arg = Long.parseLong(argStr);
                    break;
                }
                case "source": {
                    type = ConditionType.SOURCE;
                    arg = argStr;
                    break;
                }
                case "req": 
                case "request": {
                    type = ConditionType.REQ;
                    arg = new Boolean(argStr == null || "true".equalsIgnoreCase(argStr));
                    break;
                }
                case "resp": 
                case "response": {
                    type = ConditionType.RESP;
                    arg = new Boolean(argStr == null || "true".equalsIgnoreCase(argStr));
                    break;
                }
                case "initial": {
                    type = ConditionType.INITIAL;
                    arg = new Boolean(argStr == null || "true".equalsIgnoreCase(argStr));
                    break;
                }
                case "branch": {
                    type = ConditionType.BRANCH;
                    arg = new Boolean(argStr == null || "true".equalsIgnoreCase(argStr));
                    break;
                }
                case "auth": {
                    type = ConditionType.AUTH;
                    arg = new Boolean(argStr == null || "true".equalsIgnoreCase(argStr));
                    break;
                }
                case "method": {
                    type = ConditionType.METHOD;
                    arg = Pattern.compile(argStr.toUpperCase());
                    break;
                }
                case "status": 
                case "rcode": {
                    type = ConditionType.RCODE;
                    arg = Pattern.compile(argStr);
                    break;
                }
                case "rtext": {
                    type = ConditionType.RTEXT;
                    arg = Pattern.compile(argStr);
                    break;
                }
                case "ruri": 
                case "r-uri": {
                    type = ConditionType.RURI;
                    arg = Pattern.compile(argStr);
                    break;
                }
                case "body": {
                    type = ConditionType.BODY;
                    arg = Pattern.compile(argStr, 40);
                    break;
                }
                default: {
                    if (c.toLowerCase().startsWith("bodypart(")) {
                        type = ConditionType.BODYPART;
                        arg = Pattern.compile(argStr, 40);
                        name = c.substring(9, c.indexOf(41));
                        break;
                    }
                    if (c.toLowerCase().startsWith("top(")) {
                        type = ConditionType.HEADER;
                        arg = Pattern.compile(argStr);
                        name = c.substring(4, c.indexOf(41));
                        instance = 1;
                        break;
                    }
                    if (c.toLowerCase().startsWith("bottom(")) {
                        type = ConditionType.HEADER;
                        arg = Pattern.compile(argStr);
                        name = c.substring(7, c.indexOf(41));
                        instance = -1;
                        break;
                    }
                    if (c.toLowerCase().startsWith("instance(")) {
                        type = ConditionType.HEADER;
                        arg = Pattern.compile(argStr);
                        name = c.substring(9, c.indexOf(44));
                        instance = Integer.parseInt(c.substring(c.indexOf(44) + 1, c.indexOf(41)));
                        break;
                    }
                    if (c.toLowerCase().startsWith("any(")) {
                        type = ConditionType.HEADER;
                        arg = Pattern.compile(argStr);
                        name = c.substring(4, c.indexOf(41));
                        break;
                    }
                    if (c.toLowerCase().startsWith("all(")) {
                        type = ConditionType.ALL_HEADER;
                        arg = Pattern.compile(argStr);
                        name = c.substring(4, c.indexOf(41));
                        break;
                    }
                    type = ConditionType.HEADER;
                    arg = Pattern.compile(argStr);
                    name = c;
                }
            }
            this.type = type;
            this.not = neq ^ not;
            this.useReq = useReq;
            this.arg = arg;
            this.name = name;
            this.instance = instance;
        }

        public ConditionType getType() {
            return this.type;
        }

        public Object getArg() {
            return this.arg;
        }

        public String getName() {
            return this.name;
        }

        public boolean matches(SipServletMessage msg, Object source) {
            if (this.useReq) {
                if (!(msg instanceof SipServletResponse)) {
                    return false;
                }
                msg = ((SipServletResponse)msg).getRequest();
            }
            return this.not ^ this.evalMatches(msg, source);
        }

        private boolean evalMatches(SipServletMessage msg, Object source) {
            switch (this.type) {
                case SOURCE: {
                    return this.arg.equals(source.getClass().getSimpleName());
                }
                case REQ: {
                    Boolean isReq = msg instanceof SipServletRequest;
                    return isReq.equals((Boolean)this.arg);
                }
                case RESP: {
                    Boolean isResp = msg instanceof SipServletResponse;
                    return isResp.equals((Boolean)this.arg);
                }
                case INITIAL: {
                    Boolean isInitial = msg instanceof SipServletResponse && ((SipServletResponse)msg).getRequest().isInitial() || msg instanceof SipServletRequest && ((SipServletRequest)msg).isInitial();
                    return isInitial.equals((Boolean)this.arg);
                }
                case BRANCH: {
                    try {
                        Boolean isBranch = msg instanceof SipServletResponse && ((SipServletResponse)msg).isBranchResponse() || msg instanceof SipServletRequest && ((SipServletRequest)msg).getProxy(false) != null;
                        return isBranch.equals((Boolean)this.arg);
                    }
                    catch (Exception isBranch) {
                        return false;
                    }
                }
                case AUTH: {
                    Boolean auth = msg.getHeader("Proxy-Authorization") != null || msg.getHeader("Authorization") != null;
                    return auth.equals((Boolean)this.arg);
                }
                case METHOD: {
                    return ((Pattern)this.arg).matcher(msg.getMethod()).matches();
                }
                case RCODE: {
                    if (!(msg instanceof SipServletResponse)) break;
                    String rcode = Integer.toString(((SipServletResponse)msg).getStatus());
                    return ((Pattern)this.arg).matcher(rcode).matches();
                }
                case RTEXT: {
                    if (!(msg instanceof SipServletResponse)) break;
                    String rtext = ((SipServletResponse)msg).getReasonPhrase();
                    return ((Pattern)this.arg).matcher(rtext).matches();
                }
                case RURI: {
                    if (!(msg instanceof SipServletRequest)) break;
                    String ruri = ((SipServletRequest)msg).getRequestURI().toString();
                    return ((Pattern)this.arg).matcher(ruri).matches();
                }
                case HEADER: {
                    String header;
                    ListIterator headers = msg.getHeaders(this.name);
                    int inst = 0;
                    while (headers.hasNext()) {
                        header = (String)headers.next();
                        if (this.instance != 0 && this.instance != ++inst || !((Pattern)this.arg).matcher(header).matches()) continue;
                        return true;
                    }
                    if (this.instance >= 0) break;
                    inst = 0;
                    while (headers.hasPrevious()) {
                        header = (String)headers.previous();
                        if (this.instance != --inst || !((Pattern)this.arg).matcher(header).matches()) continue;
                        return true;
                    }
                    break;
                }
                case ALL_HEADER: {
                    ListIterator headers = msg.getHeaders(this.name);
                    while (headers.hasNext()) {
                        String header = (String)headers.next();
                        if (((Pattern)this.arg).matcher(header).matches()) continue;
                        return false;
                    }
                    return true;
                }
                case BODY: {
                    try {
                        if (msg.getContentLength() > 0) {
                            String content = this.getContentAsString(msg);
                            return content != null && ((Pattern)this.arg).matcher(content).matches();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Exception converting message content to String: " + e), (Throwable)e);
                    }
                    break;
                }
                case BODYPART: {
                    try {
                        if (msg.getContentLength() > 0) {
                            int index;
                            String content;
                            String contentType = msg.getContentType();
                            if (this.name.equals(contentType)) {
                                String content2 = this.getContentAsString(msg);
                                return content2 != null && ((Pattern)this.arg).matcher(content2).matches();
                            }
                            if (contentType != null && contentType.startsWith("multipart") && (content = this.getContentAsString(msg)) != null && (index = content.indexOf("\nContent-Type: " + this.name)) >= 0) {
                                int sIndex = index + 19 + this.name.length();
                                int eIndex = content.indexOf("\nContent-Type:", sIndex);
                                if (eIndex < 0) {
                                    eIndex = content.length();
                                }
                                while (eIndex > 0 && content.charAt(--eIndex) != '\n') {
                                }
                                return ((Pattern)this.arg).matcher(content.substring(sIndex, eIndex)).matches();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Exception converting message content to String: " + e), (Throwable)e);
                    }
                    break;
                }
            }
            return false;
        }

        private String getContentAsString(SipServletMessage msg) {
            try {
                Object content = msg.getContent();
                if (content instanceof String) {
                    return (String)content;
                }
                if (content instanceof byte[]) {
                    return new String((byte[])content);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public String toString() {
            return (this.not && this.arg == null ? "!" : "") + (this.useReq ? "req." : "") + this.type.toString() + (this.name != null ? "/" + this.name : "") + (this.arg != null ? (this.not ? "!=" : "=") + this.arg : "") + (this.instance != 0 ? "/" + this.instance : "");
        }
    }

    private static enum ConditionType {
        TIMEOUT,
        COUNT,
        SOURCE,
        REQ,
        RESP,
        INITIAL,
        BRANCH,
        AUTH,
        METHOD,
        RURI,
        RCODE,
        RTEXT,
        HEADER,
        ALL_HEADER,
        BODY,
        BODYPART;

    }
}

