/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.ppm.mega.model;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.common.logging.client.Logger;
import java.net.MalformedURLException;
import java.net.URL;

public class Host {
    private String scheme;
    private String ccsHost;
    private String ccsIpOrFQDN;
    private int ccsPort;
    protected final Logger log = AsmLogger.getLogger(this.getClass());

    public Host() throws MalformedURLException {
        this.setCcsHostVariables();
    }

    public String getCcsHost() {
        return this.ccsHost;
    }

    public void setCcsHost(String host) {
        this.ccsHost = host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getCcsIpOrFQDN() {
        return this.ccsIpOrFQDN;
    }

    public void setCcsIpOrFQDN(String ipOrFQDN) {
        this.ccsIpOrFQDN = ipOrFQDN;
    }

    public int getCcsPort() {
        return this.ccsPort;
    }

    public void setCcsPort(int ccsPort) {
        this.ccsPort = ccsPort;
    }

    private void setCcsHostVariables() throws MalformedURLException {
        String fcn_name = "setCcsHostVariables";
        boolean isFinest = this.log.isFinestEnabled();
        URL url = null;
        this.ccsHost = DMUtilities.getMegaCoreConfigServerUrl();
        if (this.ccsHost == null) {
            this.log.error((Object)"setCcsHostVariables: DMUtilities.getMegaCoreConfigServerUrl() returned null, cannot invoke Mega REST API SW");
            return;
        }
        if (this.ccsHost.contains("\"")) {
            if (isFinest) {
                this.log.finest((Object)("Still need to delete quotes. ccsHost=[" + this.ccsHost + "]"));
            }
            String[] subdivide = this.ccsHost.split("\"");
            this.ccsHost = subdivide[1];
        }
        url = null;
        try {
            url = new URL(this.ccsHost);
            this.scheme = url.getProtocol();
            this.ccsIpOrFQDN = url.getHost();
            this.ccsPort = url.getPort();
        }
        catch (MalformedURLException e) {
            this.ccsHost = null;
            this.log.error((Object)("setCcsHostVariables: exception thrown parsing " + this.ccsHost), (Throwable)e);
            throw e;
        }
    }

    public String toString() {
        return "Host [scheme=" + this.scheme + ", ccsHost=" + this.ccsHost + ", ccsIpOrFQDN=" + this.ccsIpOrFQDN + ", ccsPort=" + this.ccsPort + "]";
    }
}

