/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.TrustMgmtUtil;
import com.avaya.common.logging.client.Logger;
import com.avaya.mgmt.trust.tmclient.service.TMServiceQuery;
import com.avaya.mgmt.trust.tmclient.service.TMServiceQueryFactory;
import com.avaya.ustore.CassandraSSLOptions;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;

public class JBossTrustMgmtUtil
extends TrustMgmtUtil {
    private static Logger log = AsmLogger.getLogger(JBossTrustMgmtUtil.class);
    protected static final String SYSTEM_PARAM_BOUNCY_CASTLE_DISABLE_CERTPATH = "org.bouncycastle.pkix.disable_certpath";
    protected static final String SYSTEM_PARAM_BOUNCY_CASTLE_RSA_ALLOW_MULTI_USE = "org.bouncycastle.rsa.allow_multi_use";
    protected static final String SYSTEM_PARAM_ASM_JBOSS_HOSTNAME_VERIFIER = "com.avaya.asm.trustmgmt.jbossHostnameVerifier";
    private static final String MGMT = "mgmt";
    private static final String JBOSS_USER = "jboss";
    private static final String JBOSS_SSHID = "/home/jboss/.ssh/id_rsa";
    private static final String TM_SERVICE_LOCATION = "/opt/Avaya/wildfly-24.0.0.Final/standalone/configuration/tm/";
    private static final String defaultServiceName = System.getProperty("com.avaya.asm.trustmgmt.serviceName", "mgmt");
    private static final String serviceLocation = System.getProperty("avaya.tm.home.dir", "/opt/Avaya/wildfly-24.0.0.Final/standalone/configuration/tm/");
    private TMServiceQueryFactory tmServiceFactory = new TMServiceQueryFactory();
    private static volatile JBossTrustMgmtUtil instance = null;

    private JBossTrustMgmtUtil() {
        String functionName = "JBossTrustMgmtUtil";
        boolean isFinerEnabled = log.isFinerEnabled();
        String hostnameVerifier = System.getProperty(SYSTEM_PARAM_ASM_JBOSS_HOSTNAME_VERIFIER, "ASM");
        this.setHostnameVerifier(hostnameVerifier);
        if (isFinerEnabled) {
            log.finer((Object)"JBossTrustMgmtUtil: leave. instantiated.");
        }
    }

    public static synchronized JBossTrustMgmtUtil getInstance() {
        if (instance == null) {
            instance = new JBossTrustMgmtUtil();
        }
        return instance;
    }

    @Override
    protected void initSystemParameters() {
        String functionName = "initSystemParameters";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"initSystemParameters: entered.");
        }
        super.initSystemParameters();
        this.setSystemPropertyIfNull(SYSTEM_PARAM_BOUNCY_CASTLE_DISABLE_CERTPATH, "true");
        this.setSystemPropertyIfNull(SYSTEM_PARAM_BOUNCY_CASTLE_RSA_ALLOW_MULTI_USE, "true");
        if (isFinerEnabled) {
            log.finer((Object)"initSystemParameters: leave.");
        }
    }

    @Override
    protected byte[] getStoragePassword() {
        return this.getStoragePassword(defaultServiceName, JBOSS_USER, JBOSS_SSHID, TM_SERVICE_LOCATION);
    }

    private byte[] getStoragePassword(String tmServiceName, String tmServiceUser, String sshId, String tmConfLocation) {
        String functionName = "getStoragePassword";
        boolean isFinerEnabled = log.isFinerEnabled();
        byte[] result = null;
        try {
            TMServiceQuery serviceQuery = this.tmServiceFactory.getTMServiceQuery(tmServiceName, tmConfLocation);
            String keyStorePassword = serviceQuery.getKeyStorePassword(tmServiceUser, sshId);
            if (keyStorePassword != null) {
                result = keyStorePassword.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            log.error((Object)("getStoragePassword: Could not retrieve password." + e));
        }
        if (isFinerEnabled) {
            if (result != null) {
                log.finer((Object)("getStoragePassword: leave. result.length=" + result.length));
            } else {
                log.finer((Object)"getStoragePassword: leave. result=null");
            }
        }
        return result;
    }

    @Override
    protected String getKeyStorePassword() {
        return this.getKeyStorePassword(defaultServiceName);
    }

    protected String getKeyStorePassword(String serviceName) {
        String functionName = "getKeyStorePassword";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String result = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            String defaultAuthUser = query.getDefaultAuthUser();
            String defaultAuthPassKey = query.getDefaultAuthPasskey();
            result = query.getKeyStorePassword(defaultAuthUser, defaultAuthPassKey);
        }
        catch (Exception e) {
            log.error((Object)("getKeyStorePassword: Can't get keyStorePassword. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinerEnabled) {
            if (result != null) {
                log.finer((Object)("getKeyStorePassword: leave. result.length()=" + result.length() + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            } else {
                log.finer((Object)("getKeyStorePassword: leave. result=null serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            }
        }
        return result;
    }

    @Override
    public String getKeyStorePath() {
        return this.getKeyStorePath(defaultServiceName);
    }

    protected String getKeyStorePath(String serviceName) {
        String functionName = "getKeyStorePath";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String keyStorePath = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            keyStorePath = query.getKeyStorePath();
        }
        catch (Exception e) {
            log.error((Object)("getKeyStorePath: Can't get keyStorePath. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinerEnabled) {
            log.finer((Object)("getKeyStorePath: leave. keystorePath=" + keyStorePath + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return keyStorePath;
    }

    @Override
    public String getKeyStoreType() {
        return this.getKeyStoreType(defaultServiceName);
    }

    protected String getKeyStoreType(String serviceName) {
        String functionName = "getKeyStoreType";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String keyStoreType = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            keyStoreType = query.getKeyStoreType();
        }
        catch (Exception e) {
            log.error((Object)("getKeyStoreType: Can't get keyStoreType. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinerEnabled) {
            log.finer((Object)("getKeyStoreType: leave. keyStoreType=" + keyStoreType + ", serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return keyStoreType;
    }

    @Override
    protected String getTrustStorePassword() {
        return this.getTrustStorePassword(defaultServiceName);
    }

    protected String getTrustStorePassword(String serviceName) {
        String functionName = "getTrustStorePassword";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String result = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            String defaultAuthUser = query.getDefaultAuthUser();
            String defaultAuthPassKey = query.getDefaultAuthPasskey();
            result = query.getTrustStorePassword(defaultAuthUser, defaultAuthPassKey);
        }
        catch (Exception e) {
            log.error((Object)("getTrustStorePassword: Can't get trustStore Password. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinerEnabled) {
            if (result != null) {
                log.finer((Object)("getTrustStorePassword: leave. result.length()=" + result.length() + ", serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            } else {
                log.finer((Object)("getTrustStorePassword: leave. result=null, serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            }
        }
        return result;
    }

    @Override
    public String getTrustStorePath() {
        return this.getTrustStorePath(defaultServiceName);
    }

    public String getTrustStorePath(String serviceName) {
        String functionName = "getTruststorePath";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String trustStorePath = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            trustStorePath = query.getTrustStorePath();
        }
        catch (Exception e) {
            log.error((Object)("getTruststorePath: Can't get trustStore Path. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinerEnabled) {
            log.finer((Object)("getTruststorePath: leave. trustStorePath=" + trustStorePath + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return trustStorePath;
    }

    @Override
    public String getTrustStoreType() {
        return this.getTrustStoreType(defaultServiceName);
    }

    public String getTrustStoreType(String serviceName) {
        String functionName = "getTrustStoreType";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String trustStoreType = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            trustStoreType = query.getTrustStoreType();
        }
        catch (Exception e) {
            log.error((Object)("getTrustStoreType: Can't get trustStoreType. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinerEnabled) {
            log.finer((Object)("getTrustStoreType: leave. trustStoreType=" + trustStoreType + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return trustStoreType;
    }

    @Override
    protected SSLContext getSSLContext() {
        String functionName = "getSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"getSSLContext: entered.");
        }
        boolean useRevocationAwareSSLContext = true;
        return this.createSSLContext(defaultServiceName, true);
    }

    @Override
    public CassandraSSLOptions getSSLOptions() {
        String functionName = "getSSLOptions";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"getSSLOptions: entered.");
        }
        boolean useRevocationAwareSSLContext = true;
        return this.getSSLOptions(true);
    }

    public SSLContext createSSLContext(String serviceName, boolean useRevocationAwareSSLContext) {
        String functionName = "createSSLContext";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("createSSLContext: entered. serviceName=" + serviceName + ", useRevocationAwareSSLContext=" + useRevocationAwareSSLContext));
        }
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String trustStorePath = this.getTrustStorePath(serviceName);
        String trustStoreType = this.getTrustStoreType(serviceName);
        String trustStoreProvider = this.getTrustStoreProvider();
        String trustStorePassword = this.getTrustStorePassword(serviceName);
        String keyStorePath = this.getKeyStorePath(serviceName);
        String keyStoreType = this.getKeyStoreType(serviceName);
        String keyStoreProvider = this.getKeyStoreProvider();
        String keyStorePassword = this.getKeyStorePassword(serviceName);
        SSLContext sslContext = this.createSSLContext(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, useRevocationAwareSSLContext);
        return sslContext;
    }

    @Override
    protected SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance("NONCEandIV");
    }

    @Override
    public String getSecuritySystemParametersAsString() {
        return this.getSystemParameterAsString(SYSTEM_PARAM_BOUNCY_CASTLE_DISABLE_CERTPATH) + ", " + this.getSystemParameterAsString(SYSTEM_PARAM_BOUNCY_CASTLE_RSA_ALLOW_MULTI_USE) + ", " + super.getSecuritySystemParametersAsString();
    }
}

