/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.helpers.PostgresConnectionInfo;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.asm.datamgr.objectapi.ppm.ContactAddress;
import com.avaya.asm.datamgr.objectapi.ppm.ContactAddressLists;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.AddressData;
import com.avaya.ustore.objectapi.ContactListMemberData;
import com.avaya.ustore.objectapi.StationData;
import com.avaya.ustore.objectapi.UserData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class CommonDBUtils {
    private static final Logger log = AsmLogger.getLogger(CommonDBUtils.class);
    private ConnectionMgr connMgr = null;
    private Map<String, Long> contactAddressTypesByName = new HashMap<String, Long>();
    private Map<Long, String> contactAddressTypesById = new HashMap<Long, String>();
    private Map<String, Long> contactAddressCategoriesByName = new HashMap<String, Long>();
    private Map<Long, String> contactAddressCategoriesById = new HashMap<Long, String>();
    private Map<String, Long> handleTypesByName = new HashMap<String, Long>();
    private Map<Long, String> handleTypesById = new HashMap<Long, String>();
    private Map<Long, String> handleSubtypesById = new HashMap<Long, String>();
    protected static final String csPrivateContactInfoIds = "csprivatecontactinfoid";
    protected static final String csContactIds = " cscontactid ";
    protected static final String selectContactAddresses = "SELECT id, cscontactid, csprivatecontactinfoid, address, altlabel, label, cscontactaddresscategoryid, cscontactaddresstypeid, updatedatetime FROM cscontactaddress ";
    protected static final String getContactAddressById = "SELECT id, cscontactid, csprivatecontactinfoid, address, altlabel, label, cscontactaddresscategoryid, cscontactaddresstypeid, updatedatetime FROM cscontactaddress WHERE id IN ";
    protected static final String selectTypes = "SELECT id, name FROM ";
    protected static final String selectHandles = "SELECT hdl.id, hdl.handle, hdl.csdomainid, hdl.credential, hdl.cscommprofilesetid, hdl.cshandletypeid, hdl.cshandlesubtypeid FROM cshandle hdl, cscommprofileset cpset WHERE hdl.cscommprofilesetid = cpset.id AND cpset.csuserid = ";
    protected static final String selectDomains = "SELECT id, domainname FROM csdomain";
    protected static final String selectContactInfo = "SELECT displayname, givenname, surname, displaynameascii, givennameascii, surnameascii, preferredgivenname, preferredlanguage FROM cscontact WHERE id = ";
    protected static final String selectUserInfo = "SELECT displayname, givenname, surname, displaynameascii, givennameascii, surnameascii, preferredlanguage, managername, isdeleted, loginname FROM csuser WHERE id = ";
    protected static final String selectAddressInfoForUser = "SELECT addr.name, addr.id, addr.street, addr.building, addr.localityname, addr.stateorprovince, addr.country, addr.postalcode, addr.room FROM csuser usr, csuseraddressassign assign, csaddress addr WHERE usr.id = assign.cspersonid AND assign.csaddressid = addr.id and usr.id = ";
    protected static final String selectAddressInfoForContact = "SELECT addr.name, addr.id, addr.street, addr.building, addr.localityname, addr.stateorprovince, addr.country, addr.postalcode, addr.room FROM cscontact cont, csuseraddressassign assign, csaddress addr WHERE cont.id = assign.cspersonid AND assign.csaddressid = addr.id and cont.id = ";
    protected static final String selectCLMInfo = "SELECT isfavourite, ispresencebuddy, isspeeddial, cshandleid, cscontactaddressid FROM cscontactlistmember WHERE id = ";
    protected static final String selectPrivateContactAliasInfo_Part1 = "SELECT displayname FROM csprivatecontactinfo WHERE ownerid = ";
    protected static final String selectPrivateContactAliasInfo_Part2 = " AND cspersonid = ";
    protected static final String selectStationData = "SELECT sta.is_ipvideosoftphone, ext.extension FROM cscommprofile cs_cp, csuser usr, cscommprofileset cs_cpset, cmcommprofile cm_cp, ipt_station sta, ipt_extension ext WHERE sta.extension_id = ext.id AND cm_cp.station_id = sta.id AND cs_cp.commprofiletype = 'CM' AND cs_cp.id = cm_cp.id AND cs_cp.cscommprofilesetid = cs_cpset.id AND cs_cpset.id = usr.defaultcommprofilesetid AND usr.id = ";

    public CommonDBUtils(PostgresConnectionInfo pConnInfo) {
        DataSource ds = pConnInfo.getDataSource();
        this.connMgr = ds == null ? new DriverManagerConnectionMgr(pConnInfo) : new DataSourceConnectionMgr(pConnInfo.getDataSource());
    }

    public UserData getCsUserInfo(Long csuserId) throws SQLException, DMException {
        UserData userData = null;
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getCsUserInfo";
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectUserInfo + csuserId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsUser");
        boolean rowFound = false;
        try {
            while (rs.next()) {
                if (rowFound) {
                    throw new DMException("getCsUserInfo: multiple csuser table rows were returned from the DB.");
                }
                userData = new UserData(rs.getString("displayname"), rs.getString("givenname"), rs.getString("surname"), rs.getString("displaynameascii"), rs.getString("givennameascii"), rs.getString("surnameascii"), null, rs.getString("preferredlanguage"), rs.getString("managername"), rs.getBoolean("isdeleted"), rs.getString("loginname"));
                rowFound = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("getCsUserInfo: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getCsUserInfo: SQL query for csuser, for user " + csuserId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return userData;
    }

    public UserData getCsContactInfo(Long cscontactId) throws SQLException, DMException {
        UserData userData = null;
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getCsContactInfo";
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectContactInfo + cscontactId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsContact");
        boolean rowFound = false;
        try {
            while (rs.next()) {
                if (rowFound) {
                    throw new DMException("getCsContactInfo: multiple cscontact table rows were returned from the DB.");
                }
                userData = new UserData(rs.getString("displayname"), rs.getString("givenname"), rs.getString("surname"), rs.getString("displaynameascii"), rs.getString("givennameascii"), rs.getString("surnameascii"), rs.getString("preferredgivenname"), rs.getString("preferredlanguage"), null, false, null);
                rowFound = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("getCsContactInfo: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getCsContactInfo: SQL query for cscontact, for contact " + cscontactId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return userData;
    }

    public ContactAddressLists getAllContactAddressesForContact(List<Long> contactIdList, List<Long> pciIdList) throws SQLException {
        ContactAddressLists contactAddressLists = null;
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        String fcn_name = "getAllContactAddressesForContact";
        if (isFiner) {
            log.finer((Object)("getAllContactAddressesForContact: enter with contactIdList: " + contactIdList + " and with pciIdList: " + pciIdList));
        }
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectContactAddresses);
        boolean dataFound = false;
        boolean addRParen = false;
        if (contactIdList != null && !contactIdList.isEmpty()) {
            sqlQuery.append("WHERE");
            sqlQuery.append(" (");
            addRParen = true;
            sqlQuery.append(csContactIds);
            sqlQuery.append(" IN ");
            this.buildIdList(sqlQuery, contactIdList);
            dataFound = true;
        }
        if (pciIdList != null && !pciIdList.isEmpty()) {
            if (dataFound) {
                sqlQuery.append(" OR ");
            } else {
                sqlQuery.append("WHERE");
                sqlQuery.append(" (");
                addRParen = true;
                dataFound = true;
            }
            sqlQuery.append(csPrivateContactInfoIds);
            sqlQuery.append(" IN ");
            this.buildIdList(sqlQuery, pciIdList);
        }
        if (addRParen) {
            sqlQuery.append(" )");
        }
        if (!dataFound) {
            if (isFinest) {
                log.finest((Object)"getAllContactAddressesForContact: no private or external contacts to query.");
            }
            this.closeResources(conn, st, rs, sqlQuery);
            return new ContactAddressLists();
        }
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsContactAddress");
        try {
            contactAddressLists = new ContactAddressLists();
            Map<Long, List<ContactAddress>> pciCaMap = contactAddressLists.getPciList();
            Map<Long, List<ContactAddress>> contactCaMap = contactAddressLists.getCscontactList();
            while (rs.next()) {
                ContactAddress contactAddress = new ContactAddress(rs.getLong("id"), rs.getLong("cscontactid"), rs.getLong(csPrivateContactInfoIds), rs.getString("address"), rs.getString("altlabel"), rs.getString("label"), rs.getInt("cscontactaddresscategoryid"), rs.getInt("cscontactaddresstypeid"), rs.getTimestamp("updatedatetime"));
                if (contactAddress == null) continue;
                Map<Long, List<ContactAddress>> caMap = null;
                Long id = null;
                if (contactAddress.getCsprivatecontactinfoid() != 0L) {
                    id = contactAddress.getCsprivatecontactinfoid();
                    caMap = pciCaMap;
                } else {
                    id = contactAddress.getCscontactid();
                    caMap = contactCaMap;
                }
                List<ContactAddress> caList = caMap.get(id);
                if (caList == null) {
                    caList = new ArrayList<ContactAddress>();
                    caMap.put(id, caList);
                }
                caList.add(contactAddress);
            }
        }
        catch (SQLException e) {
            log.error((Object)("getAllContactAddressesForContact: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFinest) {
            log.finest((Object)("getAllContactAddressesForContact: SQL query for cscontactaddress, IDs in " + contactIdList + " and " + pciIdList + " found cscontact data:" + (contactAddressLists.getCscontactList().keySet() != null && !contactAddressLists.getCscontactList().keySet().isEmpty() ? contactAddressLists.getCscontactList() : null) + " and csprivatecontactinfo data: " + (contactAddressLists.getPciList().keySet() != null && !contactAddressLists.getPciList().keySet().isEmpty() ? contactAddressLists.getPciList() : null) + ", and took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return contactAddressLists;
    }

    protected void buildIdList(StringBuilder sqlQuery, List<Long> ids) {
        sqlQuery.append("(");
        boolean isFirst = true;
        for (long id : ids) {
            if (isFirst) {
                isFirst = false;
            } else {
                sqlQuery.append(",");
            }
            sqlQuery.append(id);
        }
        sqlQuery.append(")");
    }

    public void getSpecificCpdTypes(String enumType) throws SQLException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getSpecificCpdTypes";
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectTypes + enumType);
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, enumType.toString());
        try {
            while (rs.next()) {
                if (enumType.equals("cscontacttypeenum ")) {
                    this.contactAddressTypesByName.put(rs.getString("name"), rs.getLong("id"));
                    this.contactAddressTypesById.put(rs.getLong("id"), rs.getString("name"));
                    continue;
                }
                if (enumType.equals("cscontactcategoryenum ")) {
                    this.contactAddressCategoriesByName.put(rs.getString("name"), rs.getLong("id"));
                    this.contactAddressCategoriesById.put(rs.getLong("id"), rs.getString("name"));
                    continue;
                }
                if (enumType.equals("cshandletypeenum ")) {
                    this.handleTypesByName.put(rs.getString("name"), rs.getLong("id"));
                    this.handleTypesById.put(rs.getLong("id"), rs.getString("name"));
                    continue;
                }
                if (enumType.equals("cshandlesubtypeenum ")) {
                    this.handleSubtypesById.put(rs.getLong("id"), rs.getString("name"));
                    continue;
                }
                log.error((Object)("getSpecificCpdTypes: Bad enumType: " + enumType));
            }
        }
        catch (SQLException e) {
            log.error((Object)("getSpecificCpdTypes: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            if (enumType.equals("cscontacttypeenum ")) {
                if (isFiner) {
                    log.finer((Object)("getSpecificCpdTypes: SQL query for contact address types found: " + this.contactAddressTypesByName.toString() + " and " + this.contactAddressTypesById.toString() + " and took " + (System.nanoTime() - nanos) + " nsec."));
                }
            } else if (enumType.equals("cscontactcategoryenum ")) {
                if (isFiner) {
                    log.finer((Object)("getSpecificCpdTypes: SQL query for contact address categories found: " + this.contactAddressCategoriesByName.toString() + " and " + this.contactAddressCategoriesById.toString() + " and took " + (System.nanoTime() - nanos) + " nsec."));
                }
            } else if (enumType.equals("cshandletypeenum ")) {
                if (isFiner) {
                    log.finer((Object)("getSpecificCpdTypes: SQL query for handle types found: " + this.handleTypesByName.toString() + " and " + this.handleTypesById.toString() + " and took " + (System.nanoTime() - nanos) + " nsec."));
                }
            } else if (enumType.equals("cshandlesubtypeenum ") && isFiner) {
                log.finer((Object)("getSpecificCpdTypes: SQL query for handle subtypes found: " + this.handleSubtypesById.toString() + " and took " + (System.nanoTime() - nanos) + " nsec."));
            }
        }
    }

    public List<Long> getSpecificCpdTypeIds(List<String> cpdTypeStrings) {
        String fcn_name = "getSpecificCpdTypeIds";
        boolean isFiner = log.isFinerEnabled();
        ArrayList<Long> cpdTypeIds = new ArrayList<Long>();
        for (String cpdTypeString : cpdTypeStrings) {
            if (this.contactAddressTypesByName.containsKey(cpdTypeString)) {
                cpdTypeIds.add(this.contactAddressTypesByName.get(cpdTypeString));
            }
            if (!this.handleTypesByName.containsKey(cpdTypeString)) continue;
            cpdTypeIds.add(this.handleTypesByName.get(cpdTypeString));
        }
        if (isFiner) {
            log.finer((Object)("getSpecificCpdTypeIds: cpdTypeIds found: " + ((Object)cpdTypeIds).toString()));
        }
        return cpdTypeIds;
    }

    public String getSpecificContactAddressTypeName(Long typeId) {
        String fcn_name = "getSpecificContactAddressTypeName";
        boolean isFiner = log.isFinerEnabled();
        if (this.contactAddressTypesById.containsKey(typeId)) {
            String typeName = this.contactAddressTypesById.get(typeId);
            if (isFiner) {
                log.finer((Object)("getSpecificContactAddressTypeName: contact address typeName found: " + typeName));
            }
            return typeName;
        }
        return null;
    }

    public String getSpecificContactAddressCategoryName(Long typeId) {
        String fcn_name = "getSpecificContactAddressCategoryName";
        boolean isFiner = log.isFinerEnabled();
        if (this.contactAddressCategoriesById.containsKey(typeId)) {
            String categoryName = this.contactAddressCategoriesById.get(typeId);
            if (isFiner) {
                log.finer((Object)("getSpecificContactAddressCategoryName: contact address categoryName found: " + categoryName));
            }
            return categoryName;
        }
        return null;
    }

    public List<Long> getSpecificHandleTypeIds(List<String> handleTypeStrings) {
        String fcn_name = "getSpecificHandleTypeIds";
        boolean isFiner = log.isFinerEnabled();
        ArrayList<Long> handleTypeIds = new ArrayList<Long>();
        for (String handleTypeString : handleTypeStrings) {
            if (!this.handleTypesByName.containsKey(handleTypeString)) continue;
            handleTypeIds.add(this.handleTypesByName.get(handleTypeString));
        }
        if (isFiner) {
            log.finer((Object)("getSpecificHandleTypeIds: handleTypeIds found: " + ((Object)handleTypeIds).toString()));
        }
        return handleTypeIds;
    }

    public String getSpecificHandleTypeName(Long typeId) {
        String fcn_name = "getSpecificHandleTypeName";
        boolean isFiner = log.isFinerEnabled();
        if (this.handleTypesById.containsKey(typeId)) {
            String typeName = this.handleTypesById.get(typeId);
            if (isFiner) {
                log.finer((Object)("getSpecificHandleTypeName: handle typeName found: " + typeName));
            }
            return typeName;
        }
        return null;
    }

    public String getSpecificHandleSubtypeName(Long subtypeId) {
        String fcn_name = "getSpecificHandleSubtypeName";
        boolean isFiner = log.isFinerEnabled();
        if (this.handleSubtypesById.containsKey(subtypeId)) {
            String subtypeName = this.handleSubtypesById.get(subtypeId);
            if (isFiner) {
                log.finer((Object)("getSpecificHandleSubtypeName: handle subtypeName found: " + subtypeName));
            }
            return subtypeName;
        }
        return null;
    }

    public List<CsHandle> getAllHandlesForContact(Long csuserId) throws SQLException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getAllHandlesForContact";
        ArrayList<CsHandle> cshandleList = null;
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectHandles + csuserId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsHandle");
        try {
            cshandleList = new ArrayList<CsHandle>();
            while (rs.next()) {
                CsHandle cshandle = new CsHandle(rs.getLong("id"), rs.getString("handle"), rs.getLong("csdomainid"), rs.getString("credential"), rs.getLong("cscommprofilesetid"), rs.getLong("cshandletypeid"), rs.getLong("cshandlesubtypeid"));
                cshandleList.add(cshandle);
            }
        }
        catch (SQLException e) {
            log.error((Object)("getAllHandlesForContact: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getAllHandlesForContact: SQL query for cshandle, for user " + csuserId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return cshandleList;
    }

    public Map<Long, String> getAllCsDomains() throws SQLException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getAllCsDomains";
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectDomains);
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsDomain");
        HashMap<Long, String> csDomainMap = new HashMap<Long, String>();
        try {
            while (rs.next()) {
                csDomainMap.put(rs.getLong("id"), rs.getString("domainname"));
            }
        }
        catch (SQLException e) {
            log.error((Object)("getAllCsDomains: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getAllCsDomains: SQL query for csdomain found: " + ((Object)csDomainMap).toString() + " and took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return csDomainMap;
    }

    public Map<String, AddressData> getCsAddressInfo(Long cspersonId, boolean isInternalContact) throws SQLException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getCsAddressInfo";
        HashMap<String, AddressData> addressData = new HashMap<String, AddressData>();
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder((isInternalContact ? selectAddressInfoForUser : selectAddressInfoForContact) + cspersonId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsAddress");
        try {
            while (rs.next()) {
                AddressData addrData = new AddressData(rs.getLong("id"), rs.getString("street"), null, rs.getString("building"), rs.getString("localityname"), rs.getString("stateorprovince"), rs.getString("country"), rs.getString("postalcode"), null, rs.getString("room"), null);
                addressData.put(rs.getString("name"), addrData);
            }
        }
        catch (SQLException e) {
            log.error((Object)("getCsAddressInfo: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getCsAddressInfo: SQL query for csaddress, for user/contact " + cspersonId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return addressData;
    }

    public ContactListMemberData getClmInfoForContact(Long clmId) throws SQLException, DMException {
        ContactListMemberData clmData = new ContactListMemberData(false, false, false, null, null);
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getClmInfoForContact";
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        StringBuilder sqlQuery = new StringBuilder(selectCLMInfo + clmId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsContactListMember");
        boolean rowFound = false;
        try {
            while (rs.next()) {
                if (rowFound) {
                    throw new DMException("getClmInfoForContact: multiple cscontactlistmember table rows were returned from the DB.");
                }
                clmData = new ContactListMemberData(rs.getBoolean("isfavourite"), rs.getBoolean("ispresencebuddy"), rs.getBoolean("isspeeddial"), rs.getLong("cshandleid"), rs.getLong("cscontactaddressid"));
                rowFound = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("getClmInfoForContact: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getClmInfoForContact: SQL query for cscontactlistmember, for clmId " + clmId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return clmData;
    }

    public String getAliasFromCsPrivateContactInfo(Long ownercsuserId, Long csuserId) throws SQLException, DMException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getAliasFromCsPrivateContactInfo";
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        String alias = null;
        StringBuilder sqlQuery = new StringBuilder(selectPrivateContactAliasInfo_Part1 + ownercsuserId.toString() + selectPrivateContactAliasInfo_Part2 + csuserId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "CsPrivateContactInfo");
        boolean rowFound = false;
        try {
            while (rs.next()) {
                if (rowFound) {
                    throw new DMException("getAliasFromCsPrivateContactInfo: multiple csprivatecontactinfo table rows were returned from the DB.");
                }
                alias = rs.getString("displayname");
                rowFound = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("getAliasFromCsPrivateContactInfo: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getAliasFromCsPrivateContactInfo: SQL query for csprivatecontactinfo, for ownercsuserId: " + ownercsuserId + " and for csuserId: " + csuserId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return alias;
    }

    public StationData getStationDataFromCsUserId(Long csuserId) throws SQLException, DMException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "getStationDataFromCsUserId";
        StationData stationData = new StationData(null, false);
        ResultSet rs = null;
        Connection conn = this.connMgr.getConnection();
        Statement st = this.createStatement(conn);
        Object alias = null;
        StringBuilder sqlQuery = new StringBuilder(selectStationData + csuserId.toString());
        long nanos = 0L;
        if (isFiner) {
            nanos = System.nanoTime();
        }
        rs = this.executeSqlQuery(conn, st, sqlQuery, "Ipt_Station and Ipt_Extension");
        boolean rowFound = false;
        try {
            while (rs.next()) {
                if (rowFound) {
                    throw new DMException("getStationDataFromCsUserId: multiple ipt_station/ipt_extension table rows were returned from the DB.");
                }
                String extension = rs.getString("extension");
                stationData.setStationExtension(extension != null ? extension : "");
                stationData.setVideoCapable(rs.getBoolean("is_ipvideosoftphone"));
                rowFound = true;
            }
        }
        catch (SQLException e) {
            log.error((Object)("getStationDataFromCsUserId: SQLException received for rs operation: " + sqlQuery.toString() + " : " + e));
            throw e;
        }
        finally {
            this.closeResources(conn, st, rs, sqlQuery);
        }
        if (isFiner) {
            log.finer((Object)("getStationDataFromCsUserId: SQL query for ipt_station/ipt_extension, for csuserId: " + csuserId + " took " + (System.nanoTime() - nanos) + " nsec."));
        }
        return stationData;
    }

    private Statement createStatement(Connection conn) throws SQLException {
        String fcn_name = "createStatement";
        Statement st = null;
        try {
            st = conn.createStatement();
        }
        catch (SQLException e) {
            log.error((Object)("createStatement: SQLException received for createStatement: " + e));
            throw e;
        }
        return st;
    }

    private ResultSet executeSqlQuery(Connection conn, Statement st, StringBuilder sqlQuery, String queryType) throws SQLException {
        String fcn_name = "executeSqlQuery";
        boolean isFinest = log.isFinestEnabled();
        try {
            String dbQuery = sqlQuery.toString();
            if (isFinest) {
                log.finest((Object)("executeSqlQuery: " + queryType + " QUERY: " + sqlQuery));
            }
            return st.executeQuery(dbQuery);
        }
        catch (SQLException e) {
            log.error((Object)("executeSqlQuery: SQLException received for executeQuery: " + sqlQuery.toString() + " : " + e));
            try {
                st.close();
            }
            catch (SQLException e1) {
                log.error((Object)("executeSqlQuery: SQLException received for st.close: " + sqlQuery.toString() + " : " + e));
            }
            this.connMgr.rlsConnection(conn);
            throw e;
        }
    }

    private void closeResources(Connection conn, Statement st, ResultSet rs, StringBuilder sqlQuery) {
        String fcn_name = "closeResources";
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("closeResources: Exception received for rs.close: " + sqlQuery.toString() + " : " + e));
        }
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception e) {
            log.error((Object)("closeResources: Exception received for st.close: " + sqlQuery.toString() + " : " + e));
        }
        try {
            this.connMgr.rlsConnection(conn);
        }
        catch (SQLException e) {
            log.error((Object)("closeResources: Exception received for connMgr.rlsConnection: " + sqlQuery.toString() + " : " + e));
        }
    }

    protected class DataSourceConnectionMgr
    implements ConnectionMgr {
        private DataSource ds;

        public DataSourceConnectionMgr(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.ds.getConnection();
        }

        @Override
        public void rlsConnection(Connection conn) throws SQLException {
            conn.close();
        }
    }

    protected class DriverManagerConnectionMgr
    implements ConnectionMgr {
        private Connection db;

        public DriverManagerConnectionMgr(PostgresConnectionInfo pConnInfo) {
            String fcn_name = "DriverManagerConnectionMgr";
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("DriverManagerConnectionMgr: ClassNotFoundException received: " + e));
                return;
            }
            try {
                this.db = DriverManager.getConnection(pConnInfo.getUrl(), pConnInfo.getUser(), pConnInfo.getPassword());
            }
            catch (SQLException e) {
                log.error((Object)("DriverManagerConnectionMgr: SQLException received: " + e));
                return;
            }
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.db;
        }

        @Override
        public void rlsConnection(Connection conn) throws SQLException {
        }
    }

    protected static interface ConnectionMgr {
        public Connection getConnection() throws SQLException;

        public void rlsConnection(Connection var1) throws SQLException;
    }
}

