/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraUtils;
import com.avaya.ustore.UStoreCommonConstants;
import com.avaya.ustore.VersionHelper;
import com.avaya.ustore.objectapi.SMInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SMInfoUtils {
    private static final Logger log = AsmLogger.getLogger(SMInfoUtils.class);
    protected static CassandraUtils cassandraUtils;

    public SMInfoUtils() {
        cassandraUtils = new CassandraUtils();
    }

    public VersionHelper getMinSMVersion() {
        HashMap<Long, Instance> smInstances;
        ArrayList<SMInfo> smInfos;
        List<String> hostAddresses;
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        String fcn_name = "getMinSMVersion";
        if (isFiner) {
            log.finer((Object)"getMinSMVersion: enter");
        }
        if ((hostAddresses = cassandraUtils.loadSMInfoAsmInst(smInfos = new ArrayList<SMInfo>(), smInstances = new HashMap<Long, Instance>())) == null || hostAddresses.isEmpty()) {
            return null;
        }
        VersionHelper minVersion = null;
        VersionHelper smVersion = new VersionHelper();
        for (Instance inst : smInstances.values()) {
            String instName;
            long instId = inst.getId();
            if (inst.isBranch()) {
                if (!isFinest) continue;
                log.finest((Object)("getMinSMVersion: skipping a BSM: " + SMInfoUtils.instanceString(inst)));
                continue;
            }
            if (isFinest) {
                log.finest((Object)("getMinSMVersion: checking asmInstId=" + instId));
            }
            if (!hostAddresses.contains(instName = inst.getManagementAccessPointHostName())) {
                if (!isFinest) continue;
                log.finest((Object)("getMinSMVersion: instance =" + instName + ", is not present into Hosts list "));
                continue;
            }
            SMInfo smInfo = cassandraUtils.getSMInfo(smInfos, instId);
            if (smInfo == null || smInfo.getSwVersion() == null) {
                if (isFinest) {
                    log.finest((Object)("getMinSMVersion: asmInstId " + instId + " not found in smInfos"));
                }
                if (minVersion == null) {
                    minVersion = new VersionHelper(UStoreCommonConstants.MIN_VERSION);
                    break;
                }
                minVersion.setVersion(UStoreCommonConstants.MIN_VERSION);
                break;
            }
            smVersion.setVersion(smInfo.getSwVersion());
            if (minVersion == null) {
                if (isFinest) {
                    log.finest((Object)("getMinSMVersion: instId=" + instId + ", minVersion is null, setting to " + smVersion));
                }
                minVersion = new VersionHelper(smVersion);
                continue;
            }
            if (smVersion.compareTo(minVersion) < 0) {
                if (isFinest) {
                    log.finest((Object)("getMinSMVersion: instId=" + instId + ", smVersion=" + smVersion + " is < minVersion= " + minVersion));
                }
                minVersion.setVersion(smVersion);
                continue;
            }
            if (!isFinest) continue;
            log.finest((Object)("getMinSMVersion: instId=" + instId + ", minVersion=" + minVersion + " is <= smVersion=" + smVersion));
        }
        if (isFiner) {
            log.finer((Object)("getMinSMVersion: leave, minVersion=" + minVersion));
        }
        return minVersion;
    }

    private static String instanceString(Instance inst) {
        StringBuilder sb = new StringBuilder();
        sb.append("[id=");
        sb.append(inst.getId());
        sb.append(", host=");
        sb.append(inst.getManagementAccessPointHostName());
        sb.append(']');
        return sb.toString();
    }
}

