/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.SMInfoUtils;
import com.avaya.ustore.VersionHelper;

public class SMVersionChecker {
    private final Logger log = AsmLogger.getLogger(SMVersionChecker.class);
    protected SMInfoUtils smInfoUtils = new SMInfoUtils();
    protected boolean minVersionCheck = false;
    protected static boolean isMega = DMUtilities.propertyFileExists() && DMUtilities.isMegaSM();
    private VersionHelper minRequiredSMVersion;

    public SMVersionChecker(String version) {
        this.minRequiredSMVersion = new VersionHelper(version);
        if (isMega) {
            this.minVersionCheck = true;
        }
    }

    public Boolean checkMinimumSMVersions() {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "checkMinimumSMVersions";
        if (isFiner) {
            this.log.finer((Object)("checkMinimumSMVersions: enter, minVersionCheck = " + this.minVersionCheck));
        }
        if (this.minVersionCheck) {
            return true;
        }
        VersionHelper minSMVersion = this.smInfoUtils.getMinSMVersion();
        if (minSMVersion == null) {
            if (isFiner) {
                this.log.finer((Object)"checkMinimumSMVersions: leave, cannot get Minumum SM Version, returning null.");
            }
            return null;
        }
        int rc = minSMVersion.compareTo(this.minRequiredSMVersion);
        if (rc >= 0) {
            this.minVersionCheck = true;
        }
        if (isFiner) {
            this.log.finer((Object)("checkMinimumSMVersions: leave , returning " + this.minVersionCheck + ", minRequiredSMVersion=" + this.minRequiredSMVersion + ", minSMVersion=" + minSMVersion));
        }
        return this.minVersionCheck;
    }
}

