/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;

public class VersionHelper
implements Comparable<VersionHelper> {
    private final Logger log = AsmLogger.getLogger(this.getClass());
    private int major;
    private int minor;
    private Integer revision;
    private Integer servicePack;

    public VersionHelper() {
        this.setVersion(0, 0, null, null);
    }

    public VersionHelper(int major, int minor, Integer revision) {
        this.setVersion(major, minor, revision, null);
    }

    public VersionHelper(int major, int minor, Integer revision, Integer servicePack) {
        this.setVersion(major, minor, revision, servicePack);
    }

    public VersionHelper(String versionString) {
        this.setVersion(versionString);
    }

    public VersionHelper(VersionHelper version) {
        this.setVersion(version);
    }

    public void setVersion(int major, int minor, Integer revision, Integer servicePack) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.servicePack = servicePack;
    }

    public void setVersion(String versionString) {
        int dashPos;
        String fcn_name = "setVersion";
        this.minor = 0;
        this.major = 0;
        this.revision = null;
        this.servicePack = null;
        if (versionString == null) {
            String msg = "setVersion: versionString is null";
            this.log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        String[] fields = versionString.split("\\.");
        if (fields.length < 2) {
            String msg = "setVersion: bad version string: " + versionString;
            this.log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        String field = fields[0];
        try {
            this.major = Integer.parseInt(field);
        }
        catch (NumberFormatException nfe) {
            String msg = "setVersion: bad major number: " + field;
            this.log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        field = fields[1];
        try {
            this.minor = Integer.parseInt(field);
        }
        catch (NumberFormatException nfe) {
            String msg = "setVersion: bad minor number: " + field;
            this.log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        if (fields.length > 2) {
            field = fields[2];
            dashPos = field.indexOf(45);
            if (dashPos >= 0) {
                field = field.substring(0, dashPos);
            }
            try {
                this.revision = Integer.parseInt(field);
            }
            catch (NumberFormatException nfe) {
                String msg = "setVersion: bad revision number: " + field;
                this.log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        } else {
            this.revision = null;
        }
        if (fields.length > 3) {
            field = fields[3];
            dashPos = field.indexOf(45);
            if (dashPos >= 0) {
                field = field.substring(0, dashPos);
            }
            try {
                this.servicePack = Integer.parseInt(field);
            }
            catch (NumberFormatException nfe) {
                String msg = "setVersion: bad servicePack number: " + field;
                this.log.error((Object)msg);
                throw new IllegalArgumentException(msg);
            }
        } else {
            this.servicePack = null;
        }
    }

    public void setVersion(VersionHelper version) {
        this.major = version.major;
        this.minor = version.minor;
        this.revision = version.revision;
        this.servicePack = version.servicePack;
    }

    public String asReleaseString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        if (this.revision != null) {
            sb.append('.');
            sb.append(this.revision);
        }
        if (this.servicePack != null) {
            sb.append('.');
            sb.append(this.servicePack);
        }
        return sb.toString();
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public Integer getServicePack() {
        return this.servicePack;
    }

    public void setServicePack(Integer servicePack) {
        this.servicePack = servicePack;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.log == null ? 0 : this.log.hashCode());
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        result = 31 * result + (this.servicePack == null ? 0 : this.servicePack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionHelper)) {
            return false;
        }
        VersionHelper other = (VersionHelper)obj;
        if (this.log == null ? other.log != null : !this.log.equals(other.log)) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.revision == null ? other.revision != null : !this.revision.equals(other.revision)) {
            return false;
        }
        return !(this.servicePack == null ? other.servicePack != null : !this.servicePack.equals(other.servicePack));
    }

    public String toString() {
        return "VersionHelper [major=" + this.major + ", minor=" + this.minor + ", revision=" + this.revision + ", servicePack=" + this.servicePack + "]";
    }

    @Override
    public int compareTo(VersionHelper other) {
        int otherSp;
        int otherRev;
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        int rev = this.revision == null ? 0 : this.revision;
        int n = otherRev = other.revision == null ? 0 : other.revision;
        if (rev < otherRev) {
            return -1;
        }
        if (rev > otherRev) {
            return 1;
        }
        int sp = this.servicePack == null ? 0 : this.servicePack;
        int n2 = otherSp = other.servicePack == null ? 0 : other.servicePack;
        if (sp < otherSp) {
            return -1;
        }
        if (sp > otherSp) {
            return 1;
        }
        return 0;
    }
}

