/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore.client;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.CustomClassLoadingUtil;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.client.UserStoreClient;
import com.avaya.ustore.client.UserStoreClientClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class UserStoreFactory {
    protected static volatile UserStoreClient usClient = null;
    protected static final Logger log = AsmLogger.getLogger(UserStoreFactory.class);
    protected static ClassLoader userStoreClientCL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserStoreClient getUserStoreRESTClient() {
        if (usClient != null) return usClient;
        Class<UserStoreFactory> clazz = UserStoreFactory.class;
        synchronized (UserStoreFactory.class) {
            if (usClient != null) return usClient;
            usClient = UserStoreFactory.createUserStoreRESTClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return usClient;
        }
    }

    public static void destroy() {
        if (usClient != null) {
            usClient.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized UserStoreClient createUserStoreRESTClient() {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        ClassLoader newCl = UserStoreFactory.getUserStoreClientCL();
        try {
            Thread.currentThread().setContextClassLoader(newCl);
            Object o = CustomClassLoadingUtil.load("com.avaya.ustore.client.UserStoreRESTClient", new Class[0], new Object[0], UserStoreFactory.getUserStoreClientCL());
            UserStoreClient userStoreClient = (UserStoreClient)o;
            return userStoreClient;
        }
        catch (Exception e) {
            log.error((Object)"createUserStoreRESTClient: Unable to create User Store Client", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        return null;
    }

    protected static synchronized ClassLoader getUserStoreClientCL() {
        if (userStoreClientCL == null) {
            userStoreClientCL = UserStoreFactory.createUserStoreClientClassLoader();
        }
        return userStoreClientCL;
    }

    protected static ClassLoader createUserStoreClientClassLoader() {
        try {
            File dynDir;
            if (log.isFinestEnabled()) {
                log.finest((Object)"Reloading all http client jars.");
            }
            if (!(dynDir = new File(UserStoreFactory.getHttpClientDir())).exists() || !dynDir.isDirectory()) {
                throw new IOException("Dynamic http client directory " + UserStoreFactory.getHttpClientDir() + " does not exist.");
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File f : dynDir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
                urls.add(f.toURI().toURL());
            }
            return new UserStoreClientClassLoader(urls.toArray(new URL[urls.size()]), UserStoreFactory.class.getClassLoader());
        }
        catch (Exception e) {
            log.warn((Object)"Exception thrown while loading http client jars.", (Throwable)e);
            return null;
        }
    }

    protected static String getHttpClientDir() {
        return "/opt/Avaya/CommonServerPlatform/lib/httpclient/";
    }
}

