/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgAssert {
    private ArgAssert() {
    }

    public static void assertTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T assertNotNull(T arg, String argName) {
        if (null == arg) {
            throw new IllegalArgumentException(ArgAssert.getNullErrorMessage(argName));
        }
        return arg;
    }

    static String getNullErrorMessage(String argName) {
        return argName + " is null.";
    }

    public static <T> T assertNotNull(T arg) {
        return ArgAssert.assertNotNull(arg, "Argument");
    }

    public static <T> Collection<T> assertNotEmpty(Collection<T> arg, String argName) {
        ArgAssert.assertNotNull(arg, argName);
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(ArgAssert.getEmptyErrorMessage(argName));
        }
        return arg;
    }

    private static String getEmptyErrorMessage(String argName) {
        return argName + " is empty.";
    }

    public static <T> Collection<T> assertNotEmpty(Collection<T> arg) {
        return ArgAssert.assertNotEmpty(arg, "Collection");
    }

    public static <K, V> Map<K, V> assertNotEmpty(Map<K, V> arg, String argName) {
        ArgAssert.assertNotNull(arg, argName);
        if (arg.isEmpty()) {
            throw new IllegalArgumentException(ArgAssert.getEmptyErrorMessage(argName));
        }
        return arg;
    }

    public static <K, V> Map<K, V> assertNotEmpty(Map<K, V> arg) {
        return ArgAssert.assertNotEmpty(arg, "Map");
    }

    public static String assertNotEmpty(String arg, String argName) {
        ArgAssert.assertNotNull(arg, argName);
        if ("".equals(arg)) {
            throw new IllegalArgumentException(ArgAssert.getEmptyErrorMessage(argName));
        }
        return arg;
    }

    public static String assertNotEmpty(String arg) {
        return ArgAssert.assertNotEmpty(arg, "String");
    }

    public static String assertNotBlank(String arg, String argName) {
        if (StringUtils.isBlank((CharSequence)arg)) {
            throw new IllegalArgumentException(argName + " is blank");
        }
        return arg;
    }

    public static String assertNotBlank(String arg) {
        return ArgAssert.assertNotBlank(arg, "String");
    }

    public static <T extends Number> T assertZeroOrPositive(T arg, String argName) {
        ArgAssert.assertNotNull(arg, argName);
        Double d = arg.doubleValue();
        if (!(d >= 0.0)) {
            throw new IllegalArgumentException(argName + " is neither zero nor positive (" + arg + ")");
        }
        return arg;
    }

    public static <T extends Number> T assertZeroOrPositive(T arg) {
        return ArgAssert.assertZeroOrPositive(arg, "Number");
    }

    public static <T extends Number> T assertPositive(T arg, String argName) {
        ArgAssert.assertNotNull(arg, argName);
        Double d = arg.doubleValue();
        if (!(d > 0.0)) {
            throw new IllegalArgumentException(argName + " is not positive (" + arg + ")");
        }
        return arg;
    }

    public static <T extends Number> T assertPositive(T arg) {
        return ArgAssert.assertPositive(arg, "Number");
    }
}

