/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.encrypt;

import com.avaya.zephyr.encrypt.EncryptDecryptException;
import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class EncryptDecrypt {
    private static final String ALGORITHM = "AES";
    private static final String SHA = "SHA";

    private EncryptDecrypt() {
    }

    public static String encrypt(String valueToEnc, String keyValue) throws EncryptDecryptException {
        try {
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, EncryptDecrypt.generateKey(keyValue));
            if (valueToEnc == null) {
                valueToEnc = "";
            }
            byte[] encValue = c.doFinal(valueToEnc.getBytes());
            return new BASE64Encoder().encode(encValue);
        }
        catch (Exception e) {
            throw new EncryptDecryptException("Unable to encrypt", e);
        }
    }

    public static String decrypt(String encryptedValue, String keyValue) throws EncryptDecryptException {
        try {
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, EncryptDecrypt.generateKey(keyValue));
            byte[] decodedValue = new BASE64Decoder().decodeBuffer(encryptedValue);
            return new String(c.doFinal(decodedValue));
        }
        catch (Exception e) {
            throw new EncryptDecryptException("Unable to decrypt", e);
        }
    }

    private static Key generateKey(String keyValue) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance(SHA);
        md.update(keyValue.getBytes(Charsets.UTF_8));
        String hash = new BASE64Encoder().encode(md.digest());
        String subStr = hash.substring(0, 16);
        return new SecretKeySpec(subStr.getBytes(), ALGORITHM);
    }
}

