/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dm.AusPlatformServiceDM;

public class ServiceDescriptor {
    private String name;
    private String version;
    private String eventListenerClass;
    private String callListenerClass;
    private static final Logger LOG = Logger.getLogger(ServiceDescriptor.class);
    private String sdkVersionBuiltWith;

    protected ServiceDescriptor(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public final String getName() {
        return this.name;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    public final String getVersion() {
        return this.version;
    }

    protected final void setVersion(String version) {
        this.version = version;
    }

    public final String getEventListenerClass() {
        return this.eventListenerClass;
    }

    protected final void setEventListenerClass(String eventListenerClass) {
        this.eventListenerClass = eventListenerClass != null ? eventListenerClass.trim() : null;
    }

    public final String getCallListenerClass() {
        return this.callListenerClass;
    }

    protected final void setCallListenerClass(String callListenerClass) {
        this.callListenerClass = callListenerClass != null ? callListenerClass.trim() : null;
    }

    public final String getSdkVersionBuiltWith() {
        return this.getSdkVersionForService(this.name, this.version);
    }

    public String getSdkVersionForService(String name, String version) {
        String applicationName = name + "-" + version;
        try {
            AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
            this.sdkVersionBuiltWith = dm.getSdkVersionByApplicationName(applicationName);
            if (this.sdkVersionBuiltWith == null) {
                return "3.1";
            }
            if (LOG.isFinerEnabled()) {
                LOG.finer((Object)("Sdk Version : " + this.sdkVersionBuiltWith));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to get Sdk version", (Throwable)e);
        }
        return this.sdkVersionBuiltWith;
    }
}

