/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import com.avaya.common.logging.helper.ResourceKey;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ParameterCoder {
    public static String decodeParameters(Object[] argumentList) {
        StringBuilder output = new StringBuilder("");
        if (argumentList != null) {
            for (int i = 0; i < argumentList.length; ++i) {
                if (argumentList[i] instanceof ResourceKey) {
                    output.append(((ResourceKey)argumentList[i]).getValue());
                } else if (argumentList[i] instanceof Date) {
                    String o = new SimpleDateFormat("@yyyy-MM-dd/HH:mm:ss.SSS").format((Date)argumentList[i]);
                    if (o != null) {
                        output.append(o.toString());
                    }
                } else if (argumentList[i] instanceof Number) {
                    if (argumentList[i].toString().contains(".")) {
                        DecimalFormat df = new DecimalFormat();
                        df.setGroupingUsed(false);
                        df.applyPattern("#.###E0");
                        output.append(Double.valueOf(df.format(argumentList[i])));
                    } else {
                        NumberFormat nf = NumberFormat.getInstance();
                        nf.setGroupingUsed(false);
                        output.append(Long.valueOf(nf.format(argumentList[i])));
                    }
                } else if (argumentList[i] instanceof String) {
                    String thisArgument = (String)argumentList[i];
                    thisArgument = thisArgument.replace("\\", "\\\\");
                    output.append("\"").append(thisArgument.replace("\"", "\\\"")).append("\"");
                }
                output.append(" ");
            }
        }
        return output.toString();
    }
}

