/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.ButtonCallbackAdapter;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.ConsoleNotifier;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.UpdateCallBack;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CEDeploymentWindow
extends ApplicationWindow
implements ConsoleNotifier {
    private int mWidth = 620;
    private int mHeight = 480;
    private UpdateCallBack updateCallback;
    private static String[] tabs = new String[]{"Server Configurations"};
    private String[] props = null;
    private CEProjectModel selectedProject;
    private Properties pDefault;

    public String[] getProps() {
        if (this.props != null) {
            return Arrays.copyOf(this.props, this.props.length);
        }
        return null;
    }

    public void setProps(String[] props) {
        this.props = props == null ? null : Arrays.copyOf(props, props.length);
    }

    public CEDeploymentWindow() {
        super(null);
        this.setBlockOnOpen(true);
    }

    public CEDeploymentWindow(Shell parent, UpdateCallBack updateCallback, int mWidth, int mHeight) {
        super(parent);
        this.mWidth = mWidth;
        this.mHeight = mHeight;
        this.updateCallback = updateCallback;
        this.setBlockOnOpen(true);
    }

    public UpdateCallBack getUpdateCallback() {
        return this.updateCallback;
    }

    public void setUpdateCallback(UpdateCallBack updateCallback) {
        this.updateCallback = updateCallback;
    }

    public void run() {
        this.setBlockOnOpen(true);
        PluginUtilities.getInstance().openWindow(this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (!PluginUtilities.getInstance().isDemoMode()) {
            shell.setText("Avaya Breeze\u00ae Developer Helper");
            shell.setSize(this.mWidth, this.mHeight);
        }
    }

    protected Control createContents(Composite parent) {
        return this.createContents(parent, null);
    }

    protected Control createContents(Composite parent, Composite composite) {
        final CTabFolder folder = new CTabFolder((Composite)this.getShell(), 128);
        folder.setSize(30, 150);
        folder.setUnselectedCloseVisible(false);
        folder.setSimple(false);
        for (int i = 0; i < tabs.length; ++i) {
            CTabItem item = new CTabItem(folder, 0);
            item.setText(tabs[i]);
        }
        folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Activator.log(1, "widget selected - " + folder.getSelection().getText());
                CEDeploymentWindow.this.createTabContents(folder);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                Activator.log(1, "widget default selected - " + folder.getSelection().getText());
                CEDeploymentWindow.this.createTabContents(folder);
            }
        });
        int width = parent.getSize().x;
        int height = parent.getSize().y;
        folder.setSize(width - 20, height - 50);
        PropertyWindowEditor.setShell(this.getShell());
        return folder;
    }

    public CEProjectModel getSelectedProject() {
        return this.selectedProject;
    }

    public void createTabContents(CTabFolder folder) {
        if (folder.getSelection().getText().equals("Server Configurations")) {
            folder.getSelection().setControl(PropertyWindowEditor.createPropertyContent(folder, this.props, new ButtonCallbackAdapter(this.getShell()){

                @Override
                public void onUpdate(Properties props) {
                    CEDeploymentWindow.this.updateCallback.onUpdate(props);
                }
            }, this.pDefault));
        }
        this.update();
    }

    public void update() {
        if (this.getShell() != null) {
            this.getShell().update();
        }
    }

    public void statusUpdate(String statusVal, String description) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CEDeploymentWindow.this.update();
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error updating deployment window", e);
                }
            }
        });
    }

    @Override
    public void log(String status, String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CEDeploymentWindow.this.update();
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error updating deployment window", e);
                }
            }
        });
    }

    public void setDfaultValues(Properties pDefault) {
        this.pDefault = pDefault;
    }
}

