/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.action;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.action.ActionDelegateAbstract;
import com.avaya.eclipse.plugin.handler.EDPLaunchShell;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Display;

public class SMGRTerminalLaunchAction
extends ActionDelegateAbstract {
    @Override
    public void run(IAction action) {
        Job myJob = new Job("Launch SMGR Terminal"){

            public IStatus run(IProgressMonitor monitor) {
                PropertyWindowEditor.validateConfigurations(true);
                List<ElementInfo> smgrElements = PropertyWindowEditor.getSMGREmements();
                if (smgrElements == null || smgrElements.size() == 0) {
                    CEOperation.openErrorDialog("Launch SMGR Terminal Failure", "Please select at least one System Manager for 'Launch System Manager Terminal' Avaya Breeze\u00ae Eclipse plug-in action.");
                    return Status.OK_STATUS;
                }
                for (final ElementInfo smgrElement : smgrElements) {
                    if (!PropertyWindowEditor.validateConnections(smgrElement, "SMGR", true)) continue;
                    try {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    new EDPLaunchShell("SMGR", smgrElement).execute(null);
                                }
                                catch (ExecutionException e) {
                                    Activator.log(4, 0, "Error launching SMGR terminal", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        Activator.log(4, 0, "Error launching SMGR terminal", e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        myJob.schedule();
    }
}

