/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.service.activity;

import com.avaya.collaboration.service.activity.ServiceActivityData;
import com.avaya.collaboration.service.activity.ServiceActivityDataFactoryDelegate;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;
import java.lang.reflect.Constructor;
import java.security.ProviderException;

public final class ServiceActivityDataFactory {
    private static volatile ServiceActivityDataFactoryDelegate serviceActivityFactoryDelegate;
    private static String serviceActivityFactoryImplName;
    private static String serviceName;
    private static String serviceVersion;
    private static boolean junitTestInProgress;

    private ServiceActivityDataFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ServiceActivityDataFactoryDelegate getServiceActivityFactoryDelegate() {
        if (serviceActivityFactoryDelegate != null) return serviceActivityFactoryDelegate;
        Class<ServiceActivityDataFactory> clazz = ServiceActivityDataFactory.class;
        synchronized (ServiceActivityDataFactory.class) {
            Constructor<?> clazzConstructor;
            Class<?> clazz2;
            if (!junitTestInProgress) {
                ServiceDescriptor serviceDescriptor = ServiceUtil.getServiceDescriptor();
                serviceName = serviceDescriptor.getName();
                serviceVersion = serviceDescriptor.getVersion();
            }
            try {
                clazz2 = Class.forName(serviceActivityFactoryImplName);
            }
            catch (Exception exception) {
                throw new ProviderException("forName: Failed to find delegate class for ServiceActivityDataFactory (" + serviceActivityFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
            }
            try {
                clazzConstructor = clazz2.getConstructor(String.class, String.class);
            }
            catch (Exception exception) {
                throw new ProviderException("getConstructor: Failed to find delegate class for ServiceActivityDataFactory (" + serviceActivityFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
            }
            try {
                serviceActivityFactoryDelegate = (ServiceActivityDataFactoryDelegate)clazzConstructor.newInstance(serviceName, serviceVersion);
            }
            catch (Exception e) {
                throw new ProviderException("Failed to find delegate class for ServiceActivityDataFactory (" + serviceActivityFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, e);
            }
            return serviceActivityFactoryDelegate;
        }
    }

    public static ServiceActivityData createServicActivityData() {
        return ServiceActivityDataFactory.getServiceActivityFactoryDelegate().getServicActivityData();
    }

    static {
        serviceActivityFactoryImplName = "com.avaya.collaboration.service.activity.ServiceActivityDataFactoryImpl";
        serviceName = null;
        serviceVersion = null;
        junitTestInProgress = false;
    }
}

