/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.deencapsulation;

import com.avaya.zephyr.common.testutils.deencapsulation.ParameterReflection;
import com.avaya.zephyr.common.testutils.deencapsulation.Utilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class MethodReflection {
    public static <T> T invoke(Class<?> theClass, Object targetInstance, String methodName, Class<?>[] paramTypes, Object ... methodArgs) {
        Method method = MethodReflection.findSpecifiedMethod(theClass, methodName, paramTypes);
        T result = MethodReflection.invoke(targetInstance, method, methodArgs);
        return result;
    }

    private static Method findSpecifiedMethod(Class<?> theClass, String methodName, Class<?>[] paramTypes) {
        for (Method declaredMethod : theClass.getDeclaredMethods()) {
            Class<?>[] declaredParameterTypes;
            int firstRealParameter;
            if (!declaredMethod.getName().equals(methodName) || (firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParameterTypes = declaredMethod.getParameterTypes(), paramTypes)) < 0 || !ParameterReflection.matchesParameterTypes(declaredMethod.getParameterTypes(), paramTypes, firstRealParameter)) continue;
            return declaredMethod;
        }
        Class<?> superClass = theClass.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return MethodReflection.findSpecifiedMethod(superClass, methodName, paramTypes);
        }
        String paramTypesDesc = ParameterReflection.getParameterTypesDescription(paramTypes);
        throw new IllegalArgumentException("Specified method not found: " + methodName + paramTypesDesc);
    }

    public static <T> T invokeWithCheckedThrows(Class<?> theClass, Object targetInstance, String methodName, Class<?>[] paramTypes, Object ... methodArgs) throws Throwable {
        Method method = MethodReflection.findSpecifiedMethod(theClass, methodName, paramTypes);
        T result = MethodReflection.invokeWithCheckedThrows(targetInstance, method, methodArgs);
        return result;
    }

    public static <T> T invoke(Object targetInstance, Method method, Object ... methodArgs) {
        Utilities.ensureThatMemberIsAccessible(method);
        try {
            return (T)method.invoke(targetInstance, methodArgs);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeWithCheckedThrows(Object targetInstance, Method method, Object ... methodArgs) throws Throwable {
        Utilities.ensureThatMemberIsAccessible(method);
        try {
            return (T)method.invoke(targetInstance, methodArgs);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failure to invoke method: " + method, e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static <T> T invoke(Class<?> theClass, Object targetInstance, String methodName, Object ... methodArgs) {
        Method method;
        boolean staticMethod = targetInstance == null;
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(methodArgs);
        Method method2 = method = staticMethod ? MethodReflection.findCompatibleStaticMethod(theClass, methodName, argTypes) : MethodReflection.findCompatibleMethod(theClass, methodName, argTypes);
        if (staticMethod && !Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Attempted to invoke non-static method without an instance to invoke it on");
        }
        T result = MethodReflection.invoke(targetInstance, method, methodArgs);
        return result;
    }

    private static Method findCompatibleStaticMethod(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        Method methodFound = MethodReflection.findCompatibleMethodInClass(theClass, methodName, argTypes);
        if (methodFound != null) {
            return methodFound;
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible static method found: " + methodName + argTypesDesc);
    }

    public static Method findCompatibleMethod(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        Method methodFound = null;
        while (true) {
            Class<?> superClass;
            Method compatibleMethod;
            if ((compatibleMethod = MethodReflection.findCompatibleMethodInClass(theClass, methodName, argTypes)) != null && (methodFound == null || ParameterReflection.hasMoreSpecificTypes(compatibleMethod.getParameterTypes(), methodFound.getParameterTypes()))) {
                methodFound = compatibleMethod;
            }
            if ((superClass = theClass.getSuperclass()) == null || superClass == Object.class) break;
            theClass = superClass;
        }
        if (methodFound != null) {
            return methodFound;
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible method found: " + methodName + argTypesDesc);
    }

    private static Method findCompatibleMethodInClass(Class<?> theClass, String methodName, Class<?>[] argTypes) {
        Method found = null;
        Class<?>[] foundParamTypes = null;
        for (Method declaredMethod : theClass.getDeclaredMethods()) {
            Class<?>[] declaredParamTypes;
            int firstRealParameter;
            if (!declaredMethod.getName().equals(methodName) || (firstRealParameter = ParameterReflection.indexOfFirstRealParameter(declaredParamTypes = declaredMethod.getParameterTypes(), argTypes)) < 0 || !ParameterReflection.matchesParameterTypes(declaredParamTypes, argTypes, firstRealParameter) && !ParameterReflection.acceptsArgumentTypes(declaredParamTypes, argTypes, firstRealParameter) || found != null && !ParameterReflection.hasMoreSpecificTypes(declaredParamTypes, foundParamTypes)) continue;
            found = declaredMethod;
            foundParamTypes = declaredParamTypes;
        }
        return found;
    }

    public static Method findNonPrivateHandlerMethod(Object handler) {
        Method nonPrivateMethod;
        Class<?> handlerClass = handler.getClass();
        while ((nonPrivateMethod = MethodReflection.findNonPrivateHandlerMethod(handlerClass)) == null && (handlerClass = handlerClass.getSuperclass()) != null && handlerClass != Object.class) {
        }
        if (nonPrivateMethod == null) {
            throw new IllegalArgumentException("No non-private invocation handler method found");
        }
        return nonPrivateMethod;
    }

    private static Method findNonPrivateHandlerMethod(Class<?> handlerClass) {
        Method[] declaredMethods = handlerClass.getDeclaredMethods();
        Method found = null;
        for (Method declaredMethod : declaredMethods) {
            if (Modifier.isPrivate(declaredMethod.getModifiers())) continue;
            if (found != null) {
                throw new IllegalArgumentException("More than one non-private invocation handler method found");
            }
            found = declaredMethod;
        }
        return found;
    }
}

