/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api.objectapi;

import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitMapRouterMatcher;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitMapRow;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitTree;
import java.io.Serializable;

public class DigitMapRouter
extends DigitTree<DigitMapRow>
implements Serializable {
    private static final Logger log = Logger.getLogger(DigitMapRouter.class);
    private static final long serialVersionUID = 4172685182703741357L;

    public void insert(String digits, short min, short max, DigitMapRow row) {
        this.insert(digits, min, max, row, new DigitMapRouterMatcher(row));
    }

    public void delete(String digits, short min, short max, DigitMapRow row) {
        this.delete(digits, min, max, new DigitMapRouterMatcher(row));
    }

    public void update(String digits, short min, short max, DigitMapRow row) {
        this.update(digits, min, max, row, new DigitMapRouterMatcher(row));
    }

    public DigitMapRow findBestMatch(String digits) {
        return super.findBestMatch(digits, new DigitMapRouterMatcher(null));
    }

    public Long getRoute(String digits) {
        DigitMapRow row = this.findBestMatch(digits);
        if (log.isFineEnabled()) {
            log.fine((Object)("getRoute(\"" + digits + "\") found " + row));
        }
        return row == null ? null : Long.valueOf(row.getId());
    }

    public String toString() {
        return this.dumpTree();
    }

    public static void setLogLevelForJUnit() {
    }
}

