/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusService;
import com.avaya.zephyr.platform.dal.api.objectapi.ServiceLevelTLSData;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import java.lang.invoke.LambdaMetafactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.collections.MapUtils;

public class AusServiceLevelTLSVersionDAO
extends DataAccessObject {
    private final Logger logger = Logger.getLogger(AusServiceLevelTLSVersionDAO.class);
    protected static final String SVERSION_CLUSTER_TABLE = "zr_map_sversion_cluster";
    protected static final String GET_SVERSION_CLUSTER_TLSDATA_QUERY = "select id, cluster_id, sversion_id, selected_tls_version from zr_map_sversion_cluster";
    protected static final String GET_SVERSION_CLUSTER_TLSDATA_QUERY_BY_ID = "select id, cluster_id, sversion_id, selected_tls_version from zr_map_sversion_cluster where id = ?";
    private Map<String, ServiceLevelTLSData> serviceToTLSDataMap;

    public AusServiceLevelTLSVersionDAO() {
        super(true);
    }

    public void init() {
        Map serviceToTLSDataMapTmp;
        this.logger.finer((Object)"init ENTER");
        try {
            serviceToTLSDataMapTmp = (Map)this.dataSource.executeQuery(GET_SVERSION_CLUSTER_TLSDATA_QUERY, new Object[0], (Object)this.getResultSetMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.logger.error((Object)"init Error initializing AusServiceLevelTLSVersionDAO", (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.serviceToTLSDataMap = serviceToTLSDataMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.logger.finer((Object)"init EXIT");
    }

    protected ResultSetMapper getResultSetMapper() {
        return new ResultSetMapper(){

            public Object mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<String, ServiceLevelTLSData> serviceToTLSData = new ConcurrentHashMap<String, ServiceLevelTLSData>();
                while (results.next()) {
                    Long serviceId = results.getLong("sversion_id");
                    Long clusterId = results.getLong("cluster_id");
                    serviceToTLSData.put(AusServiceLevelTLSVersionDAO.this.getSversionAndClusterKey(serviceId, clusterId), new ServiceLevelTLSData(results.getLong("id"), serviceId, clusterId, results.getString("selected_tls_version")));
                }
                return serviceToTLSData;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(SVERSION_CLUSTER_TABLE);
    }

    protected Object getMainCollection() {
        return new HashMap<String, ServiceLevelTLSData>(this.serviceToTLSDataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.logger.isFinerEnabled()) {
            this.logger.finer((Object)("updateDAO(" + tableEvent + ") ENTER"));
        }
        tableName = tableEvent.getTableName();
        id = tableEvent.getKey();
        operationType = tableEvent.getOperation();
        oldObject = null;
        newObject = null;
        if ("zr_map_sversion_cluster".equalsIgnoreCase(tableName)) {
            try {
                this.lock.acquireWriteLock();
                switch (2.$SwitchMap$com$avaya$asm$datamgr$dao$replication$DAOReplicationEvent$OperationType[operationType.ordinal()]) {
                    case 1: {
                        deletedTLSDataOptional = this.serviceToTLSDataMap.values().stream().filter((Predicate<ServiceLevelTLSData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$updateDAO$0(long com.avaya.zephyr.platform.dal.api.objectapi.ServiceLevelTLSData ), (Lcom/avaya/zephyr/platform/dal/api/objectapi/ServiceLevelTLSData;)Z)((long)id)).findFirst();
                        if (deletedTLSDataOptional.isPresent()) {
                            deletedTLSData = deletedTLSDataOptional.get();
                            oldObject = this.serviceToTLSDataMap.remove(this.getSversionAndClusterKey(deletedTLSData.getSVersionId(), deletedTLSData.getClusterId()));
                            ** break;
lbl18:
                            // 1 sources

                        } else {
                            this.logger.error((Object)("updateDAO - deleted record with id" + id + " not found"));
                            ** break;
                        }
lbl21:
                        // 1 sources

                        break;
                    }
                    case 2: 
                    case 3: {
                        newConfigData = this.getServiceLevelTLSData(id);
                        if (newConfigData == null) ** break;
                        newObject = newConfigData;
                        oldObject = this.serviceToTLSDataMap.put(this.getSversionAndClusterKey(newConfigData.getSVersionId(), newConfigData.getClusterId()), newConfigData);
                        break;
                    }
                    ** default:
lbl29:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            if (oldObject != null || newObject != null) {
                this.updateListeners(oldObject, newObject);
            }
        }
    }

    @SMConsole(parameterNames={"id"}, description="Get the Service Level TLS Data object for the given ID")
    public ServiceLevelTLSData getServiceLevelTLSData(long id) {
        ServiceLevelTLSData serviceLevelTLSData = null;
        Map serviceLevelTLSDataMap = null;
        try {
            serviceLevelTLSDataMap = (Map)this.dataSource.executeQuery(GET_SVERSION_CLUSTER_TLSDATA_QUERY_BY_ID, new Object[]{id}, (Object)this.getResultSetMapper());
        }
        catch (DMException e) {
            this.logger.error((Object)"getServiceLevelTLSData Error", (Throwable)e);
        }
        if (MapUtils.isNotEmpty(serviceLevelTLSDataMap)) {
            serviceLevelTLSData = (ServiceLevelTLSData)serviceLevelTLSDataMap.values().toArray()[0];
        }
        return serviceLevelTLSData;
    }

    protected AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)DMFactory.getInstance().getDataMgr(AusInstanceDAO.class);
    }

    protected AusServiceDAO getAusServiceDAO() {
        return (AusServiceDAO)DMFactory.getInstance().getDataMgr(AusServiceDAO.class);
    }

    protected String getSversionAndClusterKey(long sversionId, long clusterId) {
        return sversionId + "-" + clusterId;
    }

    @SMConsole(parameterNames={"serviceName", "serviceVersion"}, description="Get the cluster level TLS Version for the given service version")
    public String getServiceLevelTLSVersionForMyCluster(String serviceName, String serviceVresion) {
        long clusterId;
        AusService serviceNameVersion = this.getAusServiceDAO().getServiceByApplicationName(serviceName + "-" + serviceVresion);
        if (serviceNameVersion == null) {
            throw new IllegalArgumentException("Service " + serviceName + "-" + serviceVresion + " can not be found on cluster");
        }
        long sVersionId = serviceNameVersion.getId();
        ServiceLevelTLSData serviceLevelTLSData = this.serviceToTLSDataMap.get(this.getSversionAndClusterKey(sVersionId, clusterId = this.getAusInstanceDAO().getMyClusterId().longValue()));
        if (serviceLevelTLSData != null) {
            return serviceLevelTLSData.getSelectedTLSVersion();
        }
        throw new IllegalArgumentException("TLS Version not found for " + serviceName + "-" + serviceVresion);
    }

    private static /* synthetic */ boolean lambda$updateDAO$0(long id, ServiceLevelTLSData tlsData) {
        return tlsData.getId() == id;
    }
}

