/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationClientFeatureMapping;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationClientScope;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationFeature;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientFeatureDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(ClientFeatureDAO.class);
    private static final String ZR_MAP_AUTHZ_CLIENT_FEATURE = "ZR_MAP_AUTHZ_CLIENT_FEATURE";
    private static final String ZR_AUTHORIZATION_FEATURE = "ZR_AUTHORIZATION_FEATURE";
    private static final String ZR_AUTHORIZATION_CLIENT = "ZR_AUTHORIZATION_CLIENT";
    private static final String ZR_AUTHORIZATION_RESOURCE = "ZR_AUTHORIZATION_RESOURCE";
    private static final String GET_CLIENT_CLIENTAPPID = " SELECT ZR_AUTHORIZATION_CLIENT.ID AS CLIENTID, CLIENT_APP_ID FROM ZR_AUTHORIZATION_CLIENT";
    private static final String GET_CLIENT_FEATURE_MAPPING = "SELECT ZR_MAP_AUTHZ_CLIENT_FEATURE.FEATURE_ID AS FEATUREID, ZR_MAP_AUTHZ_CLIENT_FEATURE.CLIENT_ID AS CLIENTID, ZR_MAP_AUTHZ_CLIENT_FEATURE.ID AS MAPPINGID, ZR_AUTHORIZATION_CLIENT.CLIENT_APP_ID AS CLIENTAPPID FROM ZR_MAP_AUTHZ_CLIENT_FEATURE, ZR_AUTHORIZATION_CLIENT WHERE ZR_AUTHORIZATION_CLIENT.ID=ZR_MAP_AUTHZ_CLIENT_FEATURE.CLIENT_ID";
    private static final String GET_CLIENT_FEATURE_MAPPING_BY_MAP_ID = "SELECT ZR_MAP_AUTHZ_CLIENT_FEATURE.FEATURE_ID AS FEATUREID, ZR_MAP_AUTHZ_CLIENT_FEATURE.CLIENT_ID AS CLIENTID, ZR_MAP_AUTHZ_CLIENT_FEATURE.ID AS MAPPINGID, ZR_AUTHORIZATION_CLIENT.CLIENT_APP_ID AS CLIENTAPPID FROM ZR_MAP_AUTHZ_CLIENT_FEATURE, ZR_AUTHORIZATION_CLIENT WHERE ZR_AUTHORIZATION_CLIENT.ID=ZR_MAP_AUTHZ_CLIENT_FEATURE.CLIENT_ID AND ZR_MAP_AUTHZ_CLIENT_FEATURE.ID=?";
    private static final String GET_CLIENT_FEATURE_MAPPING_BY_CLIENT_ID = "SELECT ZR_MAP_AUTHZ_CLIENT_FEATURE.FEATURE_ID AS FEATUREID, ZR_MAP_AUTHZ_CLIENT_FEATURE.CLIENT_ID AS CLIENTID, ZR_MAP_AUTHZ_CLIENT_FEATURE.ID AS MAPPINGID, ZR_AUTHORIZATION_CLIENT.CLIENT_APP_ID AS CLIENTAPPID FROM ZR_MAP_AUTHZ_CLIENT_FEATURE, ZR_AUTHORIZATION_CLIENT WHERE ZR_AUTHORIZATION_CLIENT.ID=ZR_MAP_AUTHZ_CLIENT_FEATURE.CLIENT_ID AND ZR_AUTHORIZATION_CLIENT.ID=?";
    private static final String GET_FEATURES = "SELECT ZR_AUTHORIZATION_RESOURCE.ID AS RESOURCEID, ZR_AUTHORIZATION_RESOURCE.RESOURCE_NAME AS RESOURCENAME, ZR_AUTHORIZATION_RESOURCE.CLUSTER_ID AS CLUSTERID, ZR_AUTHORIZATION_FEATURE.FEATURE_NAME AS FEATURENAME, ZR_AUTHORIZATION_FEATURE.FEATURE_VALUE AS FEATUREVALUE, ZR_AUTHORIZATION_FEATURE.ID AS FEATUREID FROM ZR_AUTHORIZATION_FEATURE, ZR_AUTHORIZATION_RESOURCE WHERE ZR_AUTHORIZATION_RESOURCE.ID=ZR_AUTHORIZATION_FEATURE.AUTHORIZATION_RESOURCE_ID";
    private static final String GET_FEATURE_BY_ID = "SELECT ZR_AUTHORIZATION_RESOURCE.ID AS RESOURCEID, ZR_AUTHORIZATION_RESOURCE.RESOURCE_NAME AS RESOURCENAME, ZR_AUTHORIZATION_RESOURCE.CLUSTER_ID AS CLUSTERID, ZR_AUTHORIZATION_FEATURE.FEATURE_NAME AS FEATURENAME, ZR_AUTHORIZATION_FEATURE.FEATURE_VALUE AS FEATUREVALUE, ZR_AUTHORIZATION_FEATURE.ID AS FEATUREID FROM ZR_AUTHORIZATION_FEATURE, ZR_AUTHORIZATION_RESOURCE WHERE ZR_AUTHORIZATION_RESOURCE.ID=ZR_AUTHORIZATION_FEATURE.AUTHORIZATION_RESOURCE_ID AND ZR_AUTHORIZATION_FEATURE.ID=?";
    private static final String GET_FEATURE_BY_RESOURCE_ID = "SELECT ZR_AUTHORIZATION_RESOURCE.ID AS RESOURCEID, ZR_AUTHORIZATION_RESOURCE.RESOURCE_NAME AS RESOURCENAME, ZR_AUTHORIZATION_RESOURCE.CLUSTER_ID AS CLUSTERID, ZR_AUTHORIZATION_FEATURE.FEATURE_NAME AS FEATURENAME, ZR_AUTHORIZATION_FEATURE.FEATURE_VALUE AS FEATUREVALUE, ZR_AUTHORIZATION_FEATURE.ID AS FEATUREID FROM ZR_AUTHORIZATION_FEATURE, ZR_AUTHORIZATION_RESOURCE WHERE ZR_AUTHORIZATION_RESOURCE.ID=ZR_AUTHORIZATION_FEATURE.AUTHORIZATION_RESOURCE_ID AND ZR_AUTHORIZATION_RESOURCE.ID=?";
    private Map<Long, List<AuthorizationClientFeatureMapping>> clientIdToclientAppFeatureId = new ConcurrentHashMap<Long, List<AuthorizationClientFeatureMapping>>();
    private Map<String, Long> clientAppIdToclientIdMap = new ConcurrentHashMap<String, Long>();
    private Map<Long, AuthorizationFeature> featureIdToFeature = new ConcurrentHashMap<Long, AuthorizationFeature>();

    protected final ResultSetMapper getClientAppIdToclientIdMapper() {
        return new ResultSetMapper(){

            public Map<String, Long> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<String, Long> clientAppIdToclientIdMapTmp = new ConcurrentHashMap<String, Long>();
                while (results.next()) {
                    Long id = (Long)results.getObject("CLIENTID");
                    String clientAppId = results.getString("CLIENT_APP_ID");
                    clientAppIdToclientIdMapTmp.put(clientAppId, id);
                }
                if (!clientAppIdToclientIdMapTmp.isEmpty()) {
                    return clientAppIdToclientIdMapTmp;
                }
                return null;
            }
        };
    }

    protected final ResultSetMapper getFeatureIdToFeatureMapperByResourceId() {
        return new ResultSetMapper(){

            public List<AuthorizationFeature> mapResults(ResultSet results) throws SQLException, DMException {
                ArrayList<AuthorizationFeature> features = new ArrayList<AuthorizationFeature>();
                while (results.next()) {
                    AuthorizationFeature authFeature = new AuthorizationFeature(results.getLong("FEATUREID"), results.getString("FEATURENAME"), results.getString("RESOURCENAME"), results.getLong("RESOURCEID"), results.getString("FEATUREVALUE"), results.getLong("CLUSTERID"));
                    features.add(authFeature);
                }
                if (!features.isEmpty()) {
                    return features;
                }
                return null;
            }
        };
    }

    protected final ResultSetMapper getFeatureIdToFeatureMapperByFeatureId() {
        return new ResultSetMapper(){

            public AuthorizationFeature mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    AuthorizationFeature authFeature = new AuthorizationFeature(results.getLong("FEATUREID"), results.getString("FEATURENAME"), results.getString("RESOURCENAME"), results.getLong("RESOURCEID"), results.getString("FEATUREVALUE"), results.getLong("CLUSTERID"));
                    return authFeature;
                }
                return null;
            }
        };
    }

    protected final ResultSetMapper getclientIdToclientAppFeatureIdMapperByMapId() {
        return new ResultSetMapper(){

            public AuthorizationClientFeatureMapping mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    AuthorizationClientFeatureMapping authClientFeatureMapping = new AuthorizationClientFeatureMapping(results.getLong("FEATUREID"), results.getString("CLIENTAPPID"), results.getLong("CLIENTID"), results.getLong("MAPPINGID"));
                    return authClientFeatureMapping;
                }
                return null;
            }
        };
    }

    protected final ResultSetMapper getclientIdToclientAppFeatureIdMapperByClientId() {
        return new ResultSetMapper(){

            public List<AuthorizationClientFeatureMapping> mapResults(ResultSet results) throws SQLException, DMException {
                ArrayList<AuthorizationClientFeatureMapping> authClientFeaturemappings = new ArrayList<AuthorizationClientFeatureMapping>();
                while (results.next()) {
                    AuthorizationClientFeatureMapping authClientFeatureMapping = new AuthorizationClientFeatureMapping(results.getLong("FEATUREID"), results.getString("CLIENTAPPID"), results.getLong("CLIENTID"), results.getLong("MAPPINGID"));
                    authClientFeaturemappings.add(authClientFeatureMapping);
                }
                if (!authClientFeaturemappings.isEmpty()) {
                    return authClientFeaturemappings;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map featureIdToFeatureTmp;
        Map clientAppIdToclientIdMapTmp;
        Map clientIdToclientAppFeatureIdTmp;
        ClientIdToclientAppFeatureIdMapper clientIdToclientAppFeatureIdMapper = new ClientIdToclientAppFeatureIdMapper();
        FeatureIdToFeatureMapper featureIdToFeatureMapper = new FeatureIdToFeatureMapper();
        try {
            Object[] params = new Object[]{};
            clientIdToclientAppFeatureIdTmp = (Map)this.dataSource.executeQuery(GET_CLIENT_FEATURE_MAPPING, params, (Object)clientIdToclientAppFeatureIdMapper);
            clientAppIdToclientIdMapTmp = (Map)this.dataSource.executeQuery(GET_CLIENT_CLIENTAPPID, params, (Object)this.getClientAppIdToclientIdMapper());
            featureIdToFeatureTmp = (Map)this.dataSource.executeQuery(GET_FEATURES, params, (Object)featureIdToFeatureMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (clientIdToclientAppFeatureIdTmp != null) {
                this.clientIdToclientAppFeatureId = clientIdToclientAppFeatureIdTmp;
            }
            if (clientAppIdToclientIdMapTmp != null) {
                this.clientAppIdToclientIdMap = clientAppIdToclientIdMapTmp;
            }
            if (featureIdToFeatureTmp != null) {
                this.featureIdToFeature = featureIdToFeatureTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("zr_authorization_client", "zr_authorization_feature", "zr_authorization_resource", "zr_map_authz_client_feature");
    }

    protected Object getMainCollection() {
        return this.clientIdToclientAppFeatureId;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Client Feature DAO event: " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null) {
            if (tableName.equalsIgnoreCase(ZR_AUTHORIZATION_CLIENT)) {
                this.updateAuthClient(operation, id);
            }
            if (tableName.equalsIgnoreCase(ZR_AUTHORIZATION_FEATURE)) {
                this.updateAuthFeature(operation, id);
            }
            if (tableName.equalsIgnoreCase(ZR_AUTHORIZATION_RESOURCE)) {
                this.updateAuthResource(operation, id);
            }
            if (tableName.equalsIgnoreCase(ZR_MAP_AUTHZ_CLIENT_FEATURE)) {
                this.updateAuthClientMapping(operation, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthClientMapping(DAOReplicationEvent.OperationType operation, Long id) {
        List<AuthorizationClientFeatureMapping> authClientFeatureMappings;
        Long clientId;
        AuthorizationClientFeatureMapping newObject;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            for (List<AuthorizationClientFeatureMapping> authClientFeatureMappings2 : this.clientIdToclientAppFeatureId.values()) {
                AuthorizationClientFeatureMapping authClientFeatureMapping = this.getUpdatedMappingEntry(id, authClientFeatureMappings2);
                if (authClientFeatureMapping == null) continue;
                authClientFeatureMappings2.remove(authClientFeatureMapping);
                return;
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                newObject = (AuthorizationClientFeatureMapping)this.dataSource.executeQuery(GET_CLIENT_FEATURE_MAPPING_BY_MAP_ID, new Object[]{id}, (Object)this.getclientIdToclientAppFeatureIdMapperByMapId());
                this.lock.acquireWriteLock();
                try {
                    clientId = newObject.getClientId();
                    authClientFeatureMappings = this.clientIdToclientAppFeatureId.get(clientId);
                    AuthorizationClientFeatureMapping authClientFeatureMapping = this.getUpdatedMappingEntry(id, authClientFeatureMappings);
                    if (authClientFeatureMapping != null) {
                        authClientFeatureMappings.remove(authClientFeatureMapping);
                    }
                    authClientFeatureMappings.add(newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_CLIENT " + e.getMessage()));
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = (AuthorizationClientFeatureMapping)this.dataSource.executeQuery(GET_CLIENT_FEATURE_MAPPING_BY_MAP_ID, new Object[]{id}, (Object)this.getclientIdToclientAppFeatureIdMapperByMapId());
                this.lock.acquireWriteLock();
                try {
                    clientId = newObject.getClientId();
                    authClientFeatureMappings = this.clientIdToclientAppFeatureId.get(clientId);
                    if (authClientFeatureMappings == null) {
                        this.clientIdToclientAppFeatureId.put(clientId, new ArrayList());
                        this.clientIdToclientAppFeatureId.get(clientId).add(newObject);
                    } else {
                        authClientFeatureMappings.add(newObject);
                    }
                    authClientFeatureMappings = this.clientIdToclientAppFeatureId.get(clientId);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_CLIENT " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthFeature(DAOReplicationEvent.OperationType operation, Long id) {
        AuthorizationFeature newObject = null;
        AuthorizationFeature oldObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            this.lock.acquireWriteLock();
            try {
                oldObject = this.featureIdToFeature.remove(id);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                newObject = (AuthorizationFeature)this.dataSource.executeQuery(GET_FEATURE_BY_ID, new Object[]{id}, (Object)this.getFeatureIdToFeatureMapperByFeatureId());
                this.lock.acquireWriteLock();
                try {
                    this.featureIdToFeature.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_FEATURE " + e.getMessage()));
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = (AuthorizationFeature)this.dataSource.executeQuery(GET_FEATURE_BY_ID, new Object[]{id}, (Object)this.getFeatureIdToFeatureMapperByFeatureId());
                this.lock.acquireWriteLock();
                try {
                    this.featureIdToFeature.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_FEATURE " + e.getMessage()));
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    private AuthorizationClientFeatureMapping getUpdatedMappingEntry(Long id, List<AuthorizationClientFeatureMapping> authClientFeatureMappings) {
        for (AuthorizationClientFeatureMapping authClientFeatureMapping : authClientFeatureMappings) {
            if (!authClientFeatureMapping.getMappingId().equals(id)) continue;
            return authClientFeatureMapping;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthClient(DAOReplicationEvent.OperationType operation, Long id) {
        List<AuthorizationClientFeatureMapping> authClientFeatureMapping;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE) && (authClientFeatureMapping = this.clientIdToclientAppFeatureId.get(id)) != null) {
            this.clientAppIdToclientIdMap.remove(authClientFeatureMapping.get(0).getClientAppId());
            this.clientIdToclientAppFeatureId.remove(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                List newObject = (List)this.dataSource.executeQuery(GET_CLIENT_FEATURE_MAPPING_BY_CLIENT_ID, new Object[]{id}, (Object)this.getclientIdToclientAppFeatureIdMapperByClientId());
                this.lock.acquireWriteLock();
                try {
                    List<AuthorizationClientFeatureMapping> oldObject = this.clientIdToclientAppFeatureId.get(id);
                    String oldClientAppId = oldObject.get(0).getClientAppId();
                    if (id != null && newObject != null) {
                        this.clientIdToclientAppFeatureId.put(id, newObject);
                        String newClientAppId = ((AuthorizationClientFeatureMapping)newObject.get(0)).getClientAppId();
                        this.clientAppIdToclientIdMap.remove(oldClientAppId);
                        this.clientAppIdToclientIdMap.put(newClientAppId, id);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_CLIENT " + e.getMessage()));
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                this.lock.acquireWriteLock();
                Object[] params = new Object[]{};
                this.clientAppIdToclientIdMap = (Map)this.dataSource.executeQuery(GET_CLIENT_CLIENTAPPID, params, (Object)this.getClientAppIdToclientIdMapper());
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_CLIENT " + e.getMessage()));
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuthResource(DAOReplicationEvent.OperationType operation, Long id) {
        List newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                newObject = (List)this.dataSource.executeQuery(GET_FEATURE_BY_RESOURCE_ID, new Object[]{id}, (Object)this.getFeatureIdToFeatureMapperByResourceId());
                this.lock.acquireWriteLock();
                try {
                    for (AuthorizationFeature authFeature : newObject) {
                        Long featureId = authFeature.getFeatureId();
                        if (this.featureIdToFeature.get(featureId) == null) continue;
                        this.featureIdToFeature.put(featureId, authFeature);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table ZR_AUTHORIZATION_RESOURCE " + e.getMessage()));
            }
        }
    }

    @SMConsole(description="Get the scopes of user ID")
    public List<AuthorizationClientScope> getClientFeatures(String clientAppId) {
        List<AuthorizationClientFeatureMapping> authClientFeatureMapping;
        Map<Long, List<AuthorizationClientScope>> clusterIdToFeatures;
        ArrayList<AuthorizationClientScope> scopes = new ArrayList<AuthorizationClientScope>();
        Long clientId = this.clientAppIdToclientIdMap.get(clientAppId);
        if (clientId != null && !(clusterIdToFeatures = this.getClientFeatureByClusterId(authClientFeatureMapping = this.clientIdToclientAppFeatureId.get(clientId))).isEmpty()) {
            for (List<AuthorizationClientScope> authClientScopes : clusterIdToFeatures.values()) {
                for (AuthorizationClientScope authClientScope : authClientScopes) {
                    scopes.add(authClientScope);
                }
            }
        }
        return scopes;
    }

    private Map<Long, List<AuthorizationClientScope>> getClientFeatureByClusterId(List<AuthorizationClientFeatureMapping> authClientFeatureMapping) {
        ConcurrentHashMap<Long, List<AuthorizationClientScope>> clusterIdToFeatures = new ConcurrentHashMap<Long, List<AuthorizationClientScope>>();
        if (authClientFeatureMapping == null || authClientFeatureMapping.isEmpty()) {
            return clusterIdToFeatures;
        }
        for (AuthorizationClientFeatureMapping authClientFeature : authClientFeatureMapping) {
            List<Object> featureValues;
            List features;
            Long featureId = authClientFeature.getFeatureId();
            AuthorizationFeature authFeature = this.featureIdToFeature.get(featureId);
            Long clusterId = authFeature.getClusterId();
            if (clusterIdToFeatures.get(clusterId) == null) {
                features = new ArrayList();
                AuthorizationClientScope authScope = new AuthorizationClientScope();
                featureValues = new ArrayList<String>();
                featureValues.add(authFeature.getFeatureValue());
                authScope.setFeatureValue(featureValues);
                authScope.setFeatureName(authFeature.getFeatureName());
                authScope.setResourceName(authFeature.getResourceName());
                authScope.setClusterId(clusterId);
                features.add((AuthorizationClientScope)authScope);
                clusterIdToFeatures.put(clusterId, features);
                continue;
            }
            features = (List)clusterIdToFeatures.get(clusterId);
            AuthorizationClientScope authClientScope = this.getExistingFeatureResource(authFeature, features);
            if (authClientScope != null) {
                featureValues = authClientScope.getFeatureValue();
                if (featureValues.contains(authFeature.getFeatureValue())) continue;
                featureValues.add(authFeature.getFeatureValue());
                continue;
            }
            AuthorizationClientScope newCLientScope = new AuthorizationClientScope();
            newCLientScope.setClusterId(clusterId);
            newCLientScope.setResourceName(authFeature.getResourceName());
            newCLientScope.setFeatureName(authFeature.getFeatureName());
            ArrayList<String> featureValues2 = new ArrayList<String>();
            featureValues2.add(authFeature.getFeatureValue());
            newCLientScope.setFeatureValue(featureValues2);
            features.add((AuthorizationClientScope)newCLientScope);
        }
        return clusterIdToFeatures;
    }

    private AuthorizationClientScope getExistingFeatureResource(AuthorizationFeature authFeature, List<AuthorizationClientScope> features) {
        for (AuthorizationClientScope authClientScope : features) {
            if (!authFeature.getFeatureName().equals(authClientScope.getFeatureName()) || !authFeature.getResourceName().equals(authClientScope.getResourceName())) continue;
            return authClientScope;
        }
        return null;
    }

    @SMConsole(description="Get the scopes of user ID")
    public List<String> getAllClientIds() {
        ArrayList<String> clientIds = new ArrayList<String>();
        if (this.clientAppIdToclientIdMap != null && !this.clientAppIdToclientIdMap.isEmpty()) {
            Iterator<String> iterator = this.clientAppIdToclientIdMap.keySet().iterator();
            while (iterator.hasNext()) {
                clientIds.add(iterator.next());
            }
        }
        return clientIds;
    }

    public static class FeatureIdToFeatureMapper
    implements ResultSetMapper {
        public Map<Long, AuthorizationFeature> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, AuthorizationFeature> featureIdToFeatureTmp = new ConcurrentHashMap<Long, AuthorizationFeature>();
            while (results.next()) {
                Long id = (Long)results.getObject("FEATUREID");
                AuthorizationFeature authFeature = new AuthorizationFeature(results.getLong("FEATUREID"), results.getString("FEATURENAME"), results.getString("RESOURCENAME"), results.getLong("RESOURCEID"), results.getString("FEATUREVALUE"), results.getLong("CLUSTERID"));
                featureIdToFeatureTmp.put(id, authFeature);
            }
            if (!featureIdToFeatureTmp.isEmpty()) {
                return featureIdToFeatureTmp;
            }
            return null;
        }
    }

    public static class ClientIdToclientAppFeatureIdMapper
    implements ResultSetMapper {
        public Map<Long, List<AuthorizationClientFeatureMapping>> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, List<AuthorizationClientFeatureMapping>> clientIdToclientAppFeatureIdTmp = new ConcurrentHashMap<Long, List<AuthorizationClientFeatureMapping>>();
            while (results.next()) {
                Long id = (Long)results.getObject("CLIENTID");
                AuthorizationClientFeatureMapping authClientFeatureMapping = new AuthorizationClientFeatureMapping(results.getLong("FEATUREID"), results.getString("CLIENTAPPID"), results.getLong("CLIENTID"), results.getLong("MAPPINGID"));
                ArrayList<AuthorizationClientFeatureMapping> authClientFeatureMappings = (ArrayList<AuthorizationClientFeatureMapping>)clientIdToclientAppFeatureIdTmp.get(id);
                if (authClientFeatureMappings == null || authClientFeatureMappings.isEmpty()) {
                    authClientFeatureMappings = new ArrayList<AuthorizationClientFeatureMapping>();
                    authClientFeatureMappings.add(authClientFeatureMapping);
                    clientIdToclientAppFeatureIdTmp.put(id, authClientFeatureMappings);
                    continue;
                }
                authClientFeatureMappings.add(authClientFeatureMapping);
            }
            if (!clientIdToclientAppFeatureIdTmp.isEmpty()) {
                return clientIdToclientAppFeatureIdTmp;
            }
            return null;
        }
    }
}

