/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.ServiceAttributeDefault;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceAttributeDefaultDAO
extends DataAccessObject {
    private static final String getAllServiceAttributeDefault = "SELECT * FROM zr_service_attribute_default";
    private Map<Long, ServiceAttributeDefault> serviceAttributeDefaultMap;
    private static final Logger LOG = AsmLogger.getLogger(ServiceAttributeDefaultDAO.class);

    public void init() {
        Map tmpMap;
        try {
            tmpMap = (Map)this.dataSource.executeQuery(getAllServiceAttributeDefault, new Object[0], (Object)this.getServiceAttributeDefaultMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent((GenericAlarmRecoveryIntf)this, (Exception)((Object)e));
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.serviceAttributeDefaultMap = tmpMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @SMConsole(description="Get all Zephyr Template Service Attributes")
    public Map<Long, ServiceAttributeDefault> getAllServiceAttributeDefaults() {
        if (LOG.isFinestEnabled()) {
            LOG.finest((Object)("getAllServiceAttributeDefaults: Returning " + this.serviceAttributeDefaultMap));
        }
        return this.serviceAttributeDefaultMap;
    }

    public ServiceAttributeDefault getServiceAttributeDefault(Long id) {
        return this.serviceAttributeDefaultMap.get(id);
    }

    protected ResultSetMapper getServiceAttributeDefaultMapper() {
        return new RSMgetServiceAttributeDefaultMapper();
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        this.reinit();
    }

    public List<String> getDependentTables() {
        return Arrays.asList("zr_service_attribute_default");
    }

    protected Object getMainCollection() {
        return this.serviceAttributeDefaultMap;
    }

    public static class RSMgetServiceAttributeDefaultMapper
    implements ResultSetMapper {
        public Map<Long, ServiceAttributeDefault> mapResults(ResultSet results) throws SQLException, DMException {
            HashMap<Long, ServiceAttributeDefault> tmpMap = new HashMap<Long, ServiceAttributeDefault>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                tmpMap.put(id, new ServiceAttributeDefault(id, (Long)results.getObject("service_id"), results.getString("name"), results.getString("avaya_value"), results.getString("client_value"), results.getString("avaya_user_changeable"), results.getString("client_user_changeable"), results.getString("help_info"), results.getString("validation"), results.getString("minimum"), results.getString("maximum"), results.getString("pattern"), results.getBoolean("must_be_non_null"), (Long)results.getObject("enum_set_id")));
            }
            return tmpMap;
        }
    }
}

