/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.call;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallFactoryInterface;
import com.avaya.collaboration.call.Identity;
import com.avaya.collaboration.call.Participant;
import com.avaya.commons.lang.ArgAssert;

public final class CallFactory {
    private static CallFactoryInterface instance;

    static synchronized void setInstance(CallFactoryInterface inst) {
        if (instance != null) {
            return;
        }
        instance = inst;
    }

    static CallFactoryInterface getInstance() {
        return instance;
    }

    private CallFactory() {
    }

    public static Call getCall(String id) {
        return CallFactory.getInstance().getCall(id);
    }

    public static Call create(Participant callingParty, String target) {
        ArgAssert.assertNotNull((Object)callingParty, (String)"callingParty");
        ArgAssert.assertNotEmpty((String)target, (String)"target");
        return CallFactory.getInstance().create(callingParty, target);
    }

    public static Call create(String from, String to, Identity onBehalfOf) {
        ArgAssert.assertNotBlank((String)from, (String)"from");
        ArgAssert.assertNotBlank((String)to, (String)"to");
        ArgAssert.assertNotNull((Object)onBehalfOf);
        return CallFactory.getInstance().create(from, to, onBehalfOf);
    }
}

