/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.call.speech.search.sample;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallListenerAbstract;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.TheCallListener;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaListener;
import com.avaya.collaboration.call.media.MediaListenerAbstract;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.call.media.PlayOperationCause;
import com.avaya.collaboration.call.speech.search.SearchOptions;
import com.avaya.collaboration.call.speech.search.SpeechFactory;
import com.avaya.collaboration.call.speech.search.SpeechSearchListener;
import com.avaya.collaboration.call.speech.search.match.SpeechSearchMatch;
import com.avaya.collaboration.call.speech.search.query.Concept;
import com.avaya.collaboration.call.speech.search.query.SearchQuery;
import com.avaya.collaboration.call.speech.voicexml.VoiceXMLDialogCause;
import com.avaya.collaboration.call.speech.voicexml.VoiceXMLDialogItem;
import com.avaya.collaboration.call.speech.voicexml.VoiceXMLDialogListener;
import com.avaya.collaboration.util.logger.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@TheCallListener
public class SampleUnifiedSpeechCall
extends CallListenerAbstract {
    private final Logger logger = Logger.getLogger(SampleUnifiedSpeechCall.class);
    private static final float SAMPLE_THRESHHOLD = 45.0f;
    private static final double SAMPLE_DURATION_SECS = 30.0;

    @Override
    public void callIntercepted(Call call) {
        SearchQuery searchQuery = this.createSearchQuery();
        SearchOptions options = SpeechFactory.createSearchOptions().setLanguage("en_US").setSearchQuery(searchQuery);
        UUID searchID = SpeechFactory.createSpeechService().startSearch(call, options, (SpeechSearchListener)new MySpeechSearchListener());
        this.logger.info("callIntercepted: Search started with UUID " + searchID.toString());
    }

    @Override
    public void callAnswered(Call call) {
        Participant participant = call.getCallingParty();
        MediaService mediaService = MediaFactory.createMediaService();
        PlayItem playItem = null;
        try {
            playItem = MediaFactory.createPlayItem().setSource("Your call is currently being monitored");
        }
        catch (URISyntaxException e) {
            this.logger.info("callAnswered: An error occured. Please check that text to speech message is valid.");
        }
        UUID ttsRequestId = mediaService.play(participant, playItem, (MediaListener)new MyMediaListener(participant));
        this.logger.info("callAnswered: Started a play request for a text to speech  with UUID " + ttsRequestId);
    }

    public SearchQuery createSearchQuery() {
        Concept greeting = SpeechFactory.createConcept().setName("Greeting").setOperator(SpeechFactory.createAnyOperator()).setThreshold(45.0f).addPhrase("Good Morning", 45.0f).addPhrase("Hello", 45.0f);
        Concept introduction = SpeechFactory.createConcept().setName("Introduction of Agent and Department").setOperator(SpeechFactory.createAnyOperator()).setThreshold(45.0f).addPhrase("Welcome to", 45.0f).addPhrase("My name is", 45.0f);
        Concept opening = SpeechFactory.createConcept().setName("Opening").setOperator(SpeechFactory.createAllOperator().setDuration(30.0)).setThreshold(45.0f).setSubConcepts(greeting, introduction);
        Concept selling = SpeechFactory.createConcept().setName("Selling").setOperator(SpeechFactory.createAllOperator()).setThreshold(45.0f).addPhrase("Would you like to buy", 45.0f).addPhrase("Could I offer you", 45.0f);
        Concept closing = SpeechFactory.createConcept().setName("Closing").setOperator(SpeechFactory.createAllOperator()).setThreshold(45.0f).addPhrase("Thank you for calling", 45.0f).addPhrase("We appreciate your call", 45.0f);
        return SpeechFactory.createSearchQuery().setLangauge("en_US").setConcepts(opening, selling, closing);
    }

    protected class MyMediaListener
    extends MediaListenerAbstract
    implements VoiceXMLDialogListener {
        private final Participant participant;

        public MyMediaListener(Participant participant) {
            this.participant = participant;
        }

        @Override
        public void playCompleted(UUID requestId, PlayOperationCause cause) {
            SampleUnifiedSpeechCall.this.logger.info("playCompleted: We completed playing Text-to-speech. Next, send a VoiceXML dialog request for speech recognition.");
            VoiceXMLDialogItem dialogItem = null;
            try {
                dialogItem = SpeechFactory.createVoiceXMLDialogItem().setVoiceXMLScript(new URI("http://www.mycompany.com/menu.vxml"));
            }
            catch (URISyntaxException e) {
                SampleUnifiedSpeechCall.this.logger.info("playCompleted: An error occured. Please check that your VoiceXML URL is valid.");
            }
            UUID asrRequestId = SpeechFactory.createSpeechService().startVoiceXMLDialog(this.participant, dialogItem, this);
            SampleUnifiedSpeechCall.this.logger.info("playCompleted: Search a voice recognition dialog with UUID " + asrRequestId);
        }

        @Override
        public void dialogEvent(UUID requestId, Map<String, Object> names, VoiceXMLDialogCause dialogEvent) {
            SampleUnifiedSpeechCall.this.logger.info("dialogEvent: We completed VoiceXML speech recognition.");
        }
    }

    private class MySpeechSearchListener
    implements SpeechSearchListener {
        private MySpeechSearchListener() {
        }

        @Override
        public void matchFound(UUID searchId, Call call, List<SpeechSearchMatch> matches) {
            for (SpeechSearchMatch match : matches) {
                SampleUnifiedSpeechCall.this.logger.info("matchFound: A match has been found for " + match.getName() + " at " + match.getStartTime() + " seconds");
            }
        }

        @Override
        public void startSearchFailed(UUID searchId, Exception execption) {
            SampleUnifiedSpeechCall.this.logger.info("startSearchFailed: The search failed due to errors[" + execption.getMessage() + "]");
        }

        @Override
        public void terminated(UUID searchId, String reason) {
            SampleUnifiedSpeechCall.this.logger.info("terminated: The search was terminated due to " + reason);
        }
    }
}

