/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationClientScope;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationUserScope;
import com.avaya.zephyr.platform.dal.api.objectapi.UserAuthorizationDetails;
import com.avaya.zephyr.platform.dao.AgentDetailsDAO;
import com.avaya.zephyr.platform.dao.ClientFeatureDAO;
import com.avaya.zephyr.platform.dao.CommunicationAddressDAO;
import com.avaya.zephyr.platform.dao.MailboxDetailsDAO;
import com.avaya.zephyr.platform.dao.StationDetailsDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AuthorizationDetailsDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AuthorizationDetailsDAO.class);
    private static final String CSUSER = "CSUSER";
    private static final String GET_USER_LOGINNAME = "SELECT ID AS USERID, LOGINNAME AS LOGINNAME, ISDELETED, SOURCE, DN FROM CSUSER";
    private static final String GET_USER_LOGINNAME_BY_ID = "SELECT ID AS USERID, LOGINNAME AS LOGINNAME, ISDELETED, SOURCE, DN FROM CSUSER WHERE ID=?";
    private Map<Long, UserAuthorizationDetails> userIdToUserDetailsMap = new ConcurrentHashMap<Long, UserAuthorizationDetails>();
    private Map<String, Long> loginNameToUserIdMap = new ConcurrentHashMap<String, Long>();
    private static final String COMMUNICATION_ADDRESS_FEATURE = "CommunicationAddress";
    private static final String AGENT_NUMBERS_FEATURE = "AgentId";
    private static final String STATION_NUMBERS_FEATURE = "StationExtension";
    private static final String MAILBOX_NUMBERS_FEATURE = "MailboxNumber";
    private CommunicationAddressDAO commAddressDAO;
    private AgentDetailsDAO agentDetailsDAO;
    private StationDetailsDAO stationDetailsDAO;
    private MailboxDetailsDAO mailBoxDetailsDAO;
    private ClientFeatureDAO clientFeatureDAO;
    private ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);

    protected void setDM(ZephyrDM dm) {
        this.dm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map loginNametoUserIdMapTmp;
        Map userIdTologinNameMapTmp;
        try {
            UserUserDetailsMapper userUserDetailsMapper = new UserUserDetailsMapper();
            LoginNameUserMapper loginNameUserMapper = new LoginNameUserMapper();
            Object[] params = new Object[]{};
            userIdTologinNameMapTmp = (Map)this.dataSource.executeQuery(GET_USER_LOGINNAME, params, (Object)userUserDetailsMapper);
            loginNametoUserIdMapTmp = (Map)this.dataSource.executeQuery(GET_USER_LOGINNAME, params, (Object)loginNameUserMapper);
            this.agentDetailsDAO = this.dm.getAgentDetailsDAO();
            this.mailBoxDetailsDAO = this.dm.getMailboxDetailsDAO();
            this.stationDetailsDAO = this.dm.getStationDetailsDAO();
            this.commAddressDAO = this.dm.getCommunicationAddressDAO();
            this.clientFeatureDAO = this.dm.getClientFeatureDAO();
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            if (userIdTologinNameMapTmp != null) {
                this.userIdToUserDetailsMap = userIdTologinNameMapTmp;
            }
            if (loginNametoUserIdMapTmp != null) {
                this.loginNameToUserIdMap = loginNametoUserIdMapTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
    }

    protected final ResultSetMapper getUserLoginNameMapperById() {
        return new ResultSetMapper(){

            public UserAuthorizationDetails mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    UserAuthorizationDetails userDetails = new UserAuthorizationDetails(results.getString("LOGINNAME"), results.getString("DN"), results.getString("SOURCE"));
                    return userDetails;
                }
                return null;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList("csuser");
    }

    protected Object getMainCollection() {
        return this.loginNameToUserIdMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Authorization Details DAO event: " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null && tableName.equalsIgnoreCase(CSUSER)) {
            this.updateCsUser(operation, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCsUser(DAOReplicationEvent.OperationType operation, Long id) {
        UserAuthorizationDetails newObject;
        Object oldObject;
        block14: {
            oldObject = null;
            newObject = null;
            if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                try {
                    this.lock.acquireWriteLock();
                    UserAuthorizationDetails userDetails = this.userIdToUserDetailsMap.get(id);
                    if (userDetails != null && userDetails.getLoginName() != null) {
                        this.userIdToUserDetailsMap.remove(id);
                        this.loginNameToUserIdMap.remove(userDetails.getLoginName());
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                newObject = this.handleCsUserUpdate(id);
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                try {
                    newObject = (UserAuthorizationDetails)this.dataSource.executeQuery(GET_USER_LOGINNAME_BY_ID, new Object[]{id}, (Object)this.getUserLoginNameMapperById());
                    if (newObject == null) break block14;
                    this.lock.acquireWriteLock();
                    try {
                        this.userIdToUserDetailsMap.put(id, newObject);
                        this.loginNameToUserIdMap.put(newObject.getLoginName(), id);
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                catch (DMException e) {
                    this.log.error((Object)("Error while updating Cache for table CSUSER " + e.getMessage()));
                }
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserAuthorizationDetails handleCsUserUpdate(Long id) {
        UserAuthorizationDetails newObject = null;
        try {
            newObject = (UserAuthorizationDetails)this.dataSource.executeQuery(GET_USER_LOGINNAME_BY_ID, new Object[]{id}, (Object)this.getUserLoginNameMapperById());
            IsDeletedUserMapper isDeletedUserMapper = new IsDeletedUserMapper();
            Boolean isDeleted = (Boolean)this.dataSource.executeQuery(GET_USER_LOGINNAME_BY_ID, new Object[]{id}, (Object)isDeletedUserMapper);
            this.lock.acquireWriteLock();
            try {
                UserAuthorizationDetails userDetails = this.userIdToUserDetailsMap.get(id);
                if (userDetails != null && isDeleted.booleanValue() && userDetails.getLoginName() != null) {
                    this.userIdToUserDetailsMap.remove(id);
                    this.loginNameToUserIdMap.remove(userDetails.getLoginName());
                } else if (newObject != null) {
                    this.userIdToUserDetailsMap.put(id, newObject);
                    if (userDetails != null && userDetails.getLoginName() != null) {
                        this.loginNameToUserIdMap.remove(userDetails.getLoginName());
                    }
                    this.loginNameToUserIdMap.put(newObject.getLoginName(), id);
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        catch (DMException e) {
            this.log.error((Object)("Error while updating Cache for table CSUSER " + e.getMessage()));
        }
        catch (Exception e) {
            this.log.error((Object)("Error while updating cache" + e.getMessage()));
        }
        return newObject;
    }

    @SMConsole(description="Get base dn of a user")
    public String getBaseDN(String loginName) {
        UserAuthorizationDetails userDetails;
        Long userId;
        if (this.loginNameToUserIdMap != null && (userId = this.loginNameToUserIdMap.get(loginName)) != null && (userDetails = this.userIdToUserDetailsMap.get(userId)) != null) {
            return userDetails.getDn();
        }
        return null;
    }

    @SMConsole(description="Get datasource of a user")
    public String getDataSourceForUser(String loginName) {
        UserAuthorizationDetails userDetails;
        Long userId;
        if (this.loginNameToUserIdMap != null && (userId = this.loginNameToUserIdMap.get(loginName)) != null && (userDetails = this.userIdToUserDetailsMap.get(userId)) != null) {
            return userDetails.getDataSource();
        }
        return null;
    }

    @SMConsole(description="Get the scopes of user")
    public List<AuthorizationUserScope> getUserScopes(String loginName) {
        Long userId;
        ArrayList<AuthorizationUserScope> scopes = new ArrayList<AuthorizationUserScope>();
        if (this.loginNameToUserIdMap != null && (userId = this.loginNameToUserIdMap.get(loginName)) != null) {
            List<String> mailboxNumbers;
            List<String> agentNumbers;
            List<String> stationNumbers;
            List<String> commAddresses = this.commAddressDAO.getCommAddresses(userId);
            if (!commAddresses.isEmpty()) {
                scopes.add(new AuthorizationUserScope(COMMUNICATION_ADDRESS_FEATURE, commAddresses));
            }
            if (!(stationNumbers = this.stationDetailsDAO.getStationExtensions(userId)).isEmpty()) {
                scopes.add(new AuthorizationUserScope(STATION_NUMBERS_FEATURE, stationNumbers));
            }
            if (!(agentNumbers = this.agentDetailsDAO.getAgentExtensions(userId)).isEmpty()) {
                scopes.add(new AuthorizationUserScope(AGENT_NUMBERS_FEATURE, agentNumbers));
            }
            if (!(mailboxNumbers = this.mailBoxDetailsDAO.getMailboxNumbers(userId)).isEmpty()) {
                scopes.add(new AuthorizationUserScope(MAILBOX_NUMBERS_FEATURE, mailboxNumbers));
            }
        }
        return scopes;
    }

    @SMConsole(description="Get the scopes of client ID")
    public List<AuthorizationClientScope> getClientScopes(String clientAppId) {
        return this.clientFeatureDAO.getClientFeatures(clientAppId);
    }

    public static class IsDeletedUserMapper
    implements ResultSetMapper {
        public Boolean mapResults(ResultSet results) throws SQLException, DMException {
            if (results.next()) {
                return results.getBoolean("ISDELETED");
            }
            return false;
        }
    }

    public static class LoginNameUserMapper
    implements ResultSetMapper {
        public Map<String, Long> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<String, Long> loginNameToUserIdMapTmp = new ConcurrentHashMap<String, Long>();
            while (results.next()) {
                Long id = (Long)results.getObject("USERID");
                String loginName = results.getString("LOGINNAME");
                if (results.getBoolean("ISDELETED")) continue;
                loginNameToUserIdMapTmp.put(loginName, id);
            }
            if (!loginNameToUserIdMapTmp.isEmpty()) {
                return loginNameToUserIdMapTmp;
            }
            return null;
        }
    }

    public static class UserUserDetailsMapper
    implements ResultSetMapper {
        public Map<Long, UserAuthorizationDetails> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, UserAuthorizationDetails> userIdToUserDetailsMapTmp = new ConcurrentHashMap<Long, UserAuthorizationDetails>();
            while (results.next()) {
                Long id = (Long)results.getObject("USERID");
                UserAuthorizationDetails userDetails = new UserAuthorizationDetails(results.getString("LOGINNAME"), results.getString("DN"), results.getString("SOURCE"));
                if (results.getBoolean("ISDELETED")) continue;
                userIdToUserDetailsMapTmp.put(id, userDetails);
            }
            if (!userIdToUserDetailsMapTmp.isEmpty()) {
                return userIdToUserDetailsMapTmp;
            }
            return null;
        }
    }
}

