/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.GlobalParmEntry;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class GlobalParmDAO
extends DataAccessObject {
    private GlobalParmEntry globalParmEntry;
    private static final Logger LOG = AsmLogger.getLogger(GlobalParmDAO.class);
    protected static final String ZR_GLOBAL_PARM = "zr_global_parm";
    protected static final String getGlobalParmEntryQuery = "SELECT id, is_whitelist_enabled, is_challenge_enabled, ams_license_limit From zr_global_parm";
    protected static final String getGlobalParmEntryById = "SELECT id, is_whitelist_enabled, is_challenge_enabled, ams_license_limit From zr_global_parm where id = ?";

    public GlobalParmDAO() {
        super(true);
    }

    public GlobalParmEntry getGlobalParmEntry() {
        return this.globalParmEntry;
    }

    protected void setGlobalParmEntry(GlobalParmEntry globalParmEntry) {
        this.globalParmEntry = globalParmEntry;
    }

    public void init() {
        GlobalParmEntry globalParmEntryTmp;
        try {
            globalParmEntryTmp = (GlobalParmEntry)this.dataSource.executeQuery(getGlobalParmEntryQuery, new Object[0], (Object)this.globalParmEntryMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOG.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.globalParmEntry = globalParmEntryTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    protected ResultSetMapper globalParmEntryMapper() {
        return new ResultSetMapper(){

            public GlobalParmEntry mapResults(ResultSet results) throws SQLException, DMException {
                GlobalParmEntry gpE = null;
                while (results.next()) {
                    gpE = GlobalParmDAO.this.getEntry(results);
                }
                return gpE;
            }
        };
    }

    private GlobalParmEntry getEntry(ResultSet results) throws SQLException {
        if (results != null) {
            return new GlobalParmEntry(results.getLong("id"), results.getBoolean("is_whitelist_enabled"), results.getBoolean("is_challenge_enabled"), results.getInt("ams_license_limit"));
        }
        return null;
    }

    protected ResultSetMapper globalParmEntryMapperById() {
        return new ResultSetMapper(){

            public GlobalParmEntry mapResults(ResultSet results) throws SQLException, DMException {
                GlobalParmEntry entry = null;
                while (results.next()) {
                    entry = GlobalParmDAO.this.getEntry(results);
                }
                return entry;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_GLOBAL_PARM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        Object oldEntry = null;
        GlobalParmEntry newEntry = null;
        if (tableEvent.getTableName().equals(ZR_GLOBAL_PARM) && tableEvent.getOperation() != null) {
            try {
                this.lock.acquireWriteLock();
                if (tableEvent.getOperation().equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                    this.globalParmEntry = null;
                } else {
                    try {
                        this.globalParmEntry = newEntry = (GlobalParmEntry)this.dataSource.executeQuery(getGlobalParmEntryById, new Object[]{id}, (Object)this.globalParmEntryMapperById());
                    }
                    catch (DMException e) {
                        LOG.error((Object)("Error while updating cache for change in table zr_global_parm For id=" + id + " Exception:" + e.getMessage()));
                        this.reinit();
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            if (oldEntry != null || newEntry != null) {
                this.updateListeners(oldEntry, newEntry);
            }
        }
    }

    protected Object getMainCollection() {
        return null;
    }
}

