/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.handler;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.model.ElementInfo;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.shells.ui.view.SystemCommandsUI;
import org.eclipse.rse.internal.shells.ui.view.SystemCommandsViewPart;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class EDPLaunchShell
extends AbstractHandler
implements IPartListener {
    private String systemType;
    private ElementInfo elementInfo;
    private IShellServiceSubSystem shellServiceSubSystem;
    private IRemoteCommandShell cmdShell;

    public EDPLaunchShell(String systemType, ElementInfo elementInfo) {
        this.systemType = systemType;
        this.elementInfo = elementInfo;
    }

    private IHost getCurrentHost(String name) {
        ISystemProfile profile;
        ISystemRegistry systemRegistry = PluginUtilities.getInstance().getTheSystemRegistry();
        IHost host = systemRegistry.getHost(profile = systemRegistry.getSystemProfileManager().getDefaultPrivateSystemProfile(), name);
        if (host == null) {
            ArrayList<ElementInfo> elements = new ArrayList<ElementInfo>();
            elements.add(this.elementInfo);
            PropertyWindowEditor.createRSESystem(elements);
        }
        return systemRegistry.getHost(profile, name);
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        String name = this.systemType + "-" + this.elementInfo.getIp();
        this.shellServiceSubSystem = PluginUtilities.getInstance().getShellServiceSubSystem(this.getCurrentHost(name));
        if (this.shellServiceSubSystem != null) {
            this.shellServiceSubSystem.getConnectorService().setPort(this.elementInfo.getPort());
            if (!this.shellServiceSubSystem.isConnected()) {
                try {
                    this.shellServiceSubSystem.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error connecting to " + this.elementInfo.getIp(), e);
                }
            }
            if (this.shellServiceSubSystem.isConnected()) {
                try {
                    this.cmdShell = this.shellServiceSubSystem.getDefaultShell();
                    SystemCommandsViewPart cmdsPart = SystemCommandsUI.getInstance().activateCommandsView();
                    cmdsPart.updateOutput(this.cmdShell);
                    cmdsPart.showPageFor(this.cmdShell);
                    cmdsPart.getViewSite().getPage().addPartListener((IPartListener)this);
                }
                catch (Exception ex) {
                    Activator.log(4, 0, "Error connecting to " + this.elementInfo.getIp(), ex);
                }
            }
        }
        return null;
    }

    public void partClosed(IWorkbenchPart ipart) {
        if (this.shellServiceSubSystem != null) {
            try {
                this.cmdShell.removeOutput();
                this.shellServiceSubSystem.disconnect();
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error while disconnecting terminal", e);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart arg0) {
        Activator.log(0, "EDPLaunchShell deactivated");
    }

    public void partActivated(IWorkbenchPart arg0) {
        Activator.log(0, "EDPLaunchShell activated");
    }

    public void partOpened(IWorkbenchPart arg0) {
        Activator.log(0, "EDPLaunchShell opened");
    }

    public void partBroughtToTop(IWorkbenchPart arg0) {
        Activator.log(0, "EDPLaunchShell part brought on top");
    }
}

