/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.ssh.SSHConnectionGroup;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CECommandExecOperation
extends CEOperation {
    private String command;

    public CECommandExecOperation(IProject project, String command) {
        this.project = project;
        this.command = command;
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.setMessageConsoleStream();
        IStatus status = Status.OK_STATUS;
        CEProjectModel ceModelP = null;
        if (this.project != null) {
            ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
        } else {
            ceModelP = new CEProjectModel();
            CEProjectUtils.setAssociatedElements(ceModelP);
        }
        this.startOperation(ceModelP);
        return status;
    }

    public void startOperation(CEProjectModel cep) {
        block5: {
            try {
                List<ElementInfo> smgrList = cep.getAssociatedElements();
                if (smgrList != null && smgrList.size() == 0) {
                    CEOperation.openErrorDialog("Command Execution Failure", "Please select at least one Node 'System Manager/Avaya Breeze\u00ae' to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                    return;
                }
                if (smgrList != null && smgrList.size() > 0) {
                    for (ElementInfo elem : smgrList) {
                        SSHConnectionGroup sshcg = new SSHConnectionGroup(elem.getAssociatedElements());
                        sshcg.startUpdating(this);
                        sshcg.execute(this.command);
                        sshcg.stopUpdating(this);
                    }
                }
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error executing command", e);
                if (PluginUtilities.getInstance().isDemoMode()) break block5;
                CECommandExecOperation.openDialog("Command Execution Failure", e.getMessage());
            }
        }
    }
}

